# バッチ設計書 7-export.sh

## 概要

本ドキュメントは、LLVMリリース用ソースアーカイブ作成スクリプト「export.sh」の設計仕様を記載したものです。

### 本バッチの処理概要

本バッチは、LLVMリリース用のソースコードtarballを生成するスクリプトです。llvm-projectの統合tarballに加え、オプションで各サブプロジェクト（llvm、clang、compiler-rt等）の個別tarballを生成できます。また、test-suiteのtarballも生成します。

**業務上の目的・背景**：LLVMの公式リリースでは、ユーザーがビルドに必要なソースコードをダウンロードできるようにtarball形式で配布する必要があります。本バッチは、指定されたリリースバージョンまたはgit refに基づいてソースをエクスポートし、標準化された命名規則でtarballを生成します。これにより、リリースプロセスにおけるソースアーカイブ生成を自動化し、一貫性を確保します。

**バッチの実行タイミング**：リリースマネージャーがリリース候補または最終リリースの準備時に手動で実行します。

**主要な処理内容**：
1. コマンドライン引数の解析（リリースバージョン、RC番号、オプション）
2. git refまたはリリースタグに基づくバージョン決定
3. llvm-project統合tarballの生成（git archive）
4. test-suite tarballの生成（GitHubからダウンロード）
5. サブプロジェクト別tarball生成（-sub-projectsオプション）
6. バージョン情報ファイルの生成（リリース番号、RC、gitリビジョン）

**前後の処理との関連**：本バッチは独立して実行されます。生成されたtarballはリリースプロセスでダウンロードサイトにアップロードされます。

**影響範囲**：カレントディレクトリに各種tarballとメタデータファイルを生成します。

## バッチ種別

リリースソースアーカイブ生成

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | リリースごと |
| 実行時刻 | 手動実行 |
| 実行曜日 | 該当なし |
| 実行日 | リリーススケジュールに依存 |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Git環境 | gitコマンドが利用可能、llvm-projectリポジトリ内で実行 |
| xz | xz圧縮ツールが利用可能 |
| curl | GitHubからtest-suiteダウンロード用 |
| envsubst | テンプレート展開用 |

### 実行可否判定

-releaseオプションまたは-git-refオプションのいずれかが必須。-git-ref使用時は-release/-rcと併用不可。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -release | string | Yes* | なし | リリースバージョン（X.Y.Z形式） |
| -rc | number | No | なし | RC番号 |
| -final | flag | No | なし | 最終リリースフラグ |
| -git-ref | string | Yes* | なし | 任意のgit ref（スナップショット用） |
| -sub-projects | flag | No | なし | サブプロジェクト別tarball生成 |
| -template | string | No | ${PROJECT}-${RELEASE}${RC}.src.tar.xz | ファイル名テンプレート |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| llvm-projectリポジトリ | Git | ローカルgitリポジトリ |
| test-suite GitHubリポジトリ | tarball | テストスイートソース |
| cmake/Modules/LLVMVersion.cmake | CMake | バージョン情報取得 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| llvm-project-{VERSION}{RC}.src.tar.xz | tarball | 統合ソースアーカイブ |
| test-suite-{VERSION}{RC}.src.tar.xz | tarball | テストスイートアーカイブ |
| {subproject}-{VERSION}{RC}.src.tar.xz | tarball | サブプロジェクト別アーカイブ |
| llvm-release-{YYYYMMDD}.txt | テキスト | リリースバージョン |
| llvm-rc-{YYYYMMDD}.txt | テキスト | RC番号 |
| llvm-git-revision-{YYYYMMDD}.txt | テキスト | gitリビジョンSHA |

### 出力ファイル仕様

| 項目 | 内容 |
|-----|------|
| ファイル名 | テンプレートベース（プレースホルダ展開） |
| 出力先 | カレントディレクトリ |
| 文字コード | UTF-8（メタデータファイル） |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ リリースバージョン、RC、オプション取得
2. 排他チェック
   └─ -git-refと-release/-rcの排他確認
3. リリースバージョン決定
   └─ -git-ref指定時はLLVMVersion.cmakeから抽出
4. タグ名構築
   └─ llvmorg-{VERSION}[-{RC}]
5. メタデータファイル生成
   └─ リリース番号、RC、gitリビジョンを出力
6. llvm-project tarball生成
   └─ git archive | xz
7. test-suite tarball生成
   └─ GitHubからダウンロード・パッケージング
8. サブプロジェクトtarball生成（オプション）
   └─ 各プロジェクトディレクトリでgit archive
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{-git-ref指定?}
    C -->|Yes| D[CMakeからバージョン取得]
    C -->|No| E[引数からバージョン取得]
    D --> F[タグ名構築]
    E --> F
    F --> G[メタデータファイル生成]
    G --> H[llvm-project tarball生成]
    H --> I{-git-ref指定?}
    I -->|No| J[test-suite tarball生成]
    I -->|Yes| K{-sub-projects?}
    J --> K
    K -->|Yes| L[サブプロジェクトtarball生成]
    K -->|No| M[バッチ終了]
    L --> M
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | -git-refと-release/-rc両方指定 | どちらか一方のみ指定 |
| 1 | 引数エラー | -releaseも-git-refも未指定 | いずれかを指定 |
| 1 | 環境エラー | gitリポジトリ外で実行 | llvm-projectリポジトリ内で実行 |
| 非0 | Git エラー | git archiveが失敗 | タグ/refの存在を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. 指定したタグまたはgit refが存在するか確認
2. gitリポジトリの状態を確認（git status）
3. ネットワーク接続を確認（test-suiteダウンロード時）

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（ファイルシステム操作のみ） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のアーカイブ生成 |
| 目標処理時間 | 数分〜数十分（サブプロジェクト数依存） |
| メモリ使用量上限 | 環境依存 |

## 排他制御

test-suiteディレクトリが既存の場合はダウンロードをスキップ。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | tarball生成時 | "Creating tarball for {project} ..." |
| 情報ログ | バージョン取得時 | "git revision: {sha}" |
| エラーログ | エラー発生時 | エラーメッセージ |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 手動確認 |

## 備考

- サブプロジェクトリスト：llvm、bolt、clang、cmake、compiler-rt、libcxx、libcxxabi、libclc、clang-tools-extra、polly、lldb、lld、openmp、libunwind、mlir、flang、runtimes、third-party
- テンプレートプレースホルダ：$PROJECT、$RELEASE、$RC、$YYYYMMDD、$GIT_REF
- xz圧縮は-T0オプションで全CPUコアを使用
- tarの--sort=name、--owner=0、--group=0で再現性を確保
- umask 0022を設定して適切なファイルパーミッション
- -git-ref使用時はtest-suiteをスキップ（タグが存在しない可能性）
- スナップショット生成例：`./export.sh --git-ref upstream/main --template '${PROJECT}-${YYYYMMDD}.src.tar.xz'`
