# バッチ設計書 8-merge-request.sh

## 概要

本ドキュメントは、Bugzillaへのマージリクエスト提出スクリプト「merge-request.sh」の設計仕様を記載したものです。

### 本バッチの処理概要

本バッチは、LLVMの安定版リリースブランチへのマージリクエストをBugzillaに自動登録するスクリプトです。指定されたリビジョン番号に基づいてバグチケットを作成し、リリースメタバグにブロック関係を設定します。

**業務上の目的・背景**：LLVMの安定版リリースでは、特定のコミットをリリースブランチにバックポートする必要があります。このプロセスを管理するため、マージリクエストはBugzillaで追跡されます。本バッチは、このマージリクエストの作成を自動化し、一貫した形式でチケットを登録することで、リリースマネージャーの作業を効率化します。

**バッチの実行タイミング**：開発者がリリースブランチへのマージをリクエストする際に手動で実行します。

**主要な処理内容**：
1. コマンドライン引数の解析（ユーザー、安定版バージョン、リビジョン番号等）
2. Bugzilla CLIツールの存在確認とバージョンチェック
3. 重複バグの確認
4. SVNからコミットメッセージを取得
5. Bugzillaにログイン
6. 新規バグを作成（リリースメタバグへのブロック設定付き）
7. リビジョンへのリンクをコメントとして追加

**前後の処理との関連**：本バッチで作成されたバグチケットは、リリースマネージャーによってレビューされ、承認されるとリリースブランチにマージされます。

**影響範囲**：Bugzilla（bugs.llvm.org）に新規バグを登録し、コメントを追加します。

## バッチ種別

リリース管理・バグ追跡

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（マージリクエスト発生時） |
| 実行時刻 | 手動実行 |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bugzilla CLIツール | bugzillaコマンド（python-bugzilla）がインストール済み |
| バージョン要件 | bugzilla CLIバージョン2.0.0以上 |
| ネットワーク | bugs.llvm.orgへのアクセスが可能 |
| 認証情報 | Bugzillaアカウントのメールアドレス |

### 実行可否判定

-user、-stable-version、-rオプションがすべて必須。bugzillaコマンドが利用可能で、バージョン2.0.0以上であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| -user | string | Yes | なし | Bugzillaログイン用メールアドレス |
| -stable-version | string | Yes | なし | 安定版バージョン（例：4.0, 5.0, ..., 9.0） |
| -r | number | Yes | なし | マージ対象リビジョン番号（複数指定可） |
| -project | string | No | なし | プロジェクト名（未使用） |
| -component | string | No | new bugs | Bugzillaコンポーネント |
| -bugzilla-bin | string | No | 自動検出 | bugzillaコマンドのパス |
| -assign-to | string | No | なし | バグの担当者メールアドレス |
| -dry-run | flag | No | なし | ドライランモード（実行せずコマンド表示） |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| SVNリポジトリ | svn log | コミットメッセージ取得 |
| Bugzilla XMLRPC API | XMLRPC | バグ操作 |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| Bugzilla | バグチケット | 新規マージリクエストバグ |
| 標準出力 | テキスト | 作成されたバグURL |

### 出力ファイル仕様

本バッチはファイル出力を行いません。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 該当なし |
| 文字コード | 該当なし |
| 区切り文字 | 該当なし |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ ユーザー、バージョン、リビジョン取得
2. 必須パラメータ検証
   └─ stable-version、revisions、userの確認
3. リリースメタバグID取得
   └─ バージョンに対応するメタバグIDをマッピング
4. Bugzilla CLIバージョン確認
   └─ バージョン2.0.0以上を要求
5. 重複バグ確認
   └─ 同一リビジョンのリクエストが既存か確認
6. コミットメッセージ取得
   └─ SVN logからサマリを抽出
7. Bugzillaログイン
   └─ bugzilla login実行
8. バグ作成
   └─ bugzilla newでチケット作成
9. リビジョンリンク追加
   └─ 各リビジョンへのリンクをコメントに追加
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C[必須パラメータ検証]
    C --> D[メタバグID取得]
    D --> E[Bugzilla CLIバージョン確認]
    E --> F[重複バグ確認]
    F --> G{重複あり?}
    G -->|Yes| H[エラー終了]
    G -->|No| I[コミットメッセージ取得]
    I --> J[Bugzillaログイン]
    J --> K{dry-run?}
    K -->|Yes| L[コマンド表示]
    K -->|No| M[バグ作成]
    L --> N[バッチ終了]
    M --> O[リビジョンリンク追加]
    O --> N
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはBugzilla（外部システム）を操作します。

| 処理 | 対象 | 操作種別 | 概要 |
|-----|------|---------|------|
| バグ作成 | Bugzilla | CREATE | 新規マージリクエストバグを登録 |
| コメント追加 | Bugzilla | UPDATE | リビジョンリンクをコメントとして追加 |
| 重複確認 | Bugzilla | QUERY | 既存バグを検索 |

### テーブル別操作詳細

#### Bugzillaバグフィールド

| フィールド | 設定値 | 備考 |
|-----|-----------------|------|
| Product | new-bugs | 固定値 |
| Component | new bugs | デフォルト、-componentで変更可 |
| Version | 安定版バージョン | -stable-versionの値 |
| Blocked | リリースメタバグID | バージョン別にマッピング |
| cf_fixed_by_commits | r{リビジョン番号} | カスタムフィールド |
| Summary | Merge r{番号} into the {version} branch : {コミットサマリ} | 自動生成 |
| Description | Is it OK to merge the following revision(s)...? | 固定テンプレート |

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | 必須パラメータ未指定 | 必須オプションを指定 |
| 1 | 引数エラー | 無効な安定版バージョン | 対応バージョン（4.0-9.0）を指定 |
| 1 | 環境エラー | bugzillaコマンドが見つからない | python-bugzillaをインストール |
| 1 | バージョンエラー | bugzilla CLIが1.x系 | バージョン2.0.0以上にアップデート |
| 1 | 重複エラー | 同一リビジョンのリクエストが既存 | 既存バグを確認 |
| 非0 | APIエラー | Bugzilla操作が失敗 | ネットワーク、認証を確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. Bugzillaへのネットワーク接続を確認
2. 認証情報（メールアドレス）を確認
3. bugzilla CLIのバージョンを確認
4. -dry-runで生成されるコマンドを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 各Bugzilla操作は独立 |
| コミットタイミング | 各API呼び出し時 |
| ロールバック条件 | ロールバック不可（手動でバグをクローズ） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1バグ作成 |
| 目標処理時間 | 数秒〜数十秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

重複チェックにより、同一リビジョンの重複リクエストを防止。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| 情報ログ | 重複確認時 | "Checking for duplicate bugs..." |
| 情報ログ | 重複確認完了時 | "Done" |
| 情報ログ | バグ作成完了時 | "Created new bug:" + URL |
| エラーログ | 重複発見時 | "Duplicate bug found:" + バグ情報 |
| エラーログ | 作成失敗時 | "Failed to create bug." |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 手動確認 |

## 備考

- 対応安定版バージョンとメタバグID：
  - 4.0: 32061
  - 5.0: 34492
  - 6.0: 36649
  - 7.0: 39106
  - 8.0: 41221
  - 9.0: 43360
- Bugzilla XMLRPC URL: https://bugs.llvm.org/xmlrpc.cgi
- リビジョンリンク形式: https://reviews.llvm.org/rL{リビジョン番号}
- 複数リビジョンを-rオプションで複数回指定可能
- SVNリポジトリURL: https://llvm.org/svn/llvm-project/
- set -xでコマンドトレースを有効化（デバッグ用）
- 注意：このスクリプトはSVN時代のLLVMを対象としており、現在のGitベースのワークフローでは使用されない可能性があります
