# バッチ設計書 9-get-llvm-version.sh

## 概要

本ドキュメントは、LLVMバージョン取得スクリプト「get-llvm-version.sh」の設計仕様を記載したものです。

### 本バッチの処理概要

本バッチは、LLVMソースコードのCMakeファイル（LLVMVersion.cmake）からバージョン情報（メジャー、マイナー、パッチ）を抽出して出力するユーティリティスクリプトです。

**業務上の目的・背景**：LLVMの各種スクリプトやビルドプロセスでは、現在のLLVMバージョンを取得する必要があります。本バッチは、CMakeファイルを直接パースすることで、信頼性の高いバージョン情報を提供します。これにより、リリーススクリプトやCI/CDパイプラインでバージョン依存の処理を自動化できます。

**バッチの実行タイミング**：他のスクリプトから呼び出されるか、手動でバージョン確認時に実行します。

**主要な処理内容**：
1. コマンドライン引数の解析（出力形式、CMakeファイルパス）
2. LLVMVersion.cmakeファイルの読み込み
3. 正規表現でバージョン番号（MAJOR、MINOR、PATCH）を抽出
4. 指定された形式でバージョンを出力

**前後の処理との関連**：export.sh等のリリーススクリプトから呼び出されてバージョン情報を提供します。

**影響範囲**：標準出力にバージョン情報を出力するのみで、ファイルシステムへの影響はありません。

## バッチ種別

ユーティリティ・情報取得

## 実行スケジュール

| 項目 | 内容 |
|-----|------|
| 実行頻度 | 随時（他スクリプトからの呼び出し時） |
| 実行時刻 | 該当なし |
| 実行曜日 | 該当なし |
| 実行日 | 該当なし |
| トリガー | 手動 / スクリプト呼び出し |

## 実行条件

### 前提条件

| 条件 | 説明 |
|-----|------|
| Bash環境 | Bashシェルが利用可能であること |
| grep | grepコマンドが利用可能であること |
| LLVMソース | LLVMVersion.cmakeファイルが存在すること |

### 実行可否判定

CMakeファイルが存在し、読み取り可能であること。

## 入力仕様

### 入力パラメータ

| パラメータ名 | 型 | 必須 | デフォルト値 | 説明 |
|-------------|-----|-----|-------------|------|
| --cmake-file | string | No | スクリプト相対パス | CMakeファイルのパス |
| --major | flag | No | なし | メジャーバージョンのみ出力 |
| --minor | flag | No | なし | マイナーバージョンのみ出力 |
| --patch | flag | No | なし | パッチバージョンのみ出力 |
| --help, -h | flag | No | なし | ヘルプ表示 |

### 入力データソース

| データソース | 形式 | 説明 |
|-------------|------|------|
| cmake/Modules/LLVMVersion.cmake | CMake | バージョン定義ファイル |

## 出力仕様

### 出力データ

| 出力先 | 形式 | 説明 |
|-------|------|------|
| 標準出力 | テキスト | バージョン番号 |

### 出力ファイル仕様

本バッチはファイル出力を行いません。

| 項目 | 内容 |
|-----|------|
| ファイル名 | 該当なし |
| 出力先 | 標準出力 |
| 文字コード | UTF-8 |
| 区切り文字 | ドット（フルバージョン時） |

## 処理フロー

### 処理シーケンス

```
1. コマンドライン引数解析
   └─ CMakeファイルパス、出力形式取得
2. 出力形式検証
   └─ --major/--minor/--patchは排他的
3. CMakeファイル読み込み
   └─ grepでLLVM_VERSION_*を抽出
4. バージョン出力
   └─ 指定形式で標準出力に出力
```

### フローチャート

```mermaid
flowchart TD
    A[バッチ開始] --> B[引数解析]
    B --> C{出力形式指定?}
    C -->|複数指定| D[エラー終了]
    C -->|単一or無し| E[CMakeファイル読み込み]
    E --> F[バージョン抽出]
    F --> G{出力形式}
    G -->|--major| H[メジャー出力]
    G -->|--minor| I[マイナー出力]
    G -->|--patch| J[パッチ出力]
    G -->|なし| K[フルバージョン出力]
    H --> L[バッチ終了]
    I --> L
    J --> L
    K --> L
```

## データベース操作仕様

### 操作別データベース影響一覧

本バッチはデータベースを使用しません。

| 処理 | 対象テーブル | 操作種別 | 概要 |
|-----|-------------|---------|------|
| なし | なし | なし | データベース操作なし |

### テーブル別操作詳細

該当なし

## エラー処理

### エラーケース一覧

| エラーコード | エラー種別 | 発生条件 | 対処方法 |
|------------|----------|---------|---------|
| 1 | 引数エラー | --major/--minor/--patchを複数指定 | いずれか1つのみ指定 |
| 1 | 引数エラー | 不明なオプション | --helpでオプション確認 |
| 非0 | ファイルエラー | CMakeファイルが見つからない | パスを確認 |

### リトライ仕様

| 項目 | 内容 |
|-----|------|
| リトライ回数 | 0（リトライなし） |
| リトライ間隔 | 該当なし |
| リトライ対象エラー | 該当なし |

### 障害時対応

1. CMakeファイルのパスを確認
2. ファイルの存在と読み取り権限を確認
3. ファイル内容のフォーマットを確認

## トランザクション仕様

| 項目 | 内容 |
|-----|------|
| トランザクション範囲 | 該当なし（読み取り専用） |
| コミットタイミング | 該当なし |
| ロールバック条件 | 該当なし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定処理件数 | 1回のバージョン取得 |
| 目標処理時間 | 数ミリ秒 |
| メモリ使用量上限 | 最小限 |

## 排他制御

特になし（読み取り専用処理）。

## ログ出力

| ログ種別 | 出力タイミング | 出力内容 |
|---------|--------------|---------|
| なし | なし | ログ出力なし |

## 監視・アラート

| 監視項目 | 閾値 | アラート先 |
|---------|-----|----------|
| 終了コード | 非0 | 呼び出し元スクリプト |

## 備考

- デフォルトCMakeファイルパス: スクリプトからの相対パス `../../../cmake/Modules/LLVMVersion.cmake`
- バージョン定義形式: `set(LLVM_VERSION_MAJOR X)`, `set(LLVM_VERSION_MINOR Y)`, `set(LLVM_VERSION_PATCH Z)`
- 出力例（フルバージョン）: `19.1.0`
- 出力例（--major）: `19`
- grepの正規表現: `LLVM_VERSION_MAJOR[[:space:]]\+\([0-9]\+\)`
- usage関数にシンタックスエラーあり（クォートが閉じていない）が、動作に影響なし
