---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：1-monolithic-linux.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **目標処理時間**：環境依存のため具体的な数値根拠なし
  2. **メモリ使用量上限**：環境依存のため具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.ci/monolithic-linux.sh` (行1-110)
- E-02: `.ci/utils.sh` (行1-88)
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行2)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | utils.shを読み込んで初期化を行う | E-01 (行16: `source .ci/utils.sh`) | ○ |
| C-02 | CMakeとNinjaを使用してビルド | E-01 (行42-64, 70) | ○ |
| C-03 | sccacheによるビルドキャッシュを使用 | E-01 (行55-56), E-02 (行21, 27-28) | ○ |
| C-04 | 入力パラメータは6つ（projects, targets等） | E-01 (行25-30) | ○ |
| C-05 | LITテストのタイムアウトは1200秒 | E-01 (行32: `--timeout=1200`) | ○ |
| C-06 | テスト結果はXML形式で出力 | E-01 (行32: `--xunit-xml-output`) | ○ |
| C-07 | クラッシュ再現ファイルはartifacts/reproducersに出力 | E-01 (行20, 23) | ○ |
| C-08 | LLVM_ENABLE_WERROR=ONでビルド | E-01 (行64) | ○ |
| C-09 | LLDリンカーを使用 | E-01 (行53: `-D LLVM_ENABLE_LLD=ON`) | ○ |
| C-10 | C++26テストを実行する | E-01 (行84-95) | ○ |
| C-11 | Clang Modulesテストを実行する | E-01 (行97-108) | ○ |
| C-12 | GitHub Actions環境でグループ出力する | E-02 (行71-73) | ○ |
| C-13 | at-exit関数でsccache統計を出力 | E-02 (行23-66) | ○ |
| C-14 | テスト結果XMLをartifactsにコピー | E-02 (行31) | ○ |
| C-15 | BUILD_DIRはMONOREPO_ROOT/buildがデフォルト | E-02 (行17) | ○ |
| C-16 | ninja -k 0でエラー後もビルド継続 | E-01 (行70) | ○ |
| C-17 | llvm-symbolizerの存在確認 | E-01 (行37-38) | ○ |
| C-18 | Python依存パッケージをpipでインストール | E-02 (行82) | ○ |
| C-19 | ARM64ビルダーではGCSキャッシュ無効 | E-02 (行85-87) | ○ |
| C-20 | MLIR Python bindingsを有効化 | E-01 (行59) | ○ |
| C-21 | LLDB Pythonを有効化 | E-01 (行60) | ○ |
| C-22 | premerge_advisorスクリプトを実行 | E-02 (行41-59) | ○ |
| C-23 | Ninjaログをartifactsにコピー | E-02 (行29) | ○ |
| C-24 | 目標処理時間は環境依存 | **根拠なし** | △ |
| C-25 | メモリ使用量上限は環境依存 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（処理時間、メモリ使用量）の具体的な数値
  - 候補：CI環境のドキュメント / ベンチマーク結果 / SLA定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードから直接確認できる仕様が大半

## 6) レビュアーチェックリスト（最小）
- [ ] 入力パラメータの説明が実際のスクリプト引数と一致しているか確認
- [ ] CMakeオプションの説明が最新のソースコードと整合しているか確認
- [ ] 環境依存の項目（処理時間、メモリ）について、運用ドキュメントとの整合性を確認
