---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：10-build_docker_image.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/utils/docker/build_docker_image.sh` (行1-192)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行11)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | --source、--docker-repository、--install-targetが必須 | E-01 (行148-161) | ○ |
| C-02 | command -v dockerで存在確認 | E-01 (行142-146) | ○ |
| C-03 | ソースディレクトリの存在確認 | E-01 (行164-167) | ○ |
| C-04 | mktemp -dで一時ディレクトリ作成 | E-01 (行169) | ○ |
| C-05 | trap "rm -rf $BUILD_DIR" EXIT | E-01 (行170) | ○ |
| C-06 | ソースイメージとscripts/をコピー | E-01 (行173-174) | ○ |
| C-07 | checksumsディレクトリ作成 | E-01 (行176-179) | ○ |
| C-08 | docker build実行 | E-01 (行186-190) | ○ |
| C-09 | --build-argでcheckout_argsを渡す | E-01 (行187) | ○ |
| C-10 | --build-argでbuildscript_argsを渡す | E-01 (行188) | ○ |
| C-11 | -b/--branchオプション | E-01 (行99-101) | ○ |
| C-12 | -r/--revisionオプション | E-01 (行99-101) | ○ |
| C-13 | -c/--cherrypickオプション | E-01 (行99-101) | ○ |
| C-14 | -p/--llvm-projectオプション | E-01 (行108-111) | ○ |
| C-15 | -i/--install-targetオプション | E-01 (行103-106) | ○ |
| C-16 | --checksumsオプション | E-01 (行113-116) | ○ |
| C-17 | --以降はCMake引数 | E-01 (行118-122) | ○ |
| C-18 | LLVM_ENABLE_PROJECTSを構築 | E-01 (行132-140) | ○ |
| C-19 | set -eでエラー時停止 | E-01 (行9) | ○ |
| C-20 | show_usage関数でヘルプ表示 | E-01 (行18-72) | ○ |
| C-21 | 2段階ブートストラップ例がヘルプに記載 | E-01 (行64-71) | ○ |
| C-22 | タグにコロン追加処理 | E-01 (行181-183) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 利用可能なソースイメージ（debian12、nvidia-cuda等）のディレクトリが存在するか確認
- [ ] scripts/ディレクトリ内のスクリプト（checkout.sh、build_install_llvm.sh）が最新か確認
- [ ] Dockerfile内のビルド手順が現在のLLVMビルド要件と整合しているか確認
- [ ] 2段階ブートストラップビルドの例が正しく動作するか確認
