---
generated_at: 2026-02-01 22:48:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：14-buildgo.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `compiler-rt/lib/tsan/go/buildgo.sh` (行1-257)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行15)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名がbuildgo.shである | E-02 | ○ |
| C-02 | ThreadSanitizer（TSan）ランタイムをビルドする | E-01 (全体) | ○ |
| C-03 | Linuxプラットフォームをサポート | E-01 (行5-6, 85-124) | ○ |
| C-04 | macOS (Darwin)プラットフォームをサポート | E-01 (行32-38, 166-182) | ○ |
| C-05 | Windowsプラットフォームをサポート | E-01 (行39-41, 183-191) | ○ |
| C-06 | FreeBSDプラットフォームをサポート | E-01 (行26-28, 125-144) | ○ |
| C-07 | NetBSDプラットフォームをサポート | E-01 (行29-31, 145-165) | ○ |
| C-08 | amd64アーキテクチャをサポート | E-01 (行9-10, 34-35, 102-108) | ○ |
| C-09 | arm64アーキテクチャをサポート | E-01 (行11-12, 36-37, 109-110) | ○ |
| C-10 | ppc64leアーキテクチャをサポート | E-01 (行7-8, 100-101) | ○ |
| C-11 | GOOS環境変数でターゲットOS指定可能 | E-01 (行44) | ○ |
| C-12 | GOARCH環境変数でターゲットアーキテクチャ指定可能 | E-01 (行45) | ○ |
| C-13 | CC環境変数でCコンパイラ指定可能 | E-01 (行197) | ○ |
| C-14 | gotsan.cppにソースファイルを連結 | E-01 (行212-215) | ○ |
| C-15 | race_{SUFFIX}.sysoを出力 | E-01 (行231) | ○ |
| C-16 | SANITIZER_GO=1マクロを使用 | E-01 (行217) | ○ |
| C-17 | libcへの依存関係をチェック | E-01 (行236-240) | ○ |
| C-18 | SKIP_TEST環境変数でテストスキップ可能 | E-01 (行243-245) | ○ |
| C-19 | IN_TMPDIR環境変数で一時ディレクトリ使用可能 | E-01 (行198, 201-209) | ○ |
| C-20 | trapでクリーンアップ関数登録 | E-01 (行206) | ○ |
| C-21 | GORACE環境変数でテスト挙動制御 | E-01 (行251) | ○ |
| C-22 | set -eでエラー時即座に終了 | E-01 (行3) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし。全ての主張がソースコードで裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の内容はソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] ソースコードパス（compiler-rt/lib/tsan/go/buildgo.sh）が正しいか確認
- [ ] 全サポートプラットフォームの動作確認が必要か検討
- [ ] 新しいアーキテクチャ追加時のドキュメント更新プロセスを確認
