---
generated_at: 2026-02-01 22:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：16-apple-install-libcxx.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libcxx/utils/ci/apple-install-libcxx.sh` (行1-199)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行17)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名がapple-install-libcxx.shである | E-02 | ○ |
| C-02 | Apple向けlibc++をビルドする | E-01 (全体) | ○ |
| C-03 | --llvm-rootオプションでLLVMルート指定 | E-01 (行51-53) | ○ |
| C-04 | --build-dirオプションでビルドディレクトリ指定 | E-01 (行54-56) | ○ |
| C-05 | --symbols-dirオプションでシンボルディレクトリ指定 | E-01 (行57-59) | ○ |
| C-06 | --install-dirオプションでインストールディレクトリ指定 | E-01 (行60-62) | ○ |
| C-07 | --architecturesオプションでアーキテクチャ指定 | E-01 (行63-65) | ○ |
| C-08 | --versionオプションでバージョン指定 | E-01 (行72-74) | ○ |
| C-09 | --headers-onlyオプションでヘッダーのみインストール | E-01 (行66-68, 141-145) | ○ |
| C-10 | set -eでエラー時即座に終了 | E-01 (行10) | ○ |
| C-11 | shimライブラリをビルド | E-01 (行119-124) | ○ |
| C-12 | CMakeとNinjaでビルド | E-01 (行127-139) | ○ |
| C-13 | lipoでユニバーサルdylibを作成 | E-01 (行154) | ○ |
| C-14 | stripでデバッグシンボルを除去 | E-01 (行159) | ○ |
| C-15 | dsymutilでdSYMバンドルを生成 | E-01 (行162) | ○ |
| C-16 | libc++.1.dylib/libc++.dylibのシンボリックリンク作成 | E-01 (行169) | ○ |
| C-17 | libc++experimental.aを作成 | E-01 (行171-172) | ○ |
| C-18 | dittoでヘッダーをコピー | E-01 (行180) | ○ |
| C-19 | rootユーザー時にchownを実行 | E-01 (行181-183) | ○ |
| C-20 | LICENSE.TXTをインストール | E-01 (行187-189) | ○ |
| C-21 | libtoolでユニバーサル静的ライブラリを作成 | E-01 (行196-197) | ○ |
| C-22 | Apple.cmakeキャッシュを使用 | E-01 (行131) | ○ |
| C-23 | 引数空チェックを実行 | E-01 (行85-91) | ○ |
| C-24 | 相対パスを絶対パスに変換 | E-01 (行94-100) | ○ |
| C-25 | step関数で進捗ログを表示 | E-01 (行102-108) | ○ |
| C-26 | xcrunでAppleツールを呼び出し | E-01 (行124, 127等) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし。全ての主張がソースコードで裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の内容はソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] ソースコードパス（libcxx/utils/ci/apple-install-libcxx.sh）が正しいか確認
- [ ] サポートアーキテクチャ一覧を確認
- [ ] dSYM出力先の権限を確認
- [ ] rootユーザー実行時の挙動を確認
