---
generated_at: 2026-02-01 22:52:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-build-install-linux.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/utils/crosstool/ARM/build-install-linux.sh` (行1-201)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行19)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名がbuild-install-linux.shである | E-02 | ○ |
| C-02 | x86_64からARMへのクロスツールチェーンをビルド | E-01 (行4, 9-10) | ○ |
| C-03 | INSTALL_ROOTデフォルトは/usr/local/crosstool | E-01 (行12) | ○ |
| C-04 | CROSS_TARGET=arm-none-linux-gnueabi | E-01 (行19) | ○ |
| C-05 | CROSS_HOST=x86_64-unknown-linux-gnu | E-01 (行18) | ○ |
| C-06 | CROSS_MARCHデフォルトはarmv6 | E-01 (行20) | ○ |
| C-07 | set -o nounsetで未定義変数使用時にエラー | E-01 (行6) | ○ |
| C-08 | set -o errexitでコマンドエラー時に終了 | E-01 (行7) | ○ |
| C-09 | CodeSourcery ARM 2007q3を使用 | E-01 (行25-26) | ○ |
| C-10 | sudoCreateDir関数でsudo権限を使用 | E-01 (行66-69) | ○ |
| C-11 | runAndLog関数でログファイルに出力 | E-01 (行82-95) | ○ |
| C-12 | LLVMデフォルトリビジョンは74530 | E-01 (行39) | ○ |
| C-13 | LLVM-GCCデフォルトリビジョンは74535 | E-01 (行40) | ○ |
| C-14 | MAKE_OPTSデフォルトは-j2 | E-01 (行52) | ○ |
| C-15 | installCodeSourcery関数でCodeSourceryをインストール | E-01 (行97-129) | ○ |
| C-16 | installLLVM関数でLLVMをインストール | E-01 (行131-157) | ○ |
| C-17 | installLLVMGCC関数でLLVM-GCCをインストール | E-01 (行159-189) | ○ |
| C-18 | configureログはllvm-configure.log等 | E-01 (行146-147, 174-175) | ○ |
| C-19 | buildログはllvm-build.log等 | E-01 (行153-154, 185-186) | ○ |
| C-20 | installログはllvm-install.log等 | E-01 (行155-156, 187-188) | ○ |
| C-21 | mktemp -dで一時ディレクトリ作成 | E-01 (行14) | ○ |
| C-22 | 成功時に"Done."を出力 | E-01 (行200) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし。全ての主張がソースコードで裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 歴史的スクリプトであり、現代のLLVMビルドプロセスとは異なる可能性がある

## 6) レビュアーチェックリスト（最小）
- [ ] ソースコードパス（llvm/utils/crosstool/ARM/build-install-linux.sh）が正しいか確認
- [ ] CodeSourcery 2007q3パッケージの入手可能性を確認
- [ ] LLVM-GCC-4.2が現在もサポートされているか確認
- [ ] 歴史的スクリプトとしての位置づけをドキュメントに明記すべきか検討
