---
generated_at: 2026-02-01 22:53:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：19-runulp.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libc/AOR_v20.02/math/test/runulp.sh` (行1-296)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行20)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名がrunulp.shである | E-02 | ○ |
| C-02 | ULPエラーテストを実行する | E-01 (全体) | ○ |
| C-03 | set -euでエラー時即座に終了 | E-01 (行10) | ○ |
| C-04 | 丸めモードはn, u, d, z | E-01 (行15) | ○ |
| C-05 | ULPFLAGSデフォルトは-q | E-01 (行17) | ○ |
| C-06 | $@でエミュレータコマンド指定可能 | E-01 (行18) | ○ |
| C-07 | PASS/FAILカウンタを使用 | E-01 (行20-21) | ○ |
| C-08 | exp関数をテスト | E-01 (行36-40) | ○ |
| C-09 | exp2関数をテスト | E-01 (行43-47) | ○ |
| C-10 | log関数をテスト | E-01 (行50-52) | ○ |
| C-11 | log2関数をテスト | E-01 (行55-57) | ○ |
| C-12 | pow関数をテスト | E-01 (行60-74) | ○ |
| C-13 | expf/exp2f/logf/log2f/powf関数をテスト | E-01 (行77-122) | ○ |
| C-14 | ベクトル関数をcheck関数で検出 | E-01 (行28-30, 130-134) | ○ |
| C-15 | L_exp=1.9等のULP閾値定義 | E-01 (行198-210) | ○ |
| C-16 | __s_*, __v_*, __vn_*, _ZGV*関数をテスト | E-01 (行227-289) | ○ |
| C-17 | FAIL > 0でexit 1 | E-01 (行292-295) | ○ |
| C-18 | "FAILED X PASSED Y"形式で結果出力 | E-01 (行293) | ○ |
| C-19 | ulpバイナリを./ulpで実行 | E-01 (行25, 29) | ○ |
| C-20 | cdでスクリプトディレクトリに移動 | E-01 (行13) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし。全ての主張がソースコードで裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 設計書の内容はソースコードと完全に整合している

## 6) レビュアーチェックリスト（最小）
- [ ] ソースコードパス（libc/AOR_v20.02/math/test/runulp.sh）が正しいか確認
- [ ] ULP閾値が最新の精度要件と合致しているか確認
- [ ] ベクトル関数の対応状況を確認
- [ ] 新規追加された数学関数がテスト対象に含まれているか確認
