---
generated_at: 2026-02-01 22:54:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：20-common.sh (flang)

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり。重点レビュー項目なし。

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flang/test/Semantics/common.sh` (行1-27)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行21)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | バッチ名がcommon.sh (flang)である | E-02 | ○ |
| C-02 | Flang Semanticsテストの共通機能を提供 | E-01 (行1-2) | ○ |
| C-03 | die関数を定義 | E-01 (行7-10) | ○ |
| C-04 | die関数はbasename $0付きでエラー出力 | E-01 (行8) | ○ |
| C-05 | die関数はexit 1で終了 | E-01 (行9) | ○ |
| C-06 | 引数3つ未満で使用方法表示 | E-01 (行11-14) | ○ |
| C-07 | 絶対パスはそのまま使用（/始まり判定） | E-01 (行16-17) | ○ |
| C-08 | 相対パスはdirname $0基準で解決 | E-01 (行18) | ○ |
| C-09 | shiftで引数を削除 | E-01 (行20, 23) | ○ |
| C-10 | temp=$1で一時ディレクトリ設定 | E-01 (行21) | ○ |
| C-11 | mkdir -p $tempでディレクトリ作成 | E-01 (行22) | ○ |
| C-12 | $1ファイル存在チェック | E-01 (行25) | ○ |
| C-13 | f18 executable not foundエラーメッセージ | E-01 (行25) | ○ |
| C-14 | FLANG_FC1=$*で設定 | E-01 (行26) | ○ |
| C-15 | $src変数を設定 | E-01 (行17, 18) | ○ |
| C-16 | ソースファイル、一時ディレクトリ、f18コマンドの3引数が必要 | E-01 (行12) | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし。全ての主張がソースコードで裏付けられている。

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 小さなスクリプトで設計書との整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] ソースコードパス（flang/test/Semantics/common.sh）が正しいか確認
- [ ] このスクリプトを使用しているテストスクリプトの一覧を確認
- [ ] f18コマンドの最新の名前/パスを確認（FLANG_FC1変数名との整合性）
