---
generated_at: 2026-02-01 22:46:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：22-bughunter.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **O(log n)の効率**：計算量の記述は正しいが、明示的な根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bolt/utils/bughunter.sh` (ソースコード全体267行)
- E-02: `bolt/utils/bughunter.sh` 1-58行（ヘッダーコメント・環境変数説明）
- E-03: `bolt/utils/bughunter.sh` 60-67行（環境変数初期化）
- E-04: `bolt/utils/bughunter.sh` 69-72行（INPUT_BINARY検証）
- E-05: `bolt/utils/bughunter.sh` 90-92行（一時ファイル生成）
- E-06: `bolt/utils/bughunter.sh` 94-113行（入力バイナリ検証）
- E-07: `bolt/utils/bughunter.sh` 115-143行（最適化バイナリ検証）
- E-08: `bolt/utils/bughunter.sh` 145-173行（関数リスト取得・探索初期化）
- E-09: `bolt/utils/bughunter.sh` 176-246行（二分探索ループ）
- E-10: `bolt/utils/bughunter.sh` 248-264行（結果出力）
- E-11: `bolt/utils/bughunter.sh` 266行（クリーンアップ）
- E-12: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.22の行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BOLTバグ特定ツールである | E-02, E-12 | ○ |
| C-02 | 二分探索で問題関数を特定 | E-09 | ○ |
| C-03 | O(log n)の効率 | **根拠なし** | △ |
| C-04 | INPUT_BINARYは必須環境変数 | E-02, E-04 | ○ |
| C-05 | BOLTのデフォルトはllvm-bolt | E-03 (60行目) | ○ |
| C-06 | PRE_COMMANDのデフォルトは: | E-03 (74-76行目) | ○ |
| C-07 | POST_COMMANDのデフォルトはcat | E-03 (78-80行目) | ○ |
| C-08 | TIMEOUT_OR_CMDは数値またはコマンド | E-02, E-03 (82-84行目) | ○ |
| C-09 | MAX_FUNCS_FLAGのデフォルトは-max-funcs | E-03 (86-88行目) | ○ |
| C-10 | OFFLINEモードで対話的入力 | E-06 (133-134行目), E-09 (207-208行目) | ○ |
| C-11 | nmコマンドで関数リスト取得 | E-08 (147行目) | ○ |
| C-12 | FUNC_NAMESで初期リスト指定可能 | E-02, E-08 (152-154行目) | ○ |
| C-13 | 一時ファイルにmktempを使用 | E-05 | ○ |
| C-14 | core dumpを無効化 | E-03 (62行目) | ○ |
| C-15 | VERBOSEでset -xを有効化 | E-03 (65-67行目) | ○ |
| C-16 | splitコマンドで関数リストを分割 | E-08 (160行目), E-09 (225行目) | ○ |
| C-17 | 成功判定にGOLD_FILEとの比較を使用 | E-06 (104-107行目), E-07 (128-131行目) | ○ |
| C-18 | IGNORE_ERROR=1でエラーコード無視 | E-06 (99-103行目), E-07 (123-127行目) | ○ |
| C-19 | 再現コマンドを最後に表示 | E-10 (261行目) | ○ |
| C-20 | 一時ファイルを最後に削除 | E-11 | ○ |
| C-21 | MAX_FUNCSモードで数値ベース探索 | E-08 (164-173行目), E-09 (182-184行目) | ○ |
| C-22 | 関数名ベースの探索がデフォルト | E-08 (150-163行目) | ○ |
| C-23 | pipefailオプションを設定 | E-03 (63行目) | ○ |
| C-24 | カテゴリはデバッグ | E-12 | ○ |
| C-25 | バイナリサーチによる問題関数特定 | E-12 | ○ |

## 4) 不足情報（Unknown / Missing）
- O(log n)の効率の主張は二分探索アルゴリズムから推測されるが、スクリプト内に明示的な記述はない
  - 候補：アルゴリズム解説ドキュメント / 計算量分析

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトの動作は詳細なコメントで文書化されている

## 6) レビュアーチェックリスト（最小）
- [ ] 環境変数の説明がソースコードのコメントと一致しているか確認
- [ ] 二分探索の収束条件が正しく文書化されているか確認
- [ ] OFFLINEモードの動作説明が適切か確認
