---
generated_at: 2026-02-01 22:47:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：23-macos-setup-codesign.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lldb/scripts/macos-setup-codesign.sh` (ソースコード全体58行)
- E-02: `lldb/scripts/macos-setup-codesign.sh` 3行目「CERT="lldb_codesign"」
- E-03: `lldb/scripts/macos-setup-codesign.sh` 10-13行（cleanup関数）
- E-04: `lldb/scripts/macos-setup-codesign.sh` 15行目「trap cleanup EXIT」
- E-05: `lldb/scripts/macos-setup-codesign.sh` 17-22行（証明書存在チェック）
- E-06: `lldb/scripts/macos-setup-codesign.sh` 24-37行（テンプレート生成）
- E-07: `lldb/scripts/macos-setup-codesign.sh` 41-43行（証明書生成）
- E-08: `lldb/scripts/macos-setup-codesign.sh` 45-47行（証明書インストール）
- E-09: `lldb/scripts/macos-setup-codesign.sh` 49-51行（秘密鍵インポート）
- E-10: `lldb/scripts/macos-setup-codesign.sh` 53-54行（taskgated再起動）
- E-11: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.23の行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 証明書名はlldb_codesign | E-02 | ○ |
| C-02 | 既存証明書存在時はスキップ | E-05 (19-22行目) | ○ |
| C-03 | System.keychainに証明書を検索 | E-05 (18行目) | ○ |
| C-04 | OpenSSL設定をヒアドキュメントで生成 | E-06 | ○ |
| C-05 | RSA 2048bit鍵を使用 | E-06 (27行目), E-07 (42行目) | ○ |
| C-06 | SHA-512ハッシュを使用 | E-06 (29行目) | ○ |
| C-07 | 有効期限は3650日 | E-07 (42行目「-days 3650」) | ○ |
| C-08 | keyUsageはdigitalSignature | E-06 (35行目) | ○ |
| C-09 | extendedKeyUsageはcodeSigning | E-06 (36行目) | ○ |
| C-10 | 証明書は信頼されたルートとして追加 | E-08 (「-r trustRoot」) | ○ |
| C-11 | 秘密鍵は-Aフラグでインポート | E-09 (「-A」) | ○ |
| C-12 | taskgatedをpkillで再起動 | E-10 | ○ |
| C-13 | 一時ファイルはtrapでクリーンアップ | E-03, E-04 | ○ |
| C-14 | error関数でエラー時に終了 | E-01 (5-8行目) | ○ |
| C-15 | 管理者権限(sudo)が必要 | E-08, E-09, E-10 | ○ |
| C-16 | 一時ファイルは$TMPDIRに作成 | E-03, E-06 | ○ |
| C-17 | 正常終了コードは0 | E-05 (22行目), E-01 (57行目) | ○ |
| C-18 | コマンドライン引数なし | E-01 | ○ |
| C-19 | securityコマンドを使用 | E-05, E-08, E-09 | ○ |
| C-20 | opensslコマンドを使用 | E-07 | ○ |
| C-21 | カテゴリはデバッグ | E-11 | ○ |
| C-22 | LLDBデバッグ用証明書設定 | E-11 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張がソースコードに基づいている）

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - 管理者権限でシステムキーチェーンを変更するため、セキュリティ影響あり

## 6) レビュアーチェックリスト（最小）
- [ ] 証明書の有効期限（10年）が運用上適切か確認
- [ ] -Aフラグ（全アプリからアクセス可能）のセキュリティ影響を確認
- [ ] taskgated再起動の影響範囲を確認
