---
generated_at: 2026-02-01 22:49:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：25-check_cmake.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `compiler-rt/lib/tsan/check_cmake.sh` (ソースコード全体19行)
- E-02: ソースコード2行目「set -u」
- E-03: ソースコード3行目「set -e」
- E-04: ソースコード5行目「ROOT=...」
- E-05: ソースコード6-12行目（ビルドディレクトリ処理）
- E-06: ソースコード11行目（CMakeオプション）
- E-07: ソースコード13行目「ninja」
- E-08: ソースコード14-18行目（テスト実行）
- E-09: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.25の行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set -uで未定義変数エラー | E-02 | ○ |
| C-02 | set -eでエラー時終了 | E-03 | ○ |
| C-03 | BASH_SOURCE[0]でスクリプトパス取得 | E-04 | ○ |
| C-04 | llvm-buildディレクトリをビルド先に使用 | E-05 (6, 9行目) | ○ |
| C-05 | ディレクトリ存在時はCMakeをスキップ | E-05 (6-7行目) | ○ |
| C-06 | Ninjaをビルドジェネレータとして使用 | E-06 (「-G Ninja」) | ○ |
| C-07 | LLVM_ENABLE_WERROR=ON | E-06 | ○ |
| C-08 | CMAKE_BUILD_TYPE=Release | E-06 | ○ |
| C-09 | LLVM_ENABLE_ASSERTIONS=ON | E-06 | ○ |
| C-10 | CC=clang, CXX=clang++ | E-06 | ○ |
| C-11 | ninjaでビルド実行 | E-07 | ○ |
| C-12 | check-sanitizerテスト実行 | E-08 (14行目) | ○ |
| C-13 | check-tsanテスト実行 | E-08 (15行目) | ○ |
| C-14 | check-asanテスト実行 | E-08 (16行目) | ○ |
| C-15 | check-msanテスト実行 | E-08 (17行目) | ○ |
| C-16 | check-lsanテスト実行 | E-08 (18行目) | ○ |
| C-17 | LLVMソースは4階層上 | E-06 (「$ROOT/../../../..」) | ○ |
| C-18 | カテゴリは解析 | E-09 | ○ |
| C-19 | TSan CMakeビルドチェック | E-09 | ○ |
| C-20 | コマンドライン引数なし | E-01 (引数参照なし) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張がソースコードに基づいている）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ローカルビルド・テスト実行スクリプトでシステムへの影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] LLVMソースツリーの相対パス（4階層上）が正しいか確認
- [ ] 必要な依存関係（Clang、CMake、Ninja）がインストールされているか確認
