---
generated_at: 2026-02-01 22:50:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：26-analyze_libtsan.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `compiler-rt/lib/tsan/analyze_libtsan.sh` (ソースコード全体55行)
- E-02: ソースコード3行目（コメント: Script that prints information about generated code）
- E-03: ソースコード5-6行目「set -e」「set -u」
- E-04: ソースコード8-11行目（引数チェック・使用方法出力）
- E-05: ソースコード13-16行目（get_asm関数定義）
- E-06: ソースコード18-27行目（解析対象関数リスト）
- E-07: ソースコード29-32行目（一時ファイル・ディレクトリ変数）
- E-08: ソースコード34行目（objdump -d）
- E-09: ソースコード35行目（nm -S | grep __tsan_）
- E-10: ソースコード37-54行目（ループ処理・統計出力）
- E-11: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.26の行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | TSanライブラリシンボル解析スクリプト | E-02, E-11 | ○ |
| C-02 | set -e, set -uで厳格化 | E-03 | ○ |
| C-03 | 引数が1つでなければ使用方法表示 | E-04 | ○ |
| C-04 | get_asm関数でアセンブリ抽出 | E-05 | ○ |
| C-05 | write1-8, read1-8を解析 | E-06 | ○ |
| C-06 | func_entry, func_exitを解析 | E-06 | ○ |
| C-07 | mktempで一時ディレクトリ作成 | E-07 (30行目) | ○ |
| C-08 | objdump -dで逆アセンブリ取得 | E-08 | ○ |
| C-09 | nmで__tsan_シンボルを抽出 | E-09 | ○ |
| C-10 | nm -Sでシンボルサイズ取得 | E-09, E-10 (41行目) | ○ |
| C-11 | awkの--non-decimal-dataで16進数変換 | E-10 (41行目) | ○ |
| C-12 | (%rsp)操作をカウント | E-10 (42行目) | ○ |
| C-13 | push命令をカウント | E-10 (43行目) | ○ |
| C-14 | pop命令をカウント | E-10 (44行目) | ○ |
| C-15 | call命令をカウント | E-10 (45行目) | ○ |
| C-16 | load命令（mov/cmp+メモリ参照）をカウント | E-10 (46行目) | ○ |
| C-17 | store命令をカウント | E-10 (47行目) | ○ |
| C-18 | mov命令をカウント | E-10 (48行目) | ○ |
| C-19 | lea命令をカウント | E-10 (49行目) | ○ |
| C-20 | shr/shl命令をカウント | E-10 (50行目) | ○ |
| C-21 | cmp/test命令をカウント | E-10 (51行目) | ○ |
| C-22 | printfでフォーマット済み出力 | E-10 (52-53行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張がソースコードに基づいている）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の解析スクリプトでシステムへの影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] get_asm関数の正規表現が正しく関数を抽出するか確認
- [ ] 各命令のgrepパターンが意図した命令をカウントしているか確認
- [ ] 一時ファイルのクリーンアップが必要か検討（現在は残留）
