---
generated_at: 2026-02-01 22:51:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：27-diag-build.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang/tools/diag-build/diag-build.sh` (ソースコード全体125行)
- E-02: ソースコード3-10行目（コメント: diagtoolのラッパー）
- E-03: ソースコード12-20行目（print_usage関数）
- E-04: ソースコード22-25行目（sedフラグ検出）
- E-05: ソースコード27-30行目（verboseフラグ処理）
- E-06: ソースコード32-46行目（CC変数の解決）
- E-07: ソースコード48-56行目（CXX変数の解決）
- E-08: ソースコード58-66行目（diagtool検索）
- E-09: ソースコード69-88行目（ビルドツール判定）
- E-10: ソースコード90-92行目（escape関数）
- E-11: ソースコード94-105行目（コマンド抽出・変換）
- E-12: ソースコード107-116行目（エラーハンドリング）
- E-13: ソースコード118-124行目（コマンド実行）
- E-14: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.27の行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | diagtool show-enabledのラッパー | E-02, E-14 | ○ |
| C-02 | scan-buildと同様のアプローチ | E-02 (6-7行目) | ○ |
| C-03 | xcodebuildに対応 | E-09 (75-77行目) | ○ |
| C-04 | makeに対応 | E-09 (78-80行目) | ○ |
| C-05 | xcodebuildは-dry-runを使用 | E-09 (76行目) | ○ |
| C-06 | makeは-nを使用 | E-09 (79行目) | ○ |
| C-07 | CC環境変数で指定可能 | E-06 | ○ |
| C-08 | CXX環境変数で指定可能 | E-07 | ○ |
| C-09 | CCが未設定の場合clangを検索 | E-06 (36-40行目) | ○ |
| C-10 | diagtoolがPATH上に必要 | E-08 | ○ |
| C-11 | diagtoolが見つからない場合エラー終了 | E-08 (63-65行目) | ○ |
| C-12 | BSD sed (-E)に対応 | E-04 (24行目) | ○ |
| C-13 | GNU sed (-r)に対応 | E-04 (25行目) | ○ |
| C-14 | -vフラグでverboseモード | E-05 | ○ |
| C-15 | if文を除去 | E-11 (99行目) | ○ |
| C-16 | バックスラッシュ継続行を結合 | E-11 (101行目) | ○ |
| C-17 | CC/CXXでgrepしてhead -n1 | E-11 (102-103行目) | ○ |
| C-18 | diagtool show-enabledに置換 | E-11 (104行目) | ○ |
| C-19 | 末尾の&&、||、;を除去 | E-13 (119-121行目) | ○ |
| C-20 | print_usage関数で使用方法表示 | E-03 | ○ |
| C-21 | ビルドコマンドが見つからない場合エラー | E-12 | ○ |
| C-22 | 終了コード2でビルドコマンド未発見 | E-12 (115行目) | ○ |
| C-23 | escape関数で正規表現エスケープ | E-10 | ○ |
| C-24 | verboseモードで実行コマンドを表示 | E-13 (123行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張がソースコードに基づいている）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の診断ツールでシステムへの影響なし

## 6) レビュアーチェックリスト（最小）
- [ ] サポートされていないビルドシステムの警告が適切か確認
- [ ] コマンド抽出の正規表現がプロジェクト固有の設定で動作するか確認
