---
generated_at: 2026-02-01 22:52:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：28-find-unused-diagnostics.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang/utils/find-unused-diagnostics.sh` (ソースコード全体16行)
- E-02: ソースコード3-5行目（コメント: This script produces a list of all diagnostics...）
- E-03: ソースコード8行目（Diagnostic*.tdからの抽出）
- E-04: ソースコード11行目（findでソースファイル検索）
- E-05: ソースコード12行目（ソースから識別子抽出）
- E-06: ソースコード15行目（commで差分出力）
- E-07: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` No.28の行

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 未使用診断メッセージを検出 | E-02, E-07 | ○ |
| C-02 | Diagnostic*.tdから識別子を抽出 | E-03 | ○ |
| C-03 | err_プレフィックスを検出 | E-03 (正規表現) | ○ |
| C-04 | warn_プレフィックスを検出 | E-03 (正規表現) | ○ |
| C-05 | ext_プレフィックスを検出 | E-03 (正規表現) | ○ |
| C-06 | note_プレフィックスを検出 | E-03 (正規表現) | ○ |
| C-07 | findでソースファイル検索 | E-04 | ○ |
| C-08 | lib/include/tools/utilsを検索 | E-04 | ○ |
| C-09 | *.cpp/*.hを対象 | E-04 (「-name \*.cpp -or -name \*.h」) | ○ |
| C-10 | ソースから使用識別子を抽出 | E-05 | ○ |
| C-11 | grep -Eで拡張正規表現 | E-03, E-05 | ○ |
| C-12 | --only-matchingでマッチ部分のみ | E-03, E-05 | ○ |
| C-13 | --no-filenameでファイル名除外 | E-03, E-05 | ○ |
| C-14 | sort -uで重複除去・ソート | E-06 (「sort -u」) | ○ |
| C-15 | comm -23で差分抽出 | E-06 | ○ |
| C-16 | プロセス置換を使用 | E-06 (「<(...)」) | ○ |
| C-17 | コマンドライン引数なし | E-01 (引数参照なし) | ○ |
| C-18 | カテゴリは解析 | E-07 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（全ての主張がソースコードに基づいている）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用のコード品質チェックツール

## 6) レビュアーチェックリスト（最小）
- [ ] 正規表現が全ての診断識別子パターンをカバーしているか確認
- [ ] 検索対象ディレクトリが適切か確認（新しいディレクトリが追加されていないか）
