---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：3-utils.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `.ci/utils.sh` (行1-88)
- E-02: `.ci/monolithic-linux.sh` (行16)
- E-03: `.ci/monolithic-windows.sh` (行16)
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行4)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set -exとset -o pipefailを設定 | E-01 (行13-14) | ○ |
| C-02 | MONOREPO_ROOTをgit rev-parseから取得 | E-01 (行16) | ○ |
| C-03 | BUILD_DIRのデフォルトはMONOREPO_ROOT/build | E-01 (行17) | ○ |
| C-04 | ビルドディレクトリを削除 | E-01 (行19: `rm -rf "${BUILD_DIR}"`) | ○ |
| C-05 | sccache統計をリセット | E-01 (行21: `sccache --zero-stats`) | ○ |
| C-06 | at-exit関数を定義しtrapで登録 | E-01 (行23-67) | ○ |
| C-07 | artifactsディレクトリを作成 | E-01 (行26: `mkdir -p artifacts`) | ○ |
| C-08 | sccache統計をファイルに出力 | E-01 (行27-28) | ○ |
| C-09 | Ninjaログをartifactsにコピー | E-01 (行29) | ○ |
| C-10 | テスト結果XMLをartifactsにコピー | E-01 (行31) | ○ |
| C-11 | GitHub Actions環境でテストレポート生成 | E-01 (行37-39) | ○ |
| C-12 | premerge_advisor_explain.pyを実行 | E-01 (行41-44) | ○ |
| C-13 | premerge_advisor_upload.pyを実行 | E-01 (行53-59) | ○ |
| C-14 | start-group関数を定義 | E-01 (行69-79) | ○ |
| C-15 | GitHub Actions環境で::group::形式出力 | E-01 (行71-73) | ○ |
| C-16 | POSTCOMMIT_CI環境で@@@STEP@@@形式出力 | E-01 (行74-75) | ○ |
| C-17 | PIP_BREAK_SYSTEM_PACKAGES=1を設定 | E-01 (行81) | ○ |
| C-18 | pip install -q -rを実行 | E-01 (行82) | ○ |
| C-19 | ARM64環境ではLITキャッシュDLスキップ | E-01 (行85-87) | ○ |
| C-20 | shopt -s nullglobを使用 | E-01 (行34) | ○ |
| C-21 | monolithic-linux.shから読み込まれる | E-02 (行16) | ○ |
| C-22 | monolithic-windows.shから読み込まれる | E-03 (行16) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] premerge_advisorスクリプト群の最新の実装と整合しているか確認
- [ ] cache_lit_timing_files.pyの機能と整合しているか確認
- [ ] CI環境（GitHub Actions, Buildkite, POSTCOMMIT_CI）の検出ロジックが現在の運用と一致しているか確認
