---
generated_at: 2026-02-01 22:51:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：34-start-emulator.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **起動時間の目標（30秒〜2分）**：経験則に基づく推測

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libcxx/utils/ci/vendor/android/start-emulator.sh` - ソースコード本体
- E-02: `libcxx/utils/ci/vendor/android/emulator-functions.sh` - ヘルパー関数
- E-03: `libcxx/utils/ci/vendor/android/stop-emulator.sh` - 停止スクリプト
- E-04: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | validate_emu_img関数でイメージ名を検証する | E-01 (行20-23), E-02 (行46-63) | ○ |
| C-02 | stop-emulator.shを呼び出して既存コンテナを停止する | E-01 (行25) | ○ |
| C-03 | docker run --detach --device /dev/kvmでコンテナ起動 | E-01 (行28-31) | ○ |
| C-04 | EMU_PARTITION_SIZE=8192を設定する | E-01 (行29) | ○ |
| C-05 | android-platform-toolsボリュームをマウントする | E-01 (行30) | ○ |
| C-06 | コンテナ名はlibcxx-ci-android-emulator | E-01 (行28) | ○ |
| C-07 | emulator-wait-for-ready.shで起動待機する | E-01 (行33) | ○ |
| C-08 | docker logsで起動ログを出力する | E-01 (行34-35) | ○ |
| C-09 | エラー時はERRで終了コードを保持し、ログ出力後に終了 | E-01 (行32, 36-38) | ○ |
| C-10 | setup-env-for-emulator.shをsourceする | E-01 (行42) | ○ |
| C-11 | adb wait-for-deviceでデバイス接続を確認する | E-01 (行43) | ○ |
| C-12 | set -eでエラー時即座に終了する | E-01 (行14) | ○ |
| C-13 | emulator-functions.shをsourceする | E-01 (行17) | ○ |
| C-14 | イメージ名形式はAPI-TYPE-ARCH | E-02 (行13, 28-37) | ○ |
| C-15 | TYPE: def/goog/playの3種類 | E-02 (行15-19) | ○ |
| C-16 | Docker imageがないとエラーになる | E-02 (行59-62) | ○ |
| C-17 | CI用Androidテスト環境が目的 | E-04 (バッチ一覧) | ○ |
| C-18 | 目標起動時間は30秒〜2分 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- C-18の起動時間は経験則に基づく推測値
  - 候補：CI実行ログ / ベンチマークデータ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 技術的な処理内容は全てソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] setup-env-for-emulator.shの内容と環境変数設定を確認
- [ ] KVMデバイスアクセス権限の要件を確認
- [ ] 実際のCI環境での起動時間を計測
