---
generated_at: 2026-02-01 22:53:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-stop-emulator.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libcxx/utils/ci/vendor/android/stop-emulator.sh` - ソースコード本体
- E-02: `libcxx/utils/ci/vendor/android/start-emulator.sh` - 呼び出し元スクリプト
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | docker container inspectでコンテナ存在確認する | E-01 (行16) | ○ |
| C-02 | コンテナが存在する場合のみ停止・削除処理を実行する | E-01 (行16-25) | ○ |
| C-03 | docker stopでコンテナを停止する | E-01 (行18) | ○ |
| C-04 | docker logsで最終ログを出力する | E-01 (行20-21) | ○ |
| C-05 | docker rmでコンテナを削除する | E-01 (行23-24) | ○ |
| C-06 | コンテナ名はlibcxx-ci-android-emulator | E-01 (行16, 18, 21, 24) | ○ |
| C-07 | set -eでエラー時即座に終了する | E-01 (行10) | ○ |
| C-08 | emulator-functions.shをsourceする | E-01 (行13) | ○ |
| C-09 | 引数は不要 | E-01 (全体構造) | ○ |
| C-10 | start-emulator.shから呼び出される | E-02 (行25) | ○ |
| C-11 | リソースクリーンアップが目的 | E-03 (バッチ一覧) | ○ |
| C-12 | コンテナが存在しない場合は何もせず正常終了 | E-01 (行16のif条件) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] docker container inspect 2>&1>/dev/nullの出力抑制が適切か確認
- [ ] コンテナ停止と削除の間でエラーが発生した場合の動作を確認
