---
generated_at: 2026-02-01 23:01:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：39-define_inst.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `mlir/utils/spirv/define_inst.sh` - ソースコード本体
- E-02: `mlir/utils/spirv/define_opcodes.sh` - オペコード定義スクリプト
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | file_name=$1でファイル名を取得する | E-01 (行22) | ○ |
| C-02 | baseclass=$2でベースクラスを取得する | E-01 (行23) | ○ |
| C-03 | case文でベースクラスを検証する | E-01 (行25-39) | ○ |
| C-04 | 許可されたベースクラス一覧が定義されている | E-01 (行26-30) | ○ |
| C-05 | 無効なベースクラスの場合はUsage表示してexit 1 | E-01 (行32-37) | ○ |
| C-06 | shift; shiftでopname引数を取得する | E-01 (行41-42) | ○ |
| C-07 | readlinkで絶対パスを取得する | E-01 (行44) | ○ |
| C-08 | dirnameでディレクトリを取得する | E-01 (行45) | ○ |
| C-09 | python3でgen_spirv_dialect.pyを呼び出す | E-01 (行47) | ○ |
| C-10 | --op-td-pathで対象ファイルを指定する | E-01 (行48-49) | ○ |
| C-11 | --inst-categoryでベースクラスを指定する | E-01 (行50) | ○ |
| C-12 | --new-instで命令名を渡す | E-01 (行50) | ○ |
| C-13 | define_opcodes.shを呼び出す | E-01 (行52) | ○ |
| C-14 | set -eでエラー時即座に終了する | E-01 (行20) | ○ |
| C-15 | 使用例がコメントに記載されている | E-01 (行17-19) | ○ |
| C-16 | MLIRコード生成が目的 | E-03 (バッチ一覧) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 許可されたベースクラス一覧が最新か確認
- [ ] gen_spirv_dialect.pyの--inst-categoryオプションの動作を確認
- [ ] 実際に実行して出力を確認
