---
generated_at: 2026-02-01 23:03:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：40-define_opcodes.md

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `mlir/utils/spirv/define_opcodes.sh` - ソースコード本体
- E-02: `mlir/utils/spirv/define_inst.sh` - 呼び出し元スクリプト
- E-03: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` - バッチ一覧情報

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | set -eでエラー時即座に終了する | E-01 (行21) | ○ |
| C-02 | readlinkで絶対パスを取得する | E-01 (行23) | ○ |
| C-03 | dirnameでディレクトリを取得する | E-01 (行24) | ○ |
| C-04 | python3でgen_spirv_dialect.pyを呼び出す | E-01 (行26) | ○ |
| C-05 | --base-td-pathでSPIRVBase.tdを指定する | E-01 (行27) | ○ |
| C-06 | --new-opcodeで命令名を渡す | E-01 (行28) | ○ |
| C-07 | $@で全引数を渡す | E-01 (行28) | ○ |
| C-08 | 引数なしの場合は既存定義を更新する | E-01 (行16コメント) | ○ |
| C-09 | 使用例がコメントに記載されている | E-01 (行13-14コメント) | ○ |
| C-10 | instructionsリストから情報を取得する | E-01 (行17-19コメント) | ○ |
| C-11 | define_inst.shから呼び出される | E-02 (行52) | ○ |
| C-12 | MLIRコード生成が目的 | E-03 (バッチ一覧) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] gen_spirv_dialect.pyの--new-opcodeオプションの動作を確認
- [ ] 実際に実行して出力を確認
- [ ] SPIR-V仕様の取得方法を確認
