---
generated_at: 2026-02-01 10:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：43-run-qemu.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lldb/scripts/lldb-test-qemu/run-qemu.sh` 行1-130（メインソースコード）
- E-02: `lldb/scripts/lldb-test-qemu/run-qemu.sh` 行3-19（print_usage関数）
- E-03: `lldb/scripts/lldb-test-qemu/run-qemu.sh` 行26-43（run_qemu関数）
- E-04: `lldb/scripts/lldb-test-qemu/run-qemu.sh` 行45-59（引数解析）
- E-05: `lldb/scripts/lldb-test-qemu/run-qemu.sh` 行66-97（ファイル存在確認）
- E-06: `lldb/scripts/lldb-test-qemu/run-qemu.sh` 行99-127（アーキテクチャ設定）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ARMおよびAArch64向けQEMUシステムエミュレーションを起動 | E-02 行4-5 | ○ |
| C-02 | --archでarm/arm64を指定可能 | E-04 行48 | ○ |
| C-03 | --rootfsでrootfsイメージパスを指定 | E-04 行49 | ○ |
| C-04 | --kernelでカーネルイメージパスを指定可能 | E-04 行50 | ○ |
| C-05 | --qemuでQEMUバイナリパスを指定可能 | E-04 行51 | ○ |
| C-06 | --sveでSVEモードを有効化 | E-04 行52, E-06 行117-123 | ○ |
| C-07 | --mteでMTEモードを有効化 | E-04 行53, E-06 行124-126 | ○ |
| C-08 | --smeでSMEモードを有効化 | E-04 行54, E-06 行117-123 | ○ |
| C-09 | rootfsが存在しない場合はエラー終了 | E-05 行66-69 | ○ |
| C-10 | デフォルトでlinux.build/{arch}からカーネル検索 | E-05 行72-84 | ○ |
| C-11 | ARMはzImageを使用 | E-05 行80 | ○ |
| C-12 | AArch64はImageを使用 | E-05 行82 | ○ |
| C-13 | デフォルトでqemu.gitからQEMU検索 | E-05 行86-97 | ○ |
| C-14 | ARM: virt,highmem=off / cortex-a15 | E-06 行99-101 | ○ |
| C-15 | AArch64: virt / cortex-a53 | E-06 行112-115 | ○ |
| C-16 | SVE/MTE/SME時はCPU=max | E-06 行117-118 | ○ |
| C-17 | SVE最大ベクター長はVQ=4 | E-06 行114, 122 | ○ |
| C-18 | MTE有効時はmte=on設定 | E-06 行124-126 | ○ |
| C-19 | 2コア、1024MBメモリで起動 | E-03 行27-28 | ○ |
| C-20 | -nographicでコンソール出力 | E-03 行42 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに直接対応しており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] tapデバイスの事前設定手順がドキュメント化されているか確認
- [ ] SVE/MTE/SMEの各拡張機能の要件が明確か確認
- [ ] QEMUバージョン要件（特にSMEサポート）が記載されているか確認
