---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 7
  claims_with_evidence: 7
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：48-cleanup_run_static_analyzer.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：7 / 7、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang/utils/analyzer/projects/capnproto/cleanup_run_static_analyzer.sh` 行1（メインソースコード）
- E-02: 複数のプロジェクトディレクトリに同一内容のスクリプトが存在（termbox、cppcheck、oatpp等）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | buildディレクトリを削除するスクリプト | E-01 | ○ |
| C-02 | rm -rf ./build を実行 | E-01 | ○ |
| C-03 | 1行のシンプルなスクリプト | E-01 | ○ |
| C-04 | コマンドライン引数を受け取らない | E-01（引数処理なし） | ○ |
| C-05 | ファイル出力を行わない | E-01（出力処理なし） | ○ |
| C-06 | 複数のプロジェクトに同一スクリプトが存在 | E-02（findコマンドで確認） | ○ |
| C-07 | 静的解析後のクリーンアップ用途 | E-01（ディレクトリ構造から推測） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - スクリプトが1行で、動作が明確

## 6) レビュアーチェックリスト（最小）
- [ ] 誤って重要なbuildディレクトリを削除しないよう、実行場所を確認する手順があるか確認
- [ ] 静的解析ワークフローとの連携方法が明確か確認
