---
generated_at: 2026-02-01 10:40:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：49-symbolize.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `compiler-rt/lib/gwp_asan/scripts/symbolize.sh` 行1-56（メインソースコード全体）
- E-02: `compiler-rt/lib/gwp_asan/scripts/symbolize.sh` 行3-4（コメント：入力形式の説明）
- E-03: `compiler-rt/lib/gwp_asan/scripts/symbolize.sh` 行8-16（シンボル化対象判定）
- E-04: `compiler-rt/lib/gwp_asan/scripts/symbolize.sh` 行18-24（行の解析）
- E-05: `compiler-rt/lib/gwp_asan/scripts/symbolize.sh` 行26-45（シンボル化処理）
- E-06: `compiler-rt/lib/gwp_asan/scripts/symbolize.sh` 行47-54（結果出力）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | GWP-ASANクラッシュのスタックトレースをシンボル化 | E-02 行3-6 | ○ |
| C-02 | backtrace_symbols()形式に対応 | E-02 行3-6 | ○ |
| C-03 | while read -r lineで行を読み込み | E-01 行8 | ○ |
| C-04 | 正規表現でシンボル化対象を判定 | E-03 行10-11 | ○ |
| C-05 | 非対象行はそのまま出力 | E-03 行13-16 | ○ |
| C-06 | バイナリ名を抽出 | E-04 行19-20 | ○ |
| C-07 | 関数名を抽出 | E-04 行21 | ○ |
| C-08 | 関数オフセットを抽出 | E-04 行22-23 | ○ |
| C-09 | フレーム番号を抽出 | E-04 行24 | ○ |
| C-10 | 関数名がない場合はオフセットで直接addr2line | E-05 行26-28 | ○ |
| C-11 | nmで関数アドレスを取得 | E-05 行32-34 | ○ |
| C-12 | 関数アドレスとオフセットを加算 | E-05 行43 | ○ |
| C-13 | addr2lineで-iオプションを使用 | E-05 行28, 44 | ○ |
| C-14 | addr2lineで-eオプションでバイナリ指定 | E-05 行28, 44 | ○ |
| C-15 | シンボル化失敗時は元の行を出力 | E-06 行48-51, E-05 行37-40 | ○ |
| C-16 | シンボル化成功時はフレーム番号+シンボル情報 | E-06 行53 | ○ |
| C-17 | DWARFエラーをgrepでフィルタリング | E-01 行55 | ○ |
| C-18 | 入力形式パターン例 | E-02 行4 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに直接対応しており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 対象となるbacktrace_symbols()形式がScudo実装と一致しているか確認
- [ ] addr2lineとnmのバージョン要件が記載されているか確認
- [ ] デバッグ情報の要件（DWARF形式等）が明確か確認
