---
generated_at: 2026-02-01 10:20:00
metrics:
  claims_total: 30
  claims_with_evidence: 29
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：5-test-release.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：29 / 30、根拠なし：1
- 優先レビュー（高）
  1. **目標処理時間**：環境依存のため具体的な数値根拠なし

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/utils/release/test-release.sh` (行1-791)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行6)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 3段階のブートストラップビルドを実行 | E-01 (行711-744: Phase 1/2/3) | ○ |
| C-02 | -releaseと-rcオプションが必須 | E-01 (行226-233) | ○ |
| C-03 | -tripleオプションが必須 | E-01 (行237-240) | ○ |
| C-04 | GitHubからtarballをダウンロード | E-01 (行418-419) | ○ |
| C-05 | Phase比較でオブジェクトファイルを比較 | E-01 (行749-764) | ○ |
| C-06 | chrpathが必要（Darwin/SunOS/AIX除く） | E-01 (行399-401) | ○ |
| C-07 | ulimit -c 0でコアダンプ無効化 | E-01 (行632) | ○ |
| C-08 | check-all実行 | E-01 (行571) | ○ |
| C-09 | test-suite実行（オプション） | E-01 (行576-586) | ○ |
| C-10 | deferred_errors.logにエラー記録 | E-01 (行333, 383-388) | ○ |
| C-11 | xzまたはgzipでパッケージ生成 | E-01 (行615-619, 769-773) | ○ |
| C-12 | FreeBSD環境ではgmakeを使用 | E-01 (行16-20) | ○ |
| C-13 | -use-ninjaでNinjaを使用可能 | E-01 (行133-135) | ○ |
| C-14 | Phase 1ではClangのみビルド | E-01 (行471-475, 530-532) | ○ |
| C-15 | Phase 2ではランタイムも含む | E-01 (行479-487) | ○ |
| C-16 | MLIRなしでFlangはビルド不可 | E-01 (行220-223) | ○ |
| C-17 | Linux x86_64/ARM64でBOLTデフォルト有効 | E-01 (行51-57) | ○ |
| C-18 | clean_RPATH関数でRPATHクリーンアップ | E-01 (行592-608) | ○ |
| C-19 | Python venvでtest-suite環境構築 | E-01 (行649-651) | ○ |
| C-20 | litをpipでインストール | E-01 (行650) | ○ |
| C-21 | set -eとset -o pipefailを設定 | E-01 (行627-628) | ○ |
| C-22 | -silent-logでビルドログ抑制 | E-01 (行335-339) | ○ |
| C-23 | AIXではPhase 1でcompiler-rt builtins必要 | E-01 (行481-484, 534-537) | ○ |
| C-24 | プロジェクトリストを動的構築 | E-01 (行277-314) | ○ |
| C-25 | CPU数を自動検出 | E-01 (行256-267) | ○ |
| C-26 | -git-refで任意のrefをテスト可能 | E-01 (行107-117) | ○ |
| C-27 | usage関数でヘルプ表示 | E-01 (行59-91) | ○ |
| C-28 | CMake cacheモードに対応 | E-01 (行342-381, 654-657) | ○ |
| C-29 | ビルドログをlogsディレクトリに出力 | E-01 (行321-323) | ○ |
| C-30 | 目標処理時間は数時間〜1日 | **根拠なし**（環境依存） | △ |

## 4) 不足情報（Unknown / Missing）
- 具体的な処理時間のベンチマーク
  - 候補：リリースプロセスドキュメント / 過去のリリースログ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大規模スクリプトだが、主張の大半がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 対応プラットフォーム（Linux, Darwin, FreeBSD, SunOS, AIX）の記述が最新か確認
- [ ] プロジェクトリスト（clang, lld, polly, mlir, flang等）が最新か確認
- [ ] CMake cacheモード（-use-cmake-cache）の動作が現在のリリースプロセスと整合しているか確認
- [ ] BOLTのデフォルト有効条件が正しいか確認
