---
generated_at: 2026-02-01 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：50-check_custom_wrappers.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `compiler-rt/lib/dfsan/scripts/check_custom_wrappers.sh` 行1-55（メインソースコード全体）
- E-02: `compiler-rt/lib/dfsan/scripts/check_custom_wrappers.sh` 行3-6（パス設定）
- E-03: `compiler-rt/lib/dfsan/scripts/check_custom_wrappers.sh` 行8-11（一時ファイル作成）
- E-04: `compiler-rt/lib/dfsan/scripts/check_custom_wrappers.sh` 行13-18（クリーンアップ関数）
- E-05: `compiler-rt/lib/dfsan/scripts/check_custom_wrappers.sh` 行20-34（ABIリスト vs ラッパー比較）
- E-06: `compiler-rt/lib/dfsan/scripts/check_custom_wrappers.sh` 行36-47（ラッパー vs テスト比較）
- E-07: `compiler-rt/lib/dfsan/scripts/check_custom_wrappers.sh` 行49-53（結果出力）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | DFSanカスタムラッパーの整合性をチェック | E-01 全体 | ○ |
| C-02 | done_abilist.txtをABIリストとして使用 | E-02 行6 | ○ |
| C-03 | dfsan_custom.cppからラッパー実装を参照 | E-02 行5 | ○ |
| C-04 | custom.cppからテストを参照 | E-02 行4 | ○ |
| C-05 | mktempで一時ファイルを作成 | E-03 行8-11 | ○ |
| C-06 | trapでEXIT時にクリーンアップ | E-04 行21 | ○ |
| C-07 | ABIリストから"fun:*=custom"を抽出 | E-05 行22 | ○ |
| C-08 | __sanitizer_cov_trace*を除外 | E-05 行23, E-06 行37 | ○ |
| C-09 | dfsan_get_label/dfsan_get_originを除外 | E-05 行23 | ○ |
| C-10 | sedで関数名を抽出 | E-05 行24, 27 | ○ |
| C-11 | sortで整列 | E-05 行24, 27 | ○ |
| C-12 | uniqで重複除去 | E-05 行27 | ○ |
| C-13 | diff -uで比較 | E-05 行28, E-06 行41 | ○ |
| C-14 | 差分があればエラーログに追記 | E-05 行29-34, E-06 行42-47 | ○ |
| C-15 | __dfsw_*形式でラッパー関数を抽出 | E-05 行25-27 | ○ |
| C-16 | test_*()形式でテスト関数を抽出 | E-06 行39-40 | ○ |
| C-17 | エラーログが空でなければ終了コード1 | E-07 行49-53 | ○ |
| C-18 | エラーメッセージを標準出力に表示 | E-07 行51-52 | ○ |
| C-19 | on_exit関数で一時ファイルを削除 | E-04 行13-18 | ○ |
| C-20 | /bin/shで実行 | E-01 行1 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードに直接対応しており、信頼性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] 除外対象の関数（__sanitizer_cov_trace*等）が適切か確認
- [ ] ABIリスト、ラッパー実装、テストの各ファイルパスが正しいか確認
- [ ] CIパイプラインでの実行方法が明確か確認
