---
generated_at: 2026-02-01 10:25:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：6-build-docs.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/utils/release/build-docs.sh` (行1-161)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行7)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | -releaseと-srcdirは排他的 | E-01 (行77-80) | ○ |
| C-02 | -no-doxygenと-no-sphinxの同時指定不可 | E-01 (行100-103) | ○ |
| C-03 | GitHubからtarballダウンロード | E-01 (行95: curl -L) | ○ |
| C-04 | LLVM_ENABLE_SPHINXを設定 | E-01 (行108) | ○ |
| C-05 | SPHINX_WARNINGS_AS_ERRORS=OFF | E-01 (行108) | ○ |
| C-06 | LLVM_ENABLE_DOXYGENを設定 | E-01 (行116) | ○ |
| C-07 | Sphinxターゲット6種類 | E-01 (行107) | ○ |
| C-08 | Doxygenターゲット6種類 | E-01 (行115) | ○ |
| C-09 | Ninjaジェネレータを使用 | E-01 (行121, 128) | ○ |
| C-10 | ランタイムドキュメント用に別CMake構成 | E-01 (行130-133) | ○ |
| C-11 | docs-libcxx-htmlをビルド | E-01 (行136) | ○ |
| C-12 | package_doxygen関数でtarball生成 | E-01 (行41-49) | ○ |
| C-13 | Doxygenはxzで圧縮 | E-01 (行48) | ○ |
| C-14 | html-exportディレクトリにSphinxドキュメント配置 | E-01 (行149-154) | ○ |
| C-15 | libc++はprojects/配下に配置 | E-01 (行156-159) | ○ |
| C-16 | llvm-projectディレクトリ既存時エラー | E-01 (行89-92) | ○ |
| C-17 | builddir=docs-build | E-01 (行25) | ○ |
| C-18 | 必要パッケージがコメントに記載 | E-01 (行13-20) | ○ |
| C-19 | LLVM_ENABLE_PROJECTSを設定 | E-01 (行122) | ○ |
| C-20 | set -eでエラー時停止 | E-01 (行23) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] Sphinxターゲットリストが現在のプロジェクト構成と一致しているか確認
- [ ] Doxygenターゲットリストが現在のプロジェクト構成と一致しているか確認
- [ ] 必要パッケージのリストが最新か確認（Fedora/Ubuntu）
- [ ] libc++ドキュメントのprojects/配下への配置が引き続き必要か確認
