---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：7-export.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 特になし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/utils/release/export.sh` (行1-195)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行8)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | サブプロジェクトリスト18項目 | E-01 (行16) | ○ |
| C-02 | テンプレートデフォルト値 | E-01 (行23) | ○ |
| C-03 | template_file関数でファイル名生成 | E-01 (行75-79) | ○ |
| C-04 | git archiveでtarball生成 | E-01 (行118, 138) | ○ |
| C-05 | xz -T0で全CPUコア使用 | E-01 (行118, 138) | ○ |
| C-06 | -git-refと-release/-rcは排他的 | E-01 (行181-185) | ○ |
| C-07 | -releaseも-git-refも必須 | E-01 (行186-188) | ○ |
| C-08 | GitHubからtest-suiteダウンロード | E-01 (行125-126) | ○ |
| C-09 | -git-ref時はtest-suiteスキップ | E-01 (行121-132) | ○ |
| C-10 | LLVMVersion.cmakeからバージョン取得 | E-01 (行90) | ○ |
| C-11 | メタデータファイル3種類生成 | E-01 (行114-116) | ○ |
| C-12 | umask 0022を設定 | E-01 (行192) | ○ |
| C-13 | tar --sort=nameで再現性確保 | E-01 (行129) | ○ |
| C-14 | tar --owner=0 --group=0 | E-01 (行129) | ○ |
| C-15 | set -eでエラー時停止 | E-01 (行14) | ○ |
| C-16 | usage関数でヘルプ表示 | E-01 (行25-73) | ○ |
| C-17 | -sub-projectsでサブプロジェクト個別生成 | E-01 (行134-141) | ○ |
| C-18 | llvmorg-{VERSION}形式のタグ名 | E-01 (行82, 93-99) | ○ |
| C-19 | envsubstでテンプレート展開 | E-01 (行77) | ○ |
| C-20 | gitリポジトリチェック | E-01 (行85) | ○ |
| C-21 | test-suiteディレクトリ既存時スキップ | E-01 (行122-127) | ○ |
| C-22 | pax-optionで再現性確保 | E-01 (行130) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] サブプロジェクトリストが現在のllvm-project構成と一致しているか確認
- [ ] テンプレートプレースホルダが正しく機能しているか確認
- [ ] test-suite GitHubリポジトリのURLが有効か確認
