---
generated_at: 2026-02-01 10:35:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：8-merge-request.sh

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **現在の使用状況**：SVN時代のスクリプトであり、現在のGitワークフローでの使用状況が不明

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/utils/release/merge-request.sh` (行1-220)
- E-02: `docs/code-to-docs/バッチ一覧/バッチ一覧.csv` (行9)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | -user、-stable-version、-rが必須 | E-01 (行85-118) | ○ |
| C-02 | bugzilla CLIバージョン2.0.0以上を要求 | E-01 (行140-147) | ○ |
| C-03 | 重複バグを確認 | E-01 (行156-164) | ○ |
| C-04 | SVN logからコミットメッセージ取得 | E-01 (行170-178) | ○ |
| C-05 | Bugzillaにログイン | E-01 (行190) | ○ |
| C-06 | bugzilla newでバグ作成 | E-01 (行192-200) | ○ |
| C-07 | リビジョンリンクをコメント追加 | E-01 (行217-219) | ○ |
| C-08 | メタバグIDマッピング（4.0-9.0） | E-01 (行90-112) | ○ |
| C-09 | Bugzilla XMLRPC URL | E-01 (行25) | ○ |
| C-10 | -dry-runでコマンド表示 | E-01 (行69-70, 202-204) | ○ |
| C-11 | -assign-toで担当者指定 | E-01 (行65-67, 199) | ○ |
| C-12 | cf_fixed_by_commitsカスタムフィールド | E-01 (行158, 196) | ○ |
| C-13 | Product=new-bugs | E-01 (行20, 193) | ○ |
| C-14 | Component=new bugs（デフォルト） | E-01 (行21, 194) | ○ |
| C-15 | バグサマリ形式 | E-01 (行185) | ○ |
| C-16 | reviews.llvm.org/rL形式のリンク | E-01 (行218) | ○ |
| C-17 | usage関数でヘルプ表示 | E-01 (行27-37) | ○ |
| C-18 | set -xでコマンドトレース | E-01 (行187) | ○ |
| C-19 | which bugzillaで自動検出 | E-01 (行125-126) | ○ |
| C-20 | 現在のGitワークフローでの使用状況 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 現在のLLVMプロジェクトでこのスクリプトが使用されているかどうか
  - 候補：リリースプロセスドキュメント / リリースマネージャーへの確認

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - スクリプトがSVN URLを参照しており、現在のGitワークフローとの互換性が不明

## 6) レビュアーチェックリスト（最小）
- [ ] このスクリプトが現在のリリースプロセスで使用されているか確認
- [ ] SVN URL (https://llvm.org/svn/llvm-project/) が現在も有効か確認
- [ ] 対応バージョン（4.0-9.0）が最新のリリースをカバーしているか確認
- [ ] Bugzillaが引き続きマージリクエストの追跡に使用されているか確認
