---
generated_at: 2026-02-01 10:00:00
metrics:
  claims_total: 120
  claims_with_evidence: 105
  claims_without_evidence: 15
confidence_derived: 0.88
---

# 根拠レポート：bolt.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：105 / 120、根拠なし：15
- 優先レビュー（高）
  1. **最適化パス関連テスト（UT-BOLT-107〜113）**：実装詳細の確認が必要
  2. **BinaryFunction関連テスト**：BinaryFunction.hが大きすぎて一部読み込めなかった
  3. **プロファイル処理関連テスト**：DataAggregator以外のプロファイル機能

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `bolt/include/bolt/Core/BinaryContext.h` - BinaryContextクラス定義
- E-02: `bolt/include/bolt/Core/BinaryBasicBlock.h` - BinaryBasicBlockクラス定義
- E-03: `bolt/include/bolt/Core/DynoStats.h` - DynoStatsクラス定義
- E-04: `bolt/include/bolt/Core/Relocation.h` - Relocationクラス定義
- E-05: `bolt/include/bolt/Passes/BinaryPasses.h` - 最適化パス定義
- E-06: `bolt/unittests/Core/BinaryContext.cpp` - BinaryContextユニットテスト
- E-07: `bolt/unittests/Core/MCPlusBuilder.cpp` - MCPlusBuilderユニットテスト
- E-08: `bolt/unittests/Core/DynoStats.cpp` - DynoStatsユニットテスト
- E-09: `bolt/unittests/Profile/DataAggregator.cpp` - DataAggregatorユニットテスト
- E-10: `bolt/lib/Core/BinaryContext.cpp` - BinaryContext実装
- E-11: `bolt/lib/Core/BinaryBasicBlock.cpp` - BinaryBasicBlock実装
- E-12: `bolt/lib/Core/MCPlusBuilder.cpp` - MCPlusBuilder実装

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BinaryContext::createBinaryContext正常作成 | E-01, E-06 | ○ |
| C-02 | BinaryContext::createBinaryContext異常系 | E-01 | ○ |
| C-03 | getBinaryFunctionContainingAddress正常系 | E-01 | ○ |
| C-04 | getBinaryFunctionContainingAddress境界値 | E-01 | ○ |
| C-05 | getBinaryFunctionContainingAddress異常系 | E-01 | ○ |
| C-06 | getBinaryFunctionAtAddress正常系 | E-01 | ○ |
| C-07 | getJumpTableContainingAddress正常系 | E-01 | ○ |
| C-08 | getJumpTableContainingAddress境界値 | E-01 | ○ |
| C-09 | getJumpTableEntrySize PIC | E-01 | ○ |
| C-10 | getJumpTableEntrySize通常 | E-01 | ○ |
| C-11 | getDWARFEncodingSize omit | E-01 | ○ |
| C-12 | getDWARFEncodingSize udata4 | E-01 | ○ |
| C-13 | getBaseAddressForMapping正常系 | E-01, E-06 | ○ |
| C-14 | getBaseAddressForMapping異常系 | E-06 | ○ |
| C-15 | registerSection正常系 | E-01 | ○ |
| C-16 | registerOrUpdateSection正常系 | E-01 | ○ |
| C-17 | getSectionForAddress正常系 | E-01 | ○ |
| C-18 | getSectionForAddress異常系 | E-01 | ○ |
| C-19 | getOrCreateGlobalSymbol正常系 | E-01 | ○ |
| C-20 | getBinaryDataAtAddress正常系 | E-01 | ○ |
| C-21 | getBinaryDataAtAddress異常系 | E-01 | ○ |
| C-22 | containsAddress正常系 | E-01 | ○ |
| C-23 | containsAddress境界値 | E-01 | ○ |
| C-24 | isELF正常系 | E-01 | ○ |
| C-25 | isAArch64正常系 | E-01 | ○ |
| C-26 | isX86正常系 | E-01 | ○ |
| C-27 | computeInstructionSize正常系 | E-01 | ○ |
| C-28 | computeInstructionSize疑似命令 | E-01 | ○ |
| C-29 | BinaryBasicBlock::addInstruction | E-02 | ○ |
| C-30 | BinaryBasicBlock::addSuccessor | E-02 | ○ |
| C-31 | getSuccessor正常系 | E-02 | ○ |
| C-32 | getSuccessor単一後続 | E-02 | ○ |
| C-33 | getConditionalSuccessor正常系 | E-02 | ○ |
| C-34 | getConditionalSuccessor異常系 | E-02 | ○ |
| C-35 | swapConditionalSuccessors正常系 | E-02 | ○ |
| C-36 | swapConditionalSuccessors異常系 | E-02 | ○ |
| C-37 | removeSuccessor正常系 | E-02 | ○ |
| C-38 | removeAllSuccessors正常系 | E-02 | ○ |
| C-39 | isPredecessor正常系 | E-02 | ○ |
| C-40 | isSuccessor正常系 | E-02 | ○ |
| C-41 | hasProfile正常系 | E-02 | ○ |
| C-42 | getExecutionCount正常系 | E-02 | ○ |
| C-43 | setExecutionCount正常系 | E-02 | ○ |
| C-44 | getCFIState正常系 | E-02 | ○ |
| C-45 | getCFIState異常系 | E-02 | ○ |
| C-46 | getNumPseudos正常系 | E-02 | ○ |
| C-47 | getNumNonPseudos正常系 | E-02 | ○ |
| C-48 | splitAt正常系 | E-02 | ○ |
| C-49 | eraseInstruction正常系 | E-02 | ○ |
| C-50 | replaceInstruction正常系 | E-02 | ○ |
| C-51 | estimateSize正常系 | E-02 | ○ |
| C-52 | getOutputSize正常系 | E-02 | ○ |
| C-53 | isLandingPad正常系 | E-02 | ○ |
| C-54 | isSplit正常系 | E-02 | ○ |
| C-55 | MCPlusBuilder::getAliases X86 | E-07 | ○ |
| C-56 | getAliases OnlySmaller | E-07 | ○ |
| C-57 | getClobberedRegs正常系 | E-07 | ○ |
| C-58 | getTouchedRegs正常系 | E-07 | ○ |
| C-59 | getWrittenRegs正常系 | E-07 | ○ |
| C-60 | getUsedRegs正常系 | E-07 | ○ |
| C-61 | createCmpJE AArch64 | E-07 | ○ |
| C-62 | createCmpJNE AArch64 | E-07 | ○ |
| C-63 | createCmpJE X86 | E-07 | ○ |
| C-64 | createCmpJNE X86 | E-07 | ○ |
| C-65 | createBTI正常系 | E-07 | ○ |
| C-66 | isBTILandingPad正常系 | E-07 | ○ |
| C-67 | insertBTI空ブロック | E-07 | ○ |
| C-68 | insertBTI拡張 | E-07 | ○ |
| C-69 | replaceRegWithImm X86 | E-07 | ○ |
| C-70 | isPSignOnLR正常系 | E-07 | ○ |
| C-71 | isPAuthOnLR正常系 | E-07 | ○ |
| C-72 | isPAuthAndRet正常系 | E-07 | ○ |
| C-73 | addEHInfo正常系 | E-07 | ○ |
| C-74 | getEHInfo正常系 | E-07 | ○ |
| C-75 | addEHInfo境界値 | E-07 | ○ |
| C-76 | addEHInfo異常系 | E-07 | ○ |
| C-77 | DynoStats::operator[]正常系 | E-03 | ○ |
| C-78 | DynoStats::operator+=正常系 | E-03 | ○ |
| C-79 | DynoStats::operator==正常系 | E-03 | ○ |
| C-80 | DynoStats::operator<正常系 | E-03 | ○ |
| C-81 | getDynoStats空マップ | E-08 | ○ |
| C-82 | Relocation::getSizeForType | E-04 | ○ |
| C-83 | Relocation::isPCRelative | E-04 | ○ |
| C-84 | Relocation::isGOT | E-04 | ○ |
| C-85 | Relocation::isNone | E-04 | ○ |
| C-86 | Relocation::isTLS | E-04 | ○ |
| C-87 | Relocation::encodeValue | E-04 | ○ |
| C-88 | Relocation::extractValue | E-04 | ○ |
| C-89 | Relocation::canEncodeValue | E-04 | ○ |
| C-90 | flushPendingRelocations CALL26 | E-06 | ○ |
| C-91 | flushPendingRelocations JUMP26 | E-06 | ○ |
| C-92 | flushPendingRelocationsオプショナル | E-06 | ○ |
| C-93 | DataAggregator::hasAllBuildIDs正常 | E-09 | ○ |
| C-94 | DataAggregator::hasAllBuildIDs異常 | E-09 | ○ |
| C-95 | getFileNameForBuildID正常系 | E-09 | ○ |
| C-96 | getFileNameForBuildID異常系 | E-09 | ○ |
| C-97 | truncateToSize正常系 | E-01 | ○ |
| C-98 | truncateToSize境界値 | E-01 | ○ |
| C-99 | FilterIterator::operator++正常系 | E-01 | ○ |
| C-100 | FilterIterator::operator==正常系 | E-01 | ○ |
| C-101 | BOLTError::isFatal正常系 | E-01 | ○ |
| C-102 | BOLTError::getMessage正常系 | E-01 | ○ |
| C-103 | createNonFatalBOLTError正常系 | E-01 | ○ |
| C-104 | createFatalBOLTError正常系 | E-01 | ○ |
| C-105 | BinaryFunctionPass::shouldOptimize | E-05 | ○ |
| C-106 | BinaryFunctionPass::shouldPrint | E-05 | △ |
| C-107 | NormalizeCFG::runOnFunctions | E-05 | △ |
| C-108 | EliminateUnreachableBlocks::runOnFunctions | E-05 | △ |
| C-109 | ReorderBasicBlocks::modifyFunctionLayout | E-05 | △ |
| C-110 | SimplifyConditionalTailCalls::fixTailCalls | E-05 | △ |
| C-111 | ShortenInstructions::shortenInstructions | E-05 | △ |
| C-112 | Peepholes::addTailcallTraps | E-05 | △ |
| C-113 | SimplifyRODataLoads::simplifyRODataLoads | E-05 | △ |
| C-114 | SegmentInfo::print | E-01 | ○ |
| C-115 | forceSymbolRelocations | **根拠なし** | △ |
| C-116 | isGOTSymbol正常系 | E-01 | ○ |
| C-117 | isInternalSymbolName正常系 | E-01 | ○ |
| C-118 | areRelatedFragments | **根拠なし** | △ |
| C-119 | registerFragment | **根拠なし** | △ |
| C-120 | createIndependentMCCodeEmitter | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）

### 根拠なしの理由

1. **最適化パス実装詳細（C-107〜C-113）**
   - ヘッダファイルにはインターフェース定義があるが、詳細な動作仕様は実装ファイル（lib/Passes/）を確認する必要がある
   - 候補：`bolt/lib/Passes/BinaryPasses.cpp` / `bolt/lib/Passes/NormalizeCFG.cpp` 等

2. **BinaryFunction関連（C-106等）**
   - BinaryFunction.hが25000トークンを超えており全体を読み込めなかった
   - 候補：`bolt/include/bolt/Core/BinaryFunction.h` の分割読み込み

3. **シンボル関連機能（C-115, C-118, C-119）**
   - 詳細な動作条件が実装ファイルに記載されている可能性
   - 候補：`bolt/lib/Core/BinaryContext.cpp`

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 理由 |
|---|---|---|
| 2: 高リスク | 最適化パス関連（C-107〜C-113） | 実装詳細が未確認、テスト観点が不足している可能性 |
| 1: 中リスク | BinaryFunction関連 | ヘッダファイルが大きく全容を把握できていない |
| 1: 中リスク | プロファイル処理 | DataAggregator以外のプロファイル機能が未確認 |
| 0: 低リスク | コアクラス（BinaryContext, BinaryBasicBlock） | ユニットテストと照合して確認済み |
| 0: 低リスク | MCPlusBuilder関連 | 詳細なユニットテストが存在し確認済み |

## 6) レビュアーチェックリスト（最小）

- [ ] 最適化パス（NormalizeCFG, EliminateUnreachableBlocks等）の実装ファイルを確認し、テストケースの妥当性を検証
- [ ] BinaryFunction.hの全内容を確認し、不足しているテストケースがないか確認
- [ ] 各アーキテクチャ（X86, AArch64, RISC-V）固有のテストケースが網羅されているか確認
- [ ] プロファイル処理（Heatmap, YAMLProfileReader等）のテストケースが必要か検討
- [ ] 実行時ライブラリ（runtime/）に対するテストケースが必要か検討
- [ ] Rewrite系クラス（RewriteInstance, DWARFRewriter等）のテストケースが必要か検討
