---
generated_at: 2026-02-01 22:30:00
metrics:
  claims_total: 115
  claims_with_evidence: 109
  claims_without_evidence: 6
confidence_derived: 0.95
---

# 根拠レポート：clang-tools-extra 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：109 / 115、根拠なし：6
- 優先レビュー（高）
  1. **UT-CTE-058 (estimateMemoryUsage)**: 戻り値の具体的な計算方法の根拠不足
  2. **UT-CTE-075 (isDeeplyNested)**: MaxDepthのデフォルト値の根拠不足
  3. **UT-CTE-089 (addRuler)**: Markdown出力形式の詳細根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `/clang-tools-extra/clangd/URI.h` - URI クラス定義
- E-02: `/clang-tools-extra/clangd/SourceCode.h` - ソースコード操作関数群
- E-03: `/clang-tools-extra/clangd/AST.h` - AST ユーティリティ関数群
- E-04: `/clang-tools-extra/clangd/index/Index.h` - インデックスインターフェース
- E-05: `/clang-tools-extra/clangd/Protocol.h` - LSP プロトコル型定義
- E-06: `/clang-tools-extra/clangd/support/Markup.h` - マークアップ出力クラス
- E-07: `/clang-tools-extra/clang-tidy/ClangTidyCheck.h` - ClangTidyCheck 基底クラス
- E-08: `/clang-tools-extra/clang-move/Move.h` - clang-move ツールクラス
- E-09: `/clang-tools-extra/modularize/Modularize.h` - modularize 関数定義

## 3) Claims と根拠の対応（レビューの主戦場）

### URI クラス (UT-CTE-001 〜 UT-CTE-013)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URI コンストラクタでスキーム・オーソリティ・ボディが設定される | E-01 (URI.h:30) | ○ |
| C-02 | toString でパーセントエンコードされた文字列に変換 | E-01 (URI.h:40) | ○ |
| C-03 | create で絶対パスからURI作成 | E-01 (URI.h:44-45) | ○ |
| C-04 | create で未登録スキームでエラー | E-01 (URI.h:44) | ○ |
| C-05 | createFile で file:// スキームURI作成 | E-01 (URI.h:52) | ○ |
| C-06 | parse でURI文字列からオブジェクト構築 | E-01 (URI.h:56) | ○ |
| C-07 | parse で不正URI文字列でエラー | E-01 (URI.h:56) | ○ |
| C-08 | resolve でURIから絶対パス解決 | E-01 (URI.h:63-64) | ○ |
| C-09 | resolve でHintPath使用 | E-01 (URI.h:61-64) | ○ |
| C-10 | operator== で等価比較 | E-01 (URI.h:87-90) | ○ |
| C-11 | operator< で順序比較 | E-01 (URI.h:92-95) | ○ |
| C-12 | URIScheme::getAbsolutePath の動作 | E-01 (URI.h:115-117) | ○ |
| C-13 | URIScheme::uriFromAbsolutePath の動作 | E-01 (URI.h:119-120) | ○ |

### SourceCode 関数群 (UT-CTE-014 〜 UT-CTE-049)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-14 | positionToOffset で Position からオフセット計算 | E-02 (SourceCode.h:63-65) | ○ |
| C-15 | positionToOffset で行末を超える character の処理 | E-02 (SourceCode.h:58-59) | ○ |
| C-16 | positionToOffset で範囲外行番号でエラー | E-02 (SourceCode.h:60) | ○ |
| C-17 | offsetToPosition でオフセットから Position 計算 | E-02 (SourceCode.h:68-69) | ○ |
| C-18 | offsetToPosition でオフセット0の処理 | E-02 (SourceCode.h:68-69) | ○ |
| C-19 | offsetToPosition で末尾オフセットの処理 | E-02 (SourceCode.h:68-69) | ○ |
| C-20 | lspLength で UTF-16 コード単位数計算 | E-02 (SourceCode.h:54) | ○ |
| C-21 | lspLength でマルチバイト文字処理 | E-02 (SourceCode.h:51-54) | ○ |
| C-22 | lspLength でサロゲートペア処理 | E-02 (SourceCode.h:51-54) | ○ |
| C-23 | digest でコンテンツのダイジェスト計算 | E-02 (SourceCode.h:43) | ○ |
| C-24 | digest で同一コンテンツで同一ダイジェスト | E-02 (SourceCode.h:43) | ○ |
| C-25 | digest で異なるコンテンツで異なるダイジェスト | E-02 (SourceCode.h:43) | ○ |
| C-26 | splitQualifiedName で修飾名分割 | E-02 (SourceCode.h:145-146) | ○ |
| C-27 | splitQualifiedName で修飾なし名前処理 | E-02 (SourceCode.h:145-146) | ○ |
| C-28 | isInsideMainFile でメインファイル判定 | E-02 (SourceCode.h:86) | ○ |
| C-29 | isInsideMainFile でヘッダファイル判定 | E-02 (SourceCode.h:86) | ○ |
| C-30 | isValidFileRange で有効範囲判定 | E-02 (SourceCode.h:124) | ○ |
| C-31 | isValidFileRange で無効範囲判定 | E-02 (SourceCode.h:124) | ○ |
| C-32 | toSourceCode でソースコード取得 | E-02 (SourceCode.h:128) | ○ |
| C-33 | halfOpenToRange で範囲変換 | E-02 (SourceCode.h:132) | ○ |
| C-34 | replacementToEdit で編集変換 | E-02 (SourceCode.h:148) | ○ |
| C-35 | isKeyword でキーワード判定 (true) | E-02 (SourceCode.h:266) | ○ |
| C-36 | isKeyword でキーワード判定 (false) | E-02 (SourceCode.h:266) | ○ |
| C-37 | isHeaderFile でヘッダファイル判定 (true) | E-02 (SourceCode.h:332-333) | ○ |
| C-38 | isHeaderFile でソースファイル判定 (false) | E-02 (SourceCode.h:332-333) | ○ |
| C-39 | isReservedName でアンダースコア+大文字判定 | E-02 (SourceCode.h:339-343) | ○ |
| C-40 | isReservedName でダブルアンダースコア判定 | E-02 (SourceCode.h:339-343) | ○ |
| C-41 | isReservedName で通常名前判定 | E-02 (SourceCode.h:339-343) | ○ |
| C-42 | visibleNamespaces で可視名前空間取得 | E-02 (SourceCode.h:288-289) | ○ |
| C-43 | Edit::apply で編集適用 | E-02 (SourceCode.h:199) | ○ |
| C-44 | Edit::canApplyTo で適用可否判定 (true) | E-02 (SourceCode.h:205) | ○ |
| C-45 | Edit::canApplyTo で適用可否判定 (false) | E-02 (SourceCode.h:205) | ○ |
| C-46 | Edit::asTextEdits で TextEdits 変換 | E-02 (SourceCode.h:202) | ○ |
| C-47 | applyChange でインクリメンタル編集 | E-02 (SourceCode.h:216-217) | ○ |
| C-48 | collectIdentifiers で識別子収集 | E-02 (SourceCode.h:220-221) | ○ |
| C-49 | collectWords で単語収集 | E-02 (SourceCode.h:233) | ○ |

### SymbolIndex インターフェース (UT-CTE-050 〜 UT-CTE-063)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | fuzzyFind でクエリ一致シンボル返却 | E-04 (Index.h:143-145) | ○ |
| C-51 | fuzzyFind で空クエリ処理 | E-04 (Index.h:143-145) | ○ |
| C-52 | fuzzyFind でスコープフィルタ | E-04 (Index.h:33-39) | ○ |
| C-53 | lookup で SymbolID 検索 | E-04 (Index.h:150-152) | ○ |
| C-54 | lookup で存在しない ID 処理 | E-04 (Index.h:150-152) | ○ |
| C-55 | refs で参照検索 | E-04 (Index.h:162-163) | ○ |
| C-56 | refs で RefKind フィルタ | E-04 (Index.h:70) | ○ |
| C-57 | relations でリレーション検索 | E-04 (Index.h:179-182) | ○ |
| C-58 | estimateMemoryUsage でメモリ使用量推定 | E-04 (Index.h:199) | △ |
| C-59 | SwapIndex::reset でインデックス交換 | E-04 (Index.h:208) | ○ |
| C-60 | SwapIndex::fuzzyFind で委譲動作 | E-04 (Index.h:212-213) | ○ |
| C-61 | FuzzyFindRequest::operator== で等価比較 | E-04 (Index.h:51-58) | ○ |
| C-62 | FuzzyFindRequest::toJSON でシリアライズ | E-04 (Index.h:62) | ○ |
| C-63 | FuzzyFindRequest::fromJSON でデシリアライズ | E-04 (Index.h:60-61) | ○ |

### AST ユーティリティ (UT-CTE-064 〜 UT-CTE-075)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-64 | printQualifiedName で完全修飾名返却 | E-03 (AST.h:50) | ○ |
| C-65 | printNamespaceScope でスコープ返却 | E-03 (AST.h:53) | ○ |
| C-66 | printName で無名対応 | E-03 (AST.h:64) | ○ |
| C-67 | getSymbolID で Decl から ID 取得 | E-03 (AST.h:87) | ○ |
| C-68 | getSymbolID で MacroInfo から ID 取得 | E-03 (AST.h:96-97) | ○ |
| C-69 | isImplementationDetail で暗黙宣言判定 | E-03 (AST.h:40) | ○ |
| C-70 | hasReservedName で予約名判定 | E-03 (AST.h:81) | ○ |
| C-71 | getDeducedType で型推論 | E-03 (AST.h:170-171) | ○ |
| C-72 | getDeducedType で未推論型処理 | E-03 (AST.h:169) | ○ |
| C-73 | getQualification で修飾子計算 | E-03 (AST.h:201-204) | ○ |
| C-74 | getQualification で不要修飾子省略 | E-03 (AST.h:190-191) | ○ |
| C-75 | isDeeplyNested でネスト深度判定 | E-03 (AST.h:241) | △ |

### Protocol 型 (UT-CTE-076 〜 UT-CTE-082)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | Position::fromJSON で JSON から構築 | E-05 (Protocol.h:181) | ○ |
| C-77 | Position::toJSON で JSON に変換 | E-05 (Protocol.h:182) | ○ |
| C-78 | Range::fromJSON で JSON から構築 | E-05 (Protocol.h:185-199) | ○ |
| C-79 | Range::operator== で等価比較 | E-05 (Protocol.h:192-193) | ○ |
| C-80 | URIForFile::canonicalize でパス正規化 | E-05 (Protocol.h:97-98) | ○ |
| C-81 | URIForFile::fromURI で URI 変換 | E-05 (Protocol.h:100-101) | ○ |
| C-82 | LSPError::log でエラーログ | E-05 (Protocol.h:72-74) | ○ |

### Markup クラス (UT-CTE-083 〜 UT-CTE-090)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-83 | Paragraph::appendText でテキスト追加 | E-06 (Markup.h:53) | ○ |
| C-84 | Paragraph::appendCode でコード追加 | E-06 (Markup.h:63) | ○ |
| C-85 | Paragraph::renderMarkdown で Markdown レンダリング | E-06 (Markup.h:48) | ○ |
| C-86 | Paragraph::renderPlainText でプレーンテキストレンダリング | E-06 (Markup.h:49) | ○ |
| C-87 | Document::addParagraph で段落追加 | E-06 (Markup.h:209) | ○ |
| C-88 | Document::addCodeBlock でコードブロック追加 | E-06 (Markup.h:214) | ○ |
| C-89 | Document::addRuler で水平線追加 | E-06 (Markup.h:211) | △ |
| C-90 | BulletList::addItem で箇条書き追加 | E-06 (Markup.h:190) | ○ |

### ClangTidyCheck クラス (UT-CTE-091 〜 UT-CTE-100)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | diag で診断メッセージ出力 | E-07 (ClangTidyCheck.h:115-116) | ○ |
| C-92 | isLanguageVersionSupported で言語サポート判定 | E-07 (ClangTidyCheck.h:68-70) | ○ |
| C-93 | OptionsView::get でオプション取得 | E-07 (ClangTidyCheck.h:158) | ○ |
| C-94 | OptionsView::get で存在しないオプション処理 | E-07 (ClangTidyCheck.h:156-158) | ○ |
| C-95 | OptionsView::get<int> で整数オプションパース | E-07 (ClangTidyCheck.h:192-202) | ○ |
| C-96 | OptionsView::get<int> で不正整数の診断 | E-07 (ClangTidyCheck.h:199) | ○ |
| C-97 | OptionsView::get<bool> で真偽値パース | E-07 (ClangTidyCheck.h:510-512) | ○ |
| C-98 | OptionsView::getLocalOrGlobal でローカル優先 | E-07 (ClangTidyCheck.h:173-174) | ○ |
| C-99 | OptionsView::getLocalOrGlobal でグローバルフォールバック | E-07 (ClangTidyCheck.h:175-181) | ○ |
| C-100 | OptionsView::store でオプション保存 | E-07 (ClangTidyCheck.h:404-405) | ○ |

### clang-move ツール (UT-CTE-101 〜 UT-CTE-110)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-101 | DeclarationReporter::reportDeclaration で宣言報告 | E-08 (Move.h:34-37) | ○ |
| C-102 | DeclarationReporter::getDeclarationList でリスト取得 | E-08 (Move.h:52) | ○ |
| C-103 | MoveDefinitionSpec::Names で移動対象指定 | E-08 (Move.h:62) | ○ |
| C-104 | ClangMoveTool::registerMatchers でマッチャー登録 | E-08 (Move.h:119) | ○ |
| C-105 | ClangMoveTool::run でマッチ処理 | E-08 (Move.h:121) | ○ |
| C-106 | ClangMoveTool::onEndOfTranslationUnit で移動実行 | E-08 (Move.h:123) | ○ |
| C-107 | ClangMoveTool::addIncludes でインクルード追加 | E-08 (Move.h:136-139) | ○ |
| C-108 | ClangMoveTool::addRemovedDecl で削除記録 | E-08 (Move.h:146) | ○ |
| C-109 | ClangMoveAction::CreateASTConsumer でコンシューマ作成 | E-08 (Move.h:210-212) | ○ |
| C-110 | ClangMoveActionFactory::create でアクション作成 | E-08 (Move.h:225-227) | ○ |

### modularize ツール (UT-CTE-111 〜 UT-CTE-115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-111 | createModuleMap でモジュールマップ作成 | E-09 (Modularize.h:47-51) | ○ |
| C-112 | createModuleMap で問題ヘッダ除外 | E-09 (Modularize.h:40) | ○ |
| C-113 | createModuleMap で依存関係反映 | E-09 (Modularize.h:41) | ○ |
| C-114 | createModuleMap でルートモジュール設定 | E-09 (Modularize.h:44-46) | ○ |
| C-115 | createModuleMap で無効パスエラー | E-09 (Modularize.h:47) | △ |

## 4) 不足情報（Unknown / Missing）
- **UT-CTE-058**: `estimateMemoryUsage` の具体的なメモリ計算アルゴリズムがヘッダに記載なし
  - 候補：実装ファイル (Index.cpp) / 既存テスト (IndexTests.cpp) / ドキュメント
- **UT-CTE-075**: `isDeeplyNested` の MaxDepth デフォルト値 10 の根拠が不明
  - 候補：LLVM コーディング規約 / パフォーマンス要件ドキュメント
- **UT-CTE-089**: `addRuler` の具体的な Markdown 出力形式 (`---` vs `***` vs `___`)
  - 候補：実装ファイル (Markup.cpp) / CommonMark 仕様
- **UT-CTE-115**: `createModuleMap` の書き込み失敗時の戻り値の根拠が実装依存
  - 候補：実装ファイル (ModuleAssistant.cpp)

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: URI クラス、Protocol 型 - 明確なインターフェース定義あり
- **1 (中リスク)**: OptionsView テンプレートメソッド - 複雑な型変換ロジックを含む
- **2 (高リスク)**:
  - `positionToOffset`/`offsetToPosition` - UTF-16 エンコーディング依存で境界値テストが重要
  - `fuzzyFind` - 検索アルゴリズムの網羅的テストが必要

## 6) レビュアーチェックリスト（最小）
- [ ] UTF-16 エンコーディング関連テスト (UT-CTE-020〜022) の境界値が十分か
- [ ] SymbolIndex のコールバックベース API のエラーハンドリングが考慮されているか
- [ ] ClangTidyCheck::OptionsView のテンプレートメソッドの型安全性が確認されているか
- [ ] clang-move のファイル操作に関するエラーケースが網羅されているか
- [ ] 根拠なし項目 (△) について実装ファイルを確認し、テストケースの妥当性を検証
