---
generated_at: 2026-02-01 23:45:00
metrics:
  claims_total: 100
  claims_with_evidence: 92
  claims_without_evidence: 8
confidence_derived: 0.92
---

# 根拠レポート：clang単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたclangモジュールの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：92 / 100、根拠なし：8
- 優先レビュー（高）
  1. **UT-CLG-087〜088（LexFromRawLexer）**：実装の詳細を直接確認していない
  2. **UT-CLG-093〜098（Sema変換系）**：内部実装の詳細が複雑
  3. **UT-CLG-099〜100（UBSan）**：マクロ展開による実装のため確認が困難

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `clang/lib/Lex/Lexer.cpp` - Lexerクラスの実装
- E-02: `clang/lib/Lex/Preprocessor.cpp` - Preprocessorクラスの実装
- E-03: `clang/lib/Parse/ParseExpr.cpp` - 式パーサーの実装
- E-04: `clang/lib/AST/Decl.cpp` - 宣言ASTノードの実装
- E-05: `clang/lib/Sema/SemaOverload.cpp` - オーバーロード解決の実装
- E-06: `clang/lib/CodeGen/CGExpr.cpp` - コード生成（式）の実装
- E-07: `clang/lib/Format/Format.cpp` - コードフォーマッタの実装
- E-08: `clang/lib/Driver/Driver.cpp` - ドライバの実装
- E-09: `clang/lib/Basic/SourceManager.cpp` - ソースマネージャの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Token::isObjCAtKeywordの正常系テスト | E-01 (L59-65) | ○ |
| C-02 | Token::isObjCAtKeywordのannotation異常系 | E-01 (L60-61) | ○ |
| C-03 | Token::isObjCAtKeywordのnull異常系 | E-01 (L62-63) | ○ |
| C-04 | Token::getObjCKeywordIDの正常系 | E-01 (L68-73) | ○ |
| C-05 | Token::getObjCKeywordIDの異常系 | E-01 (L69-70) | ○ |
| C-06 | Token::isModuleContextualKeyword(export) | E-01 (L75-77) | ○ |
| C-07 | Token::isModuleContextualKeyword(import) | E-01 (L78) | ○ |
| C-08 | Token::isModuleContextualKeyword境界値 | E-01 (L76-77) | ○ |
| C-09 | Token::isSimpleTypeSpecifier基本型 | E-01 (L87-129) | ○ |
| C-10 | Token::isSimpleTypeSpecifierアノテーション | E-01 (L89-92) | ○ |
| C-11 | Token::isSimpleTypeSpecifierデフォルト | E-01 (L126-128) | ○ |
| C-12 | Lexer::InitLexer初期化 | E-01 (L137-187) | ○ |
| C-13 | Lexer::InitLexer BOMスキップ | E-01 (L150-158) | ○ |
| C-14 | Lexer::InitLexer BOMなし | E-01 (L150-158) | ○ |
| C-15 | Lexer(FileID)コンストラクタ | E-01 (L193-203) | ○ |
| C-16 | Lexer(SourceLocation)コンストラクタ | E-01 (L208-217) | ○ |
| C-17 | Lexer::Create_PragmaLexer作成 | E-01 (L252-285) | ○ |
| C-18 | Lexer::Create_PragmaLexerバッファ範囲 | E-01 (L268-270) | ○ |
| C-19 | Lexer::seekシーク処理 | E-01 (L287-292) | ○ |
| C-20 | Lexer::seek境界値 | E-01 (L290) | ○ |
| C-21 | Lexer::Stringifyエスケープ | E-01 (L294-326) | ○ |
| C-22 | Lexer::Stringify改行 | E-01 (L301-313) | ○ |
| C-23 | Lexer::Stringifyダブルクォート | E-01 (L321-323) | ○ |
| C-24 | Lexer::Stringifyシングルクォート | E-01 (L321-323) | ○ |
| C-25 | Lexer::getSpelling(SourceLocation) | E-01 (L388-422) | ○ |
| C-26 | Lexer::getSpelling無効位置 | E-01 (L397-401) | ○ |
| C-27 | Lexer::getSpelling(Token)最適化 | E-01 (L441-443) | ○ |
| C-28 | Lexer::getSpelling(Token)クリーニング | E-01 (L445-448) | ○ |
| C-29 | Lexer::resetExtendedTokenMode | E-01 (L229-235) | ○ |
| C-30 | Preprocessorコンストラクタ | E-02 (L85-174) | ○ |
| C-31 | Preprocessor __VA_ARGS__初期化 | E-02 (L128-129) | ○ |
| C-32 | Preprocessor __VA_OPT__初期化 | E-02 (L130-131) | ○ |
| C-33 | Preprocessorデストラクタ | E-02 (L176-194) | ○ |
| C-34 | Preprocessorデストラクタassert | E-02 (L177) | ○ |
| C-35 | Preprocessor::Initialize | E-02 (L196-200) | ○ |
| C-36 | Preprocessor::Initialize assert | E-02 (L198-199) | ○ |
| C-37 | Preprocessor::getIdentifierInfo | E-02 (L128) | ○ |
| C-38 | Preprocessor::SetPoisonReason | E-02 (L129, L131) | ○ |
| C-39 | Parser::ParseExpression正常系 | E-03 (L46-50) | ○ |
| C-40 | Parser::ParseExpression異常系 | E-03 (L48) | ○ |
| C-41 | Parser::ParseAssignmentExpression正常系 | E-03 (L75-93) | ○ |
| C-42 | Parser::ParseAssignmentExpressionコード補完 | E-03 (L77-81) | ○ |
| C-43 | Parser::ParseAssignmentExpression throw | E-03 (L84-85) | ○ |
| C-44 | Parser::ParseAssignmentExpression co_yield | E-03 (L86-87) | ○ |
| C-45 | Parser::ParseConditionalExpression | E-03 (L95-107) | ○ |
| C-46 | Parser::ParseConstantExpression | E-03 (L133-142) | ○ |
| C-47 | Parser::ParseConstantExpressionコンテキスト | E-03 (L138-139) | ○ |
| C-48 | Decl::isOutOfLine(true) | E-04 (L99-101) | ○ |
| C-49 | Decl::isOutOfLine(false) | E-04 (L99-101) | ○ |
| C-50 | getPrimaryMergedDecl | E-04 (L76-78) | ○ |
| C-51 | PrettyDeclStackTraceEntry::print位置 | E-04 (L80-96) | ○ |
| C-52 | PrettyDeclStackTraceEntry::print名前 | E-04 (L89-93) | ○ |
| C-53 | TranslationUnitDecl | E-04 (L103-105) | ○ |
| C-54 | GetConversionRank | E-05 (L127-150) | ○ |
| C-55 | GetConversionRank Promotion | E-05 (L135-137) | ○ |
| C-56 | CreateFunctionRefExpr | E-05 (L62-90) | ○ |
| C-57 | CreateFunctionRefExprエラー | E-05 (L66-67, L74-75) | ○ |
| C-58 | functionHasPassObjectSizeParams(true) | E-05 (L55-59) | ○ |
| C-59 | functionHasPassObjectSizeParams(false) | E-05 (L55-59) | ○ |
| C-60 | CreateTempAllocaWithoutCast | E-06 (L105-112) | ○ |
| C-61 | CreateTempAllocaWithoutCastアラインメント | E-06 (L110) | ○ |
| C-62 | MaybeCastStackAddressSpace同一 | E-06 (L114-139) | ○ |
| C-63 | MaybeCastStackAddressSpace異なる | E-06 (L125-134) | ○ |
| C-64 | CreateTempAlloca | E-06 (L141-149) | ○ |
| C-65 | ContentCache::getSizeBytesMapped | E-09 (L61-63) | ○ |
| C-66 | ContentCache::getSizeBytesMapped null | E-09 (L62) | ○ |
| C-67 | ContentCache::getMemoryBufferKind | E-09 (L67-73) | ○ |
| C-68 | ContentCache::getSize Buffer | E-09 (L79-82) | ○ |
| C-69 | ContentCache::getSize File | E-09 (L81) | ○ |
| C-70 | ContentCache::getInvalidBOM UTF-32 BE | E-09 (L84-105) | ○ |
| C-71 | ContentCache::getInvalidBOM UTF-16 BE | E-09 (L94) | ○ |
| C-72 | ContentCache::getInvalidBOM UTF-8 | E-09 (L102) | ○ |
| C-73 | ContentCache::getBufferOrNone | E-09 (L107-150) | ○ |
| C-74 | ContentCache::getBufferOrNone無効 | E-09 (L112-113) | ○ |
| C-75 | ContentCache::getBufferOrNoneエラー | E-09 (L130-134) | ○ |
| C-76 | FormatStyle BreakBeforeNoexcept | E-07 (L45-52) | ○ |
| C-77 | FormatStyle AlignConsecutiveStyle | E-07 (L54-102) | ○ |
| C-78 | FormatStyle AlignConsecutiveStyle後方互換 | E-07 (L83-88) | ○ |
| C-79 | CUIDOptions初期化 | E-08 (L130-147) | ○ |
| C-80 | CUIDOptions hash | E-08 (L135) | ○ |
| C-81 | CUIDOptions random | E-08 (L136) | ○ |
| C-82 | CUIDOptions none | E-08 (L137) | ○ |
| C-83 | CUIDOptionsエラー | E-08 (L139-141) | ○ |
| C-84 | CUIDOptions固定 | E-08 (L144-146) | ○ |
| C-85 | usesInput(true) | E-08 (L119-128) | ○ |
| C-86 | usesInput(false) | E-08 (L119-128) | ○ |
| C-87 | Lexer::LexFromRawLexer正常 | **根拠なし** | △ |
| C-88 | Lexer::LexFromRawLexer EOF | **根拠なし** | △ |
| C-89 | ParseExpressionWithLeadingAt | E-03 (L52-56) | ○ |
| C-90 | ParseExpressionWithLeadingExtension | E-03 (L58-73) | ○ |
| C-91 | ParseArrayBoundExpression | E-03 (L144-150) | ○ |
| C-92 | ParseArrayBoundExpressionコンテキスト | E-03 (L149) | ○ |
| C-93 | IsStandardConversion | **根拠なし** | △ |
| C-94 | IsTransparentUnionStandardConversion | **根拠なし** | △ |
| C-95 | IsUserDefinedConversion | **根拠なし** | △ |
| C-96 | CompareStandardConversionSequences | **根拠なし** | △ |
| C-97 | CompareQualificationConversions | E-05 (L116-118) | ○ |
| C-98 | CompareDerivedToBaseConversions | E-05 (L120-123) | ○ |
| C-99 | GetUBSanTrapForHandler | E-06 (L92-101) | ○ |
| C-100 | GetUBSanTrapForHandler unreachable | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- **LexFromRawLexer（C-87, C-88）**：Lexer.cppの読み込み範囲外に実装がある可能性
  - 候補：`clang/lib/Lex/Lexer.cpp` の後半部分 / `clang/include/clang/Lex/Lexer.h`
- **Sema変換系関数（C-93〜C-96）**：SemaOverload.cppの読み込み範囲外に詳細実装がある
  - 候補：`clang/lib/Sema/SemaOverload.cpp` の後半部分 / 関連するヘッダファイル
- **UBSan unreachable（C-100）**：マクロ展開による実装のため、コード上で直接確認困難
  - 候補：`clang/lib/CodeGen/CGExpr.cpp` のマクロ定義部分

## 5) リスクフラグ（レビュー観点）
- **リスク 0（低）**：Token系メソッド（C-01〜C-11）- 単純なswitch文と条件判定
- **リスク 0（低）**：Lexer初期化系（C-12〜C-18）- 直接的なメンバ初期化
- **リスク 1（中）**：Preprocessor系（C-30〜C-38）- 複雑な状態管理
- **リスク 1（中）**：Parser系（C-39〜C-47）- 再帰的なパース処理
- **リスク 2（高）**：Sema変換系（C-93〜C-98）- オーバーロード解決は複雑なロジック
- **リスク 1（中）**：CodeGen系（C-60〜C-64）- LLVM IRとの連携

## 6) レビュアーチェックリスト（最小）
- [ ] C-87〜C-88: LexFromRawLexerの実装を確認し、テストケースが適切か検証
- [ ] C-93〜C-96: Sema変換系関数の実際の実装を確認し、テストケースの妥当性を検証
- [ ] C-100: UBSanのunreachableケースが実際に発生し得るか確認
- [ ] 全体: 境界値テストケースが十分に網羅されているか確認
- [ ] 優先度「高」のテストケースが重要なビジネスロジックをカバーしているか確認
- [ ] 異常系テストケースがすべてのエラーパスをカバーしているか確認
