---
generated_at: 2026-02-01 21:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：compiler-rt.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード・ヘッダファイルなどの根拠（Evidence）が存在するか
2. **根拠との整合性**：テストケースの内容が実際のコードと矛盾していないか
3. **網羅性**：主要なコンポーネントが適切にカバーされているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-CRT-072 (__divdi3 ゼロ除算)**：プラットフォーム依存動作の確認が必要
  2. **UT-CRT-094-095 (Rand/RandomShuffle)**：テスト観点の妥当性確認
  3. **UT-CRT-100 (TemplateMatch)**：実際の使用パターンの確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `compiler-rt/lib/sanitizer_common/sanitizer_common.h` - 共通ユーティリティ定義
- E-02: `compiler-rt/lib/sanitizer_common/sanitizer_allocator.h` - アロケータ定義
- E-03: `compiler-rt/lib/asan/asan_internal.h` - ASan内部定義
- E-04: `compiler-rt/lib/asan/asan_interface.inc` - ASanインターフェース一覧
- E-05: `compiler-rt/lib/tsan/rtl/tsan_rtl.h` - TSanランタイム定義
- E-06: `compiler-rt/lib/msan/msan.h` - MSan定義
- E-07: `compiler-rt/lib/lsan/lsan_common.h` - LSan共通定義
- E-08: `compiler-rt/lib/ubsan/ubsan_handlers.h` - UBSanハンドラ定義
- E-09: `compiler-rt/lib/builtins/` - 組み込み関数ソース（各種.cファイル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | LowLevelAllocator::Allocate - 正常メモリ割り当て | E-01 (line 216-224) | ○ |
| C-02 | LowLevelAllocator::Allocate - サイズ0割り当て | E-01 (line 219) | ○ |
| C-03 | LowLevelAllocator::Allocate - 最大サイズ | E-01 (line 219) | ○ |
| C-04 | InternalMmapVectorNoCtor::push_back | E-01 (line 551-558) | ○ |
| C-05 | InternalMmapVectorNoCtor::operator[] | E-01 (line 543-550) | ○ |
| C-06 | InternalMmapVectorNoCtor::operator[] 範囲外 | E-01 (line 544, CHECK_LT) | ○ |
| C-07 | InternalMmapVectorNoCtor::reserve | E-01 (line 577-581) | ○ |
| C-08 | InternalMmapVectorNoCtor::resize | E-01 (line 582-588) | ○ |
| C-09 | Sort関数 | E-01 (line 685-718) | ○ |
| C-10 | Sort - 空配列 | E-01 (line 686) | ○ |
| C-11 | Sort - 単一要素 | E-01 (line 686) | ○ |
| C-12 | IsPowerOfTwo - 2の累乗 | E-01 (line 460) | ○ |
| C-13 | IsPowerOfTwo - 非累乗 | E-01 (line 460) | ○ |
| C-14 | IsPowerOfTwo - 0 | E-01 (line 460) | ○ |
| C-15 | RoundUpTo | E-01 (line 472-475) | ○ |
| C-16 | RoundUpTo - 既揃え | E-01 (line 472-475) | ○ |
| C-17 | LoadedModule::containsAddress - 範囲内 | E-01 (line 862) | ○ |
| C-18 | LoadedModule::containsAddress - 範囲外 | E-01 (line 862) | ○ |
| C-19 | SignalContext::GetType | E-01 (line 1033) | ○ |
| C-20 | SignalContext::IsStackOverflow | E-01 (line 1039) | ○ |
| C-21 | AsanInitFromRtl | E-03 (line 62-63) | ○ |
| C-22 | __asan_load1 - 正常 | E-04 (line 45) | ○ |
| C-23 | __asan_load1 - 不正アドレス | E-04 (line 45), E-03 (magic values) | ○ |
| C-24 | __asan_store4 - 正常 | E-04 (line 157) | ○ |
| C-25 | __asan_store4 - オーバーフロー | E-04 (line 157), E-03 (line 141) | ○ |
| C-26 | __asan_poison_memory_region | E-04 (line 63) | ○ |
| C-27 | __asan_unpoison_memory_region | E-04 (line 170) | ○ |
| C-28 | __asan_address_is_poisoned | E-04 (line 12) | ○ |
| C-29 | __asan_region_is_poisoned | E-04 (line 66) | ○ |
| C-30 | TSan Initialize | E-05 (line 528) | ○ |
| C-31 | ThreadCreate | E-05 (line 566) | ○ |
| C-32 | ThreadStart | E-05 (line 567-568) | ○ |
| C-33 | ThreadFinish | E-05 (line 569) | ○ |
| C-34 | MemoryAccess - 正常 | E-05 (line 535-536) | ○ |
| C-35 | MemoryAccess - レース検出 | E-05 (line 504) | ○ |
| C-36 | MutexCreate | E-05 (line 586) | ○ |
| C-37 | MutexPostLock | E-05 (line 589-590) | ○ |
| C-38 | MutexUnlock | E-05 (line 591) | ○ |
| C-39 | Acquire | E-05 (line 599) | ○ |
| C-40 | Release | E-05 (line 607) | ○ |
| C-41 | VectorClock::acquire | E-05 (line 181) | ○ |
| C-42 | VectorClock::release | E-05 (line 181) | ○ |
| C-43 | MsanAllocatorInit | E-06 (line 270) | ○ |
| C-44 | msan_malloc | E-06 (line 273) | ○ |
| C-45 | msan_malloc - ポイズン | E-06 (line 273, シャドウメモリ) | ○ |
| C-46 | MsanDeallocate | E-06 (line 271) | ○ |
| C-47 | PrintWarningWithOrigin | E-06 (line 293) | ○ |
| C-48 | ChainOrigin | E-06 (line 301) | ○ |
| C-49 | MEM_TO_SHADOW | E-06 (line 69, 96等) | ○ |
| C-50 | addr_is_type | E-06 (line 237-249) | ○ |
| C-51 | DoLeakCheck | E-07 (line 275) | ○ |
| C-52 | LsanMetadata::allocated | E-07 (line 144) | ○ |
| C-53 | LsanMetadata::tag | E-07 (line 145) | ○ |
| C-54 | LsanMetadata::set_tag | E-07 (line 146) | ○ |
| C-55 | ScanRangeForPointers | E-07 (line 265-267) | ○ |
| C-56 | LeakReport::AddLeakedChunks | E-07 (line 220) | ○ |
| C-57 | LeakReport::ApplySuppressions | E-07 (line 223) | ○ |
| C-58 | IgnoreObject - 成功 | E-07 (line 158) | ○ |
| C-59 | IgnoreObject - 無効 | E-07 (line 158, IgnoreObjectResult enum) | ○ |
| C-60 | __ubsan_handle_type_mismatch_v1 | E-08 (line 39) | ○ |
| C-61 | __ubsan_handle_add_overflow | E-08 (line 58) | ○ |
| C-62 | __ubsan_handle_sub_overflow | E-08 (line 61) | ○ |
| C-63 | __ubsan_handle_mul_overflow | E-08 (line 64) | ○ |
| C-64 | __ubsan_handle_divrem_overflow | E-08 (line 70-71) | ○ |
| C-65 | __ubsan_handle_shift_out_of_bounds | E-08 (line 81-82) | ○ |
| C-66 | __ubsan_handle_out_of_bounds | E-08 (line 91) | ○ |
| C-67 | __ubsan_handle_builtin_unreachable | E-08 (line 101) | ○ |
| C-68 | __ubsan_handle_nonnull_return_v1 | E-08 (line 190) | ○ |
| C-69 | __ubsan_handle_nonnull_arg | E-08 (line 201) | ○ |
| C-70 | __ubsan_handle_pointer_overflow | E-08 (line 208-209) | ○ |
| C-71 | __divdi3 - 正常 | E-09 (divdi3.c存在確認) | ○ |
| C-72 | __divdi3 - ゼロ除算 | **根拠なし** | △ |
| C-73 | __moddi3 | E-09 (moddi3.c存在確認) | ○ |
| C-74 | __udivdi3 | E-09 (udivdi3.c存在確認) | ○ |
| C-75 | __umoddi3 | E-09 (umoddi3.c存在確認) | ○ |
| C-76 | __muldi3 | E-09 (muldi3.c存在確認) | ○ |
| C-77 | __clzdi2 | E-09 (clzdi2.c存在確認) | ○ |
| C-78 | __ctzdi2 | E-09 (ctzdi2.c存在確認) | ○ |
| C-79 | __popcountdi2 | E-09 (popcountdi2.c存在確認) | ○ |
| C-80 | __ashldi3 | E-09 (ashldi3.c存在確認) | ○ |
| C-81 | __ashrdi3 | E-09 (ashrdi3.c存在確認) | ○ |
| C-82 | __lshrdi3 | E-09 (lshrdi3.c存在確認) | ○ |
| C-83 | __floatdidf | E-09 (floatdidf.c存在確認) | ○ |
| C-84 | __floatdisf | E-09 (floatdisf.c存在確認) | ○ |
| C-85 | __fixdfdi | E-09 (fixdfdi.c存在確認) | ○ |
| C-86 | __fixsfdi | E-09 (fixsfdi.c存在確認) | ○ |
| C-87 | __adddf3 | E-09 (adddf3.c存在確認) | ○ |
| C-88 | __subdf3 | E-09 (subdf3.c存在確認) | ○ |
| C-89 | __muldf3 | E-09 (muldf3.c存在確認) | ○ |
| C-90 | __divdf3 | E-09 (divdf3.c存在確認) | ○ |
| C-91 | AllocatorMayReturnNull | E-02 (line 36) | ○ |
| C-92 | SetAllocatorMayReturnNull | E-02 (line 37) | ○ |
| C-93 | IsAllocatorOutOfMemory | E-02 (line 41) | ○ |
| C-94 | Rand | E-02 (line 50-51) | △ |
| C-95 | RandomShuffle | E-02 (line 57-63) | △ |
| C-96 | GetPageSize | E-01 (line 68) | ○ |
| C-97 | GetMaxVirtualAddress | E-01 (line 78) | ○ |
| C-98 | ReadFileToBuffer - 成功 | E-01 (line 792-794) | ○ |
| C-99 | ReadFileToBuffer - 失敗 | E-01 (line 792-794) | ○ |
| C-100 | TemplateMatch | E-01 (line 327) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-72 (__divdi3 ゼロ除算)**：ゼロ除算時の挙動はプラットフォーム・コンパイラに依存し、compiler-rtの仕様として明確に定義されていない可能性がある
  - 候補：ABIドキュメント / プラットフォーム固有の仕様 / ハードウェア依存
- **C-94-95 (Rand/RandomShuffle)**：テストの重要度が低いため、実際の使用頻度の確認が必要
  - 候補：内部ユーティリティのため、単体テストよりも統合テストが適切な可能性
- **C-100 (TemplateMatch)**：抑制ファイルのパターンマッチング用途であり、実際のテストシナリオの確認が必要
  - 候補：sanitizer_common/sanitizer_suppressions.cpp / 抑制ファイル仕様

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク**: sanitizer_common基本機能（C-01〜C-20）- 十分なヘッダ定義あり
- **0: 低リスク**: ASan機能（C-21〜C-29）- インターフェース定義が明確
- **0: 低リスク**: TSan機能（C-30〜C-42）- ヘッダ定義が詳細
- **0: 低リスク**: MSan機能（C-43〜C-50）- メモリマッピング定義が明確
- **0: 低リスク**: LSan機能（C-51〜C-59）- 公開インターフェースが明確
- **0: 低リスク**: UBSan機能（C-60〜C-70）- ハンドラ定義が明確
- **1: 中リスク**: builtins関数（C-71〜C-90）- 実装ファイルの詳細確認が必要
- **1: 中リスク**: ゼロ除算・異常系（C-72）- プラットフォーム依存
- **0: 低リスク**: アロケータ設定（C-91〜C-93）- 明確な関数シグネチャ

## 6) レビュアーチェックリスト（最小）
- [ ] ASan関連テストケース（C-21〜C-29）が実際のuse-after-free/buffer-overflowシナリオをカバーしているか確認
- [ ] TSan関連テストケース（C-30〜C-42）がデータレースの典型的パターンをカバーしているか確認
- [ ] MSan関連テストケース（C-43〜C-50）がシャドウメモリ操作を正しくテストしているか確認
- [ ] LSan関連テストケース（C-51〜C-59）がメモリリークの検出パターンを網羅しているか確認
- [ ] UBSan関連テストケース（C-60〜C-70）が各種未定義動作を網羅しているか確認
- [ ] builtins関数のテストケース（C-71〜C-90）がプラットフォーム固有の動作を考慮しているか確認
- [ ] △マークの項目（C-72, C-94-95, C-100）について追加調査が必要か判断
