---
generated_at: 2026-02-01 22:30:00
metrics:
  claims_total: 131
  claims_with_evidence: 127
  claims_without_evidence: 4
confidence_derived: 0.97
---

# 根拠レポート：flang-rt.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：127 / 131、根拠なし：4
- 優先レビュー（高）
  1. **UT-FRT-009**: メモリ不足時の挙動はプラットフォーム依存であり、実機テストが必要
  2. **UT-FRT-076/077/078**: IEEE浮動小数点関連の挙動はコンパイラ/プラットフォーム依存
  3. **UT-FRT-095/096**: RANDOM_INITの時刻ベースシード生成はOSに依存

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `flang-rt/lib/runtime/descriptor.cpp` - Descriptorクラスの実装
- E-02: `flang-rt/lib/runtime/allocatable.cpp` - Allocatable関連のランタイム関数
- E-03: `flang-rt/lib/runtime/memory.cpp` - メモリ管理関数
- E-04: `flang-rt/lib/runtime/character.cpp` - 文字列操作関数
- E-05: `flang-rt/lib/runtime/numeric.cpp` - 数値演算関数
- E-06: `flang-rt/lib/runtime/pointer.cpp` - ポインタ操作関数
- E-07: `flang-rt/lib/runtime/random.cpp` - 乱数生成関数
- E-08: `flang-rt/lib/runtime/matmul.cpp` - 行列乗算関数
- E-09: `flang-rt/lib/runtime/reduction.cpp` - リダクション関数（ALL, ANY, COUNT等）
- E-10: `flang-rt/lib/runtime/transformational.cpp` - 変形関数（CSHIFT, EOSHIFT, PACK等）
- E-11: `flang-rt/include/flang-rt/runtime/descriptor.h` - Descriptorクラスのヘッダ
- E-12: `flang-rt/include/flang-rt/runtime/stat.h` - ステータスコード定義
- E-13: `flang-rt/include/flang-rt/runtime/terminator.h` - Terminatorクラス

## 3) Claims と根拠の対応（レビューの主戦場）

### Descriptor関連 (UT-FRT-001〜020)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Descriptor::Establish初期化 | E-01 (L34-64) | ○ |
| C-02 | TypeCategory指定の初期化 | E-01 (L73-78) | ○ |
| C-03 | 文字型の初期化 | E-01 (L80-86) | ○ |
| C-04 | 派生型の初期化 | E-01 (L88-105) | ○ |
| C-05 | 無効TypeCodeエラー | E-01 (L40-43) | ○ |
| C-06 | Allocate成功 | E-01 (L167-187) | ○ |
| C-07 | ゼロサイズ配列 | E-01 (L177-179) | ○ |
| C-08 | 負の文字長 | E-01 (L168-173) | ○ |
| C-09 | メモリ不足エラー | E-03, E-01 (L180-181) | △ |
| C-10 | Destroy成功 | E-01 (L200-214) | ○ |
| C-11 | ポインタ属性スキップ | E-01 (L202-203) | ○ |
| C-12 | SetByteStrides | E-01 (L189-198) | ○ |
| C-13 | Elements計算 | E-01 (L163-165) | ○ |
| C-14 | SizeInBytes計算 | E-01 (L155-161) | ○ |
| C-15 | DecrementSubscripts | E-01 (L216-227) | ○ |
| C-16 | DecrementSubscripts境界 | E-01 (L216-227) | ○ |
| C-17 | ZeroBasedElementNumber | E-01 (L229-240) | ○ |
| C-18 | EstablishPointerSection | E-01 (L242-270) | ○ |
| C-19 | ApplyMold | E-01 (L272-289) | ○ |
| C-20 | Create | E-01 (L116-153) | ○ |

### Allocatable関連 (UT-FRT-021〜035)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-21 | AllocatableInitIntrinsic | E-02 (L23-29) | ○ |
| C-22 | AllocatableInitCharacter | E-02 (L31-36) | ○ |
| C-23 | AllocatableInitDerived | E-02 (L38-43) | ○ |
| C-24 | AllocatableAllocate成功 | E-02 (L136-159) | ○ |
| C-25 | 二重割り当てエラー | E-02 (L142-143) | ○ |
| C-26 | 非Allocatableエラー | E-02 (L140-141) | ○ |
| C-27 | AllocatableAllocateSource | E-02 (L161-191) | ○ |
| C-28 | ランク不一致 | E-02 (L168-171) | ○ |
| C-29 | AllocatableDeallocate | E-02 (L193-206) | ○ |
| C-30 | 未割り当て解放エラー | E-02 (L198-199) | ○ |
| C-31 | AllocatableSetBounds | E-02 (L111-118) | ○ |
| C-32 | 割り当て済み時動作 | E-02 (L114) | ○ |
| C-33 | MoveAlloc成功 | E-02 (L66-109) | ○ |
| C-34 | MoveAllocでto破棄 | E-02 (L78-84) | ○ |
| C-35 | 同一オブジェクトエラー | E-02 (L72-76) | ○ |

### Memory関連 (UT-FRT-036〜039)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-36 | AllocateMemoryOrCrash | E-03 (L18-28) | ○ |
| C-37 | 0バイト割り当て | E-03 (L22-27) | ○ |
| C-38 | ReallocateMemoryOrCrash | E-03 (L30-41) | ○ |
| C-39 | FreeMemory | E-03 (L43) | ○ |

### Character関連 (UT-FRT-040〜060)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-40 | CharacterScalarCompare等しい | E-04 (L43-74) | ○ |
| C-41 | CharacterScalarCompare小 | E-04 (L43-74) | ○ |
| C-42 | CharacterScalarCompare大 | E-04 (L43-74) | ○ |
| C-43 | ブランクパディング | E-04 (L24-38, L70-73) | ○ |
| C-44 | char16_t比較 | E-04 (L78-79) | ○ |
| C-45 | char32_t比較 | E-04 (L80-81) | ○ |
| C-46 | Index発見 | E-04 (L272-348) | ○ |
| C-47 | Index未発見 | E-04 (L275-277) | ○ |
| C-48 | Index後方検索 | E-04 (L281-295) | ○ |
| C-49 | Index空文字列 | E-04 (L278-279) | ○ |
| C-50 | LenTrim | E-04 (L207-212) | ○ |
| C-51 | LenTrim全空白 | E-04 (L207-212) | ○ |
| C-52 | Adjustl | E-04 (L145-155) | ○ |
| C-53 | Adjustr | E-04 (L135-144) | ○ |
| C-54 | Trim | E-04 (L846-873) | ○ |
| C-55 | Repeat | E-04 (L827-844) | ○ |
| C-56 | Repeat負 | E-04 (L830-833) | ○ |
| C-57 | Scan | E-04 (L357-376, L791-802) | ○ |
| C-58 | Verify | E-04 (L357-376, L875-886) | ○ |
| C-59 | CharacterMax | E-04 (L493-551, L911-914) | ○ |
| C-60 | CharacterMin | E-04 (L493-551, L916-919) | ○ |

### Numeric関連 (UT-FRT-061〜081)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-61 | Nint正数 | E-05 (L54-61) | ○ |
| C-62 | Nint負数 | E-05 (L54-61) | ○ |
| C-63 | Ceiling | E-05 (L65-67) | ○ |
| C-64 | Floor | E-05 (L68-71) | ○ |
| C-65 | Mod | E-05 (L74-85) | ○ |
| C-66 | Modゼロ除算 | E-05 (L76-79) | ○ |
| C-67 | Modulo | E-05 (L81-84) | ○ |
| C-68 | Scale | E-05 (L88-95) | ○ |
| C-69 | Nearest正 | E-05 (L191-197) | ○ |
| C-70 | Nearest負 | E-05 (L191-197) | ○ |
| C-71 | SelectedIntKind | E-05 (L98-116) | ○ |
| C-72 | SelectedIntKind範囲外 | E-05 (L115) | ○ |
| C-73 | SelectedRealKind | E-05 (L135-187) | ○ |
| C-74 | SelectedCharKind ASCII | E-05 (L785-801) | ○ |
| C-75 | SelectedCharKind UCS-4 | E-05 (L796-797) | ○ |
| C-76 | IsNaN | E-05 (L516-530) | △ |
| C-77 | IsFinite | E-05 (L500-514) | △ |
| C-78 | IsFinite無限大 | E-05 (L500-514) | △ |
| C-79 | FPowI | E-05 (L200-230) | ○ |
| C-80 | FPowI exp=0 | E-05 (L202-203) | ○ |
| C-81 | FPowI負指数 | E-05 (L204-210, L226-228) | ○ |

### Pointer関連 (UT-FRT-082〜094)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-82 | PointerNullifyIntrinsic | E-06 (L23-29) | ○ |
| C-83 | PointerNullifyCharacter | E-06 (L31-36) | ○ |
| C-84 | PointerNullifyDerived | E-06 (L38-42) | ○ |
| C-85 | PointerAssociateScalar | E-06 (L65-67) | ○ |
| C-86 | PointerAssociate | E-06 (L69-72) | ○ |
| C-87 | PointerAllocate成功 | E-06 (L159-189) | ○ |
| C-88 | PointerAllocate非ポインタ | E-06 (L163-164) | ○ |
| C-89 | PointerDeallocate成功 | E-06 (L224-241) | ○ |
| C-90 | PointerDeallocate未割り当て | E-06 (L230-231) | ○ |
| C-91 | PointerIsAssociated true | E-06 (L263-265) | ○ |
| C-92 | PointerIsAssociated false | E-06 (L263-265) | ○ |
| C-93 | PointerIsAssociatedWith同一 | E-06 (L267-294) | ○ |
| C-94 | PointerIsAssociatedWith異なる | E-06 (L267-294) | ○ |

### Random関連 (UT-FRT-095〜101)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | RandomInit repeatable | E-07 (L35-51) | △ |
| C-96 | RandomInit非再現 | E-07 (L42-48) | ○ |
| C-97 | RandomNumber REAL(4) | E-07 (L53-109) | ○ |
| C-98 | RandomNumber REAL(8) | E-07 (L68-69) | ○ |
| C-99 | RandomSeedSize | E-07 (L111-135) | ○ |
| C-100 | RandomSeedPut | E-07 (L137-167) | ○ |
| C-101 | RandomSeedGet | E-07 (L177-207) | ○ |

### Matmul関連 (UT-FRT-102〜106)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-102 | Matmul M*M | E-08 (L59-108) | ○ |
| C-103 | Matmul M*V | E-08 (L135-183) | ○ |
| C-104 | Matmul V*M | E-08 (L185-235) | ○ |
| C-105 | Matmul形状エラー | E-08 (L271-291) | ○ |
| C-106 | Matmul LOGICAL | E-08 (L44-47) | ○ |

### Reduction関連 (UT-FRT-107〜115)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-107 | IAll | E-09 (L25-43, L86-117) | ○ |
| C-108 | IAny | E-09 (L45-63, L130-172) | ○ |
| C-109 | IParity | E-09 (L65-83, L174-216) | ○ |
| C-110 | All全true | E-09 (L223-249, L361-370) | ○ |
| C-111 | All含false | E-09 (L235-238) | ○ |
| C-112 | Any含true | E-09 (L372-381) | ○ |
| C-113 | Any全false | E-09 (L232) | ○ |
| C-114 | Count | E-09 (L317-337, L383-394) | ○ |
| C-115 | Parity | E-09 (L233-234, L396-405) | ○ |

### Transformational関連 (UT-FRT-116〜131)
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-116 | Cshift | E-10 (L522-564) | ○ |
| C-117 | Cshift負シフト | E-10 (L552-555) | ○ |
| C-118 | Eoshift | E-10 (L587-664) | ○ |
| C-119 | Eoshift BOUNDARY | E-10 (L654-656) | ○ |
| C-120 | Pack | E-10 (L699-769) | ○ |
| C-121 | Pack VECTOR | E-10 (L762-768) | ○ |
| C-122 | Unpack | E-10 (L951-995) | ○ |
| C-123 | Reshape | E-10 (L773-882) | ○ |
| C-124 | Reshape PAD | E-10 (L872-880) | ○ |
| C-125 | Reshape ORDER | E-10 (L824-854) | ○ |
| C-126 | Spread | E-10 (L898-929) | ○ |
| C-127 | Transpose | E-10 (L932-948) | ○ |
| C-128 | BesselJn | E-10 (L167-218) | ○ |
| C-129 | BesselJn x=0 | E-10 (L221-246) | ○ |
| C-130 | BesselYn | E-10 (L248-299) | ○ |
| C-131 | BesselYn x=0 | E-10 (L301-325) | ○ |

## 4) 不足情報（Unknown / Missing）

以下の項目について、ソースコードからの根拠確認が困難または追加検証が必要です：

1. **メモリ不足時の挙動 (C-09)**
   - 理由：`std::malloc`の失敗条件はOS/プラットフォームに依存
   - 候補：実機テスト / モックによるテスト / プラットフォーム固有ドキュメント

2. **IEEE浮動小数点判定 (C-76, C-77, C-78)**
   - 理由：`std::isnan`, `std::isfinite`の挙動はC++標準に準拠するがプラットフォーム実装依存
   - 候補：IEEE 754規格 / コンパイラドキュメント / 実機テスト

3. **RANDOM_INIT時刻ベースシード (C-95)**
   - 理由：`CLOCK_REALTIME`の存在はOSに依存、フォールバック実装あり
   - 候補：POSIXドキュメント / プラットフォーム固有ドキュメント

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 項目 | 説明 |
|---|---|---|
| 1 | メモリ管理テスト | 実際のメモリ不足状況の再現が困難 |
| 0 | 文字列操作テスト | ソースコードから明確に動作が追跡可能 |
| 0 | 数値演算テスト | 標準的な数学関数の呼び出しで根拠が明確 |
| 1 | IEEE浮動小数点テスト | プラットフォーム依存の可能性あり |
| 0 | 配列操作テスト | アルゴリズムがソースコードに明示 |
| 1 | 乱数テスト | 非決定的な動作の検証が必要 |

## 6) レビュアーチェックリスト（最小）

- [ ] Descriptor関連のテストケース（UT-FRT-001〜020）が網羅的か確認
- [ ] Allocatable/Pointer操作の正常系・異常系が適切にカバーされているか確認
- [ ] 文字列操作関数（INDEX, LEN_TRIM, SCAN等）の境界値テストが十分か確認
- [ ] 数値演算関数（MOD, MODULO, NINT等）のエッジケースが含まれているか確認
- [ ] 配列変形関数（RESHAPE, CSHIFT, EOSHIFT等）の多次元配列対応を確認
- [ ] MATMULの型組み合わせ（INTEGER, REAL, COMPLEX, LOGICAL）が網羅されているか確認
- [ ] リダクション関数（ALL, ANY, COUNT）のMASK引数パターンが含まれているか確認
- [ ] IEEE浮動小数点関連テストのプラットフォーム依存性を確認
- [ ] ランタイムエラー（Crash）のテストが実行可能か確認
- [ ] テストID命名規則（UT-FRT-XXX）が一貫しているか確認
