---
generated_at: 2026-02-01 18:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 115
  claims_without_evidence: 5
confidence_derived: 0.96
---

# 根拠レポート：flang.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：115 / 120、根拠なし：5
- 優先レビュー（高）
  1. **UT-FLG-064 GetBuiltinModule**：モジュールファイルの存在確認が必要
  2. **UT-FLG-067/068 OpenACC/OpenMP チェック**：ディレクティブ固有のテスト条件の詳細確認が必要
  3. **UT-FLG-119/120 gatherComponentNonDefaultLowerBounds**：内部ヘルパー関数のためAPI安定性の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `flang/lib/Frontend/CompilerInstance.cpp`
- E-02: `flang/lib/Frontend/FrontendAction.cpp`
- E-03: `flang/lib/Frontend/CompilerInvocation.cpp`
- E-04: `flang/lib/Parser/parsing.cpp`
- E-05: `flang/lib/Parser/source.cpp`
- E-06: `flang/lib/Semantics/semantics.cpp`
- E-07: `flang/lib/Evaluate/fold.cpp`
- E-08: `flang/lib/Evaluate/expression.cpp`
- E-09: `flang/lib/Evaluate/intrinsics.cpp`
- E-10: `flang/lib/Optimizer/Support/InternalNames.cpp`
- E-11: `flang/lib/Optimizer/Dialect/FIRType.cpp`
- E-12: `flang/lib/Lower/Bridge.cpp`
- E-13: `flang/include/flang/Frontend/CompilerInstance.h`
- E-14: `flang/include/flang/Frontend/FrontendAction.h`
- E-15: `flang/include/flang/Semantics/semantics.h`
- E-16: `flang/include/flang/Optimizer/Support/InternalNames.h`

## 3) Claims と根拠の対応（レビューの主戦場）

### Frontend（UT-FLG-001〜UT-FLG-023）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CompilerInstanceコンストラクタの初期化動作 | E-01 (L36-44) | ○ |
| C-02 | setInvocationの動作 | E-01 (L50-53) | ○ |
| C-03 | setSemaOutputStreamの動作 | E-01 (L55-63) | ○ |
| C-04 | createDefaultOutputFileの正常動作 | E-01 (L92-117) | ○ |
| C-05 | createDefaultOutputFileのエラー処理 | E-01 (L112-116) | ○ |
| C-06 | clearOutputFilesの動作 | E-01 (L144-150) | ○ |
| C-07 | executeActionの動作 | E-01 (L152-225) | ○ |
| C-08 | createDiagnosticsの動作 | E-01 (L227-247) | ○ |
| C-09 | getTargetFeatures AMDGPUの動作 | E-01 (L251-280, L321-340) | ○ |
| C-10 | getTargetFeatures NVPTXの動作 | E-01 (L285-319, L321-340) | ○ |
| C-11 | setUpTargetMachineの正常動作 | E-01 (L342-382) | ○ |
| C-12 | setUpTargetMachineのエラー処理 | E-01 (L351-355) | ○ |
| C-13 | beginSourceFileの正常動作 | E-02 (L39-115) | ○ |
| C-14 | beginSourceFile ファイル不存在エラー | E-02 (L46-64) | ○ |
| C-15 | beginSourceFile 非正規ファイルエラー | E-02 (L46-64) | ○ |
| C-16 | executeの動作 | E-02 (L121-125) | ○ |
| C-17 | endSourceFileの動作 | E-02 (L127-136) | ○ |
| C-18 | runPrescanの動作 | E-02 (L138-159) | ○ |
| C-19 | runParseの正常動作 | E-02 (L161-181) | ○ |
| C-20 | runParseのエラー処理 | E-02 (L167-169) | ○ |
| C-21 | runSemanticChecksの正常動作 | E-02 (L183-212) | ○ |
| C-22 | runSemanticChecksのエラー処理 | E-02 (L204-206) | ○ |
| C-23 | generateRtTypeTablesの動作 | E-02 (L214-226) | ○ |

### Parser（UT-FLG-024〜UT-FLG-046）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | Prescanファイル読み込み | E-04 (L23-119) | ○ |
| C-25 | Prescan標準入力対応 | E-04 (L36-37) | ○ |
| C-26 | Prescanエラーメッセージ | E-04 (L45-48) | ○ |
| C-27 | Prescanモジュールファイル検索パス | E-04 (L27-31, L52-61) | ○ |
| C-28 | Prescanプリプロセッサマクロ | E-04 (L63-72) | ○ |
| C-29 | Prescan OpenACCセンチネル | E-04 (L85-89) | ○ |
| C-30 | Prescan OpenMPセンチネル | E-04 (L90-94) | ○ |
| C-31 | Parse解析木生成 | E-04 (L282-297) | ○ |
| C-32 | Parse完全性チェック | E-04 (L294) | ○ |
| C-33 | EmitPreprocessedSource出力 | E-04 (L125-263) | ○ |
| C-34 | EmitPreprocessedSource行折り返し | E-04 (L210-231) | ○ |
| C-35 | SourceFile::Open正常動作 | E-05 (L128-141) | ○ |
| C-36 | SourceFile::Openエラー処理 | E-05 (L133-137) | ○ |
| C-37 | ReadStandardInput | E-05 (L143-158) | ○ |
| C-38 | RecordLineStarts | E-05 (L27-42) | ○ |
| C-39 | IdentifyPayload UTF-8 BOM検出 | E-05 (L46-53) | ○ |
| C-40 | GetSourcePosition | E-05 (L184-201) | ○ |
| C-41 | GetSourcePosition境界値 | E-05 (L185) | ○ |
| C-42 | RemoveCarriageReturns CR-LF変換 | E-05 (L96-126) | ○ |
| C-43 | RemoveCarriageReturns単独CR処理 | E-05 (L114-118) | ○ |
| C-44 | LocateSourceFile絶対パス | E-05 (L63-65) | ○ |
| C-45 | LocateSourceFile検索パス | E-05 (L66-75) | ○ |
| C-46 | LocateSourceFileファイル未発見 | E-05 (L75) | ○ |

### Semantics（UT-FLG-047〜UT-FLG-070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-47 | SemanticsContextコンストラクタ | E-06 (L380-391) | ○ |
| C-48 | GetDefaultKind | E-06 (L395-397) | ○ |
| C-49 | MakeNumericType | E-06 (L399-405) | ○ |
| C-50 | MakeLogicalType | E-06 (L406-411) | ○ |
| C-51 | AnyFatalError（エラーなし） | E-06 (L413-415) | ○ |
| C-52 | AnyFatalError（エラーあり） | E-06 (L413-415) | ○ |
| C-53 | HasError検出 | E-06 (L416-424) | ○ |
| C-54 | SetError | E-06 (L425-430) | ○ |
| C-55 | FindScope | E-06 (L462-474) | ○ |
| C-56 | UpdateScopeIndex | E-06 (L476-490) | ○ |
| C-57 | IsInModuleFile | E-06 (L501-509) | ○ |
| C-58 | ActivateIndexVar | E-06 (L559-566) | ○ |
| C-59 | DeactivateIndexVar | E-06 (L568-575) | ○ |
| C-60 | CheckIndexVarRedefine | E-06 (L516-529, L541-545) | ○ |
| C-61 | GetTempName | E-06 (L591-601) | ○ |
| C-62 | IsTempName（一時名） | E-06 (L603-605) | ○ |
| C-63 | IsTempName（通常名） | E-06 (L603-605) | ○ |
| C-64 | GetBuiltinModule | E-06 (L607-610) | △ |
| C-65 | UseFortranBuiltinsModule | E-06 (L612-619) | ○ |
| C-66 | Semantics::Perform | E-06 (L653-695) | ○ |
| C-67 | OpenACCチェック実行 | E-06 (L253-255) | △ |
| C-68 | OpenMPチェック実行 | E-06 (L256-258) | △ |
| C-69 | EmitMessages | E-06 (L697-704) | ○ |
| C-70 | DumpSymbols | E-06 (L706-708, L714, L733-789) | ○ |

### Evaluate（UT-FLG-071〜UT-FLG-090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | Fold TypeAndShape | E-07 (L17-21) | ○ |
| C-72 | GetConstantSubscript | E-07 (L23-66) | ○ |
| C-73 | GetConstantSubscriptトリプレット | E-07 (L37-63) | ○ |
| C-74 | GetConstantSubscript空トリプレット | E-07 (L50-57) | ○ |
| C-75 | FoldOperation StructureConstructor | E-07 (L68-120) | ○ |
| C-76 | StructureConstructor NullPointer処理 | E-07 (L75-84) | ○ |
| C-77 | FoldOperation Component | E-07 (L122-125) | ○ |
| C-78 | FoldOperation ArrayRef | E-07 (L156-162) | ○ |
| C-79 | FoldOperation CoarrayRef | E-07 (L164-178) | ○ |
| C-80 | FoldOperation Substring | E-07 (L191-201) | ○ |
| C-81 | FoldTransfer | E-07 (L224-299) | ○ |
| C-82 | FoldTransfer SIZE引数 | E-07 (L263-269) | ○ |
| C-83 | FoldTransfer BOZ警告 | E-07 (L291-296) | ○ |
| C-84 | ExpressionBase::GetType | E-08 (L88-102) | ○ |
| C-85 | ExpressionBase::Rank | E-08 (L104-114) | ○ |
| C-86 | ExpressionBase::Corank | E-08 (L116-126) | ○ |
| C-87 | Expr<SomeCharacter>::LEN | E-08 (L368-370) | ○ |
| C-88 | StructureConstructor::Find | E-08 (L311-338) | ○ |
| C-89 | StructureConstructor::Find親コンポーネント | E-08 (L318-336) | ○ |
| C-90 | StructureConstructor::Add | E-08 (L340-344) | ○ |

### Optimizer/Lower（UT-FLG-091〜UT-FLG-120）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | doCommonBlock | E-10 (L107-109) | ○ |
| C-92 | doConstant | E-10 (L111-119) | ○ |
| C-93 | doProcedure | E-10 (L177-185) | ○ |
| C-94 | doType | E-10 (L187-196) | ○ |
| C-95 | doVariable | E-10 (L220-228) | ○ |
| C-96 | doKind正の値 | E-10 (L93-98) | ○ |
| C-97 | doKind負の値 | E-10 (L95-97) | ○ |
| C-98 | deconstruct | E-10 (L246-326) | ○ |
| C-99 | deconstruct COMMONブロック | E-10 (L262-264) | ○ |
| C-100 | deconstruct NOT_UNIQUED | E-10 (L325) | ○ |
| C-101 | isExternalFacingUniquedName（外部） | E-10 (L328-335) | ○ |
| C-102 | isExternalFacingUniquedName（内部） | E-10 (L333-334) | ○ |
| C-103 | needExternalNameMangling | E-10 (L337-341) | ○ |
| C-104 | belongsToModule | E-10 (L343-348) | ○ |
| C-105 | getTypeDescriptorName | E-10 (L379-383) | ○ |
| C-106 | replaceSpecialSymbols | E-10 (L411-413) | ○ |
| C-107 | dropTypeConversionMarkers | E-10 (L404-408) | ○ |
| C-108 | RecordType作成 | E-11 (L149-198) | ○ |
| C-109 | RecordType LENパラメータ | E-11 (L166-169) | ○ |
| C-110 | RecordType フィールドリスト | E-11 (L171-172) | ○ |
| C-111 | RecordType重複フィールド | E-11 (L114-124) | ○ |
| C-112 | RecordType無効フィールド型 | E-11 (L109-113) | ○ |
| C-113 | IncrementLoopInfo初期化 | E-12 (L96-146) | ○ |
| C-114 | IncrementLoopInfo::isStructured（構造化） | E-12 (L109) | ○ |
| C-115 | IncrementLoopInfo::isStructured（非構造化） | E-12 (L109) | ○ |
| C-116 | hasLocalitySpecs（あり） | E-12 (L116-119) | ○ |
| C-117 | hasLocalitySpecs（なし） | E-12 (L116-119) | ○ |
| C-118 | ConstructContext初期化 | E-12 (L151-159) | ○ |
| C-119 | gatherComponentNonDefaultLowerBounds（非デフォルト） | E-12 (L163-191) | △ |
| C-120 | gatherComponentNonDefaultLowerBounds（デフォルト） | E-12 (L184-188) | △ |

## 4) 不足情報（Unknown / Missing）
- **C-64**: GetBuiltinModuleの動作確認にはモジュールファイル（.mod）の存在が前提。ビルド環境によっては利用不可。
  - 候補：flangビルド時に生成される `__fortran_builtins.mod` / テスト用モックモジュール
- **C-67/C-68**: OpenACC/OpenMPのチェッカー動作はディレクティブ固有の詳細な仕様に依存。
  - 候補：OpenACC/OpenMP仕様書 / 既存のLitテスト
- **C-119/C-120**: gatherComponentNonDefaultLowerBoundsは内部ヘルパー関数であり、外部APIではない。
  - 候補：内部実装のため変更可能性あり / 統合テストでカバー推奨

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケース（115件）はソースコードから直接的に導出可能
- **1 (中リスク)**: OpenACC/OpenMPのディレクティブ固有テスト（2件）は仕様への依存度が高い
- **1 (中リスク)**: GetBuiltinModuleはビルド環境に依存する（1件）
- **1 (中リスク)**: 内部ヘルパー関数のテストはAPI安定性に注意が必要（2件）

## 6) レビュアーチェックリスト（最小）
- [ ] Frontend関連テスト（UT-FLG-001〜023）：コンパイラインスタンスとフロントエンドアクションの基本フローが網羅されているか
- [ ] Parser関連テスト（UT-FLG-024〜046）：固定形式/自由形式のソース処理が考慮されているか
- [ ] Semantics関連テスト（UT-FLG-047〜070）：スコープ管理とエラー報告の網羅性
- [ ] Evaluate関連テスト（UT-FLG-071〜090）：定数畳み込みの境界条件が適切か
- [ ] Optimizer/Lower関連テスト（UT-FLG-091〜120）：名前マングリングの規則が正確か
- [ ] OpenACC/OpenMPテストケースの詳細条件を確認
- [ ] 内部ヘルパー関数のテストがAPIの安定性を考慮しているか確認
