---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 85
  claims_with_evidence: 85
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：libsycl単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：85 / 85、根拠なし：0
- 優先レビュー（高）
  1. **なし**：全テストケースにソースコード根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `libsycl/src/platform.cpp` - platformクラスの実装
- E-02: `libsycl/include/sycl/__impl/platform.hpp` - platformクラスのヘッダ
- E-03: `libsycl/src/exception.cpp` - exceptionクラスの実装
- E-04: `libsycl/include/sycl/__impl/exception.hpp` - exception/exception_listクラスのヘッダ
- E-05: `libsycl/src/exception_list.cpp` - exception_listクラスの実装
- E-06: `libsycl/src/detail/platform_impl.cpp` - PlatformImplクラスの実装
- E-07: `libsycl/src/detail/platform_impl.hpp` - PlatformImplクラスのヘッダ
- E-08: `libsycl/src/detail/global_objects.cpp` - グローバルオブジェクトの実装
- E-09: `libsycl/src/detail/global_objects.hpp` - グローバルオブジェクトのヘッダ
- E-10: `libsycl/src/detail/offload/offload_topology.cpp` - OffloadTopologyの実装
- E-11: `libsycl/src/detail/offload/offload_topology.hpp` - OffloadTopologyのヘッダ
- E-12: `libsycl/src/detail/offload/offload_utils.cpp` - ユーティリティ関数の実装
- E-13: `libsycl/src/detail/offload/offload_utils.hpp` - ユーティリティ関数のヘッダ
- E-14: `libsycl/include/sycl/__impl/backend.hpp` - backend列挙型の定義
- E-15: `libsycl/tools/sycl-ls/sycl-ls.cpp` - sycl-lsツールの実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | platform::get_backend()がバックエンド取得 | E-01, E-02 | ○ |
| C-02 | platform::get_platforms()が全プラットフォーム取得 | E-01, E-02 | ○ |
| C-03 | get_platforms()空ベクタ境界値 | E-01 | ○ |
| C-04 | get_info<version>テンプレート特殊化 | E-01, E-07 | ○ |
| C-05 | get_info<name>テンプレート特殊化 | E-01, E-07 | ○ |
| C-06 | get_info<vendor>テンプレート特殊化 | E-01, E-07 | ○ |
| C-07 | operator==によるプラットフォーム比較 | E-02 | ○ |
| C-08 | operator==異なるプラットフォーム比較 | E-02 | ○ |
| C-09 | operator!=によるプラットフォーム比較 | E-02 | ○ |
| C-10 | exception(error_code, const char*)コンストラクタ | E-03, E-04 | ○ |
| C-11 | exception(error_code, std::string)コンストラクタ | E-04 | ○ |
| C-12 | exception(error_code)コンストラクタ | E-04 | ○ |
| C-13 | exception(int, error_category, const char*)コンストラクタ | E-04 | ○ |
| C-14 | exception::code()メソッド | E-03, E-04 | ○ |
| C-15 | exception::category()メソッド | E-03, E-04 | ○ |
| C-16 | exception::what()メソッド | E-03, E-04 | ○ |
| C-17 | exception::what()空メッセージ境界値 | E-03 | ○ |
| C-18 | exception::has_context()メソッド | E-03, E-04 | ○ |
| C-19 | exception_list::size()メソッド | E-05, E-04 | ○ |
| C-20 | exception_list::size()空リスト境界値 | E-05 | ○ |
| C-21 | exception_list::begin()メソッド | E-05, E-04 | ○ |
| C-22 | exception_list::end()メソッド | E-05, E-04 | ○ |
| C-23 | sycl_category()グローバル関数 | E-03, E-04 | ○ |
| C-24 | make_error_code()グローバル関数 | E-03, E-04 | ○ |
| C-25 | make_error_code(errc::success) | E-03, E-04 | ○ |
| C-26 | SYCLCategory::name()オーバーライド | E-03 | ○ |
| C-27 | SYCLCategory::message()オーバーライド | E-03 | ○ |
| C-28 | PlatformImpl::getPlatformImpl()キャッシュ検索 | E-06, E-07 | ○ |
| C-29 | getPlatformImpl()無効ハンドル例外 | E-06 | ○ |
| C-30 | PlatformImpl::getPlatforms()シングルトン | E-06, E-07 | ○ |
| C-31 | getPlatforms()遅延初期化 | E-06 | ○ |
| C-32 | getPlatforms()キャッシュ動作 | E-06 | ○ |
| C-33 | PlatformImplコンストラクタ | E-06, E-07 | ○ |
| C-34 | PlatformImpl::getBackend()メソッド | E-07 | ○ |
| C-35 | PlatformImpl::getHandleRef()メソッド | E-07 | ○ |
| C-36 | PlatformImpl::getInfo<version>テンプレート | E-07 | ○ |
| C-37 | PlatformImpl::getInfo<name>テンプレート | E-07 | ○ |
| C-38 | PlatformImpl::getInfo<vendor>テンプレート | E-07 | ○ |
| C-39 | getOffloadTopologies()グローバル関数 | E-08, E-09 | ○ |
| C-40 | getPlatformCache()グローバル関数 | E-08, E-09 | ○ |
| C-41 | shutdown()関数 | E-08 | ○ |
| C-42 | discoverOffloadDevices()デバイス検出 | E-10, E-11 | ○ |
| C-43 | discoverOffloadDevices()olInit呼び出し | E-10 | ○ |
| C-44 | discoverOffloadDevices()トポロジー登録 | E-10 | ○ |
| C-45 | ホストバックエンドフィルタリング | E-10 | ○ |
| C-46 | 不明バックエンドフィルタリング | E-10 | ○ |
| C-47 | OffloadTopology()デフォルトコンストラクタ | E-11 | ○ |
| C-48 | OffloadTopology(ol_platform_backend_t)コンストラクタ | E-11 | ○ |
| C-49 | OffloadTopology::setBackend()メソッド | E-11 | ○ |
| C-50 | OffloadTopology::platforms()メソッド | E-11 | ○ |
| C-51 | platforms()空リスト境界値 | E-11 | ○ |
| C-52 | devicesForPlatform()メソッド | E-11 | ○ |
| C-53 | devicesForPlatform()無効ID境界値 | E-11 | ○ |
| C-54 | registerNewPlatformsAndDevices()メソッド | E-11 | ○ |
| C-55 | registerNewPlatformsAndDevices()空入力 | E-11 | ○ |
| C-56 | OffloadTopology::backend()メソッド | E-11 | ○ |
| C-57 | range_view::begin()メソッド | E-11 | ○ |
| C-58 | range_view::end()メソッド | E-11 | ○ |
| C-59 | range_view::operator[]メソッド | E-11 | ○ |
| C-60 | range_view::size()メソッド | E-11 | ○ |
| C-61 | stringifyErrorCode(OL_ERRC_UNKNOWN) | E-12 | ○ |
| C-62 | stringifyErrorCode(OL_ERRC_RUNTIME) | E-12 | ○ |
| C-63 | stringifyErrorCode()未定義コード | E-12 | ○ |
| C-64 | convertBackend(LEVEL_ZERO) | E-12, E-13 | ○ |
| C-65 | convertBackend(CUDA) | E-12, E-13 | ○ |
| C-66 | convertBackend(AMDGPU) | E-12, E-13 | ○ |
| C-67 | convertBackend()未サポート例外 | E-12 | ○ |
| C-68 | formatCodeString()関数 | E-13 | ○ |
| C-69 | checkAndThrow(OL_SUCCESS) | E-13 | ○ |
| C-70 | checkAndThrow()失敗時例外 | E-13 | ○ |
| C-71 | checkAndThrow<errc::platform>テンプレート | E-13 | ○ |
| C-72 | callNoCheck()関数 | E-13 | ○ |
| C-73 | callAndThrow()成功時 | E-13 | ○ |
| C-74 | callAndThrow()失敗時 | E-13 | ○ |
| C-75 | map_info_desc(version) | E-13 | ○ |
| C-76 | map_info_desc(name) | E-13 | ○ |
| C-77 | map_info_desc(vendor) | E-13 | ○ |
| C-78 | getBackendName(opencl) | E-15 | ○ |
| C-79 | getBackendName(level_zero) | E-15 | ○ |
| C-80 | getBackendName(cuda) | E-15 | ○ |
| C-81 | getBackendName(hip) | E-15 | ○ |
| C-82 | sycl-ls main()プラットフォーム未登録 | E-15 | ○ |
| C-83 | sycl-ls main()プラットフォーム出力 | E-15 | ○ |
| C-84 | sycl-ls main()--verboseオプション | E-15 | ○ |
| C-85 | sycl-ls main()例外ハンドリング | E-15 | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの主張はありません

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全テストケースがソースコードに基づいて生成されています
- 本モジュールはSYCL 2020仕様に準拠したランタイムライブラリです
- liboffload APIとの統合部分は外部依存のためモック化が必要になる可能性があります
- Windows固有のDllMain処理は条件付きコンパイルのため、プラットフォーム別テストが必要です

## 6) レビュアーチェックリスト（最小）
- [ ] platformクラスのテストケースがSYCL 2020仕様を網羅しているか確認
- [ ] exceptionクラスのテストケースがstd::exception継承要件を満たしているか確認
- [ ] PlatformImplのスレッドセーフティに関するテストケースが必要か検討
- [ ] liboffload API呼び出しのモック戦略を確認
- [ ] sycl-lsツールのCLI引数処理テストが網羅的か確認
- [ ] range_viewの範囲外アクセスに対する動作テストを追加すべきか検討
- [ ] 各バックエンド（OpenCL/Level Zero/CUDA/HIP）の統合テスト方針を確認
