---
generated_at: 2026-02-01 21:30:00
metrics:
  claims_total: 164
  claims_with_evidence: 152
  claims_without_evidence: 12
confidence_derived: 0.93
---

# 根拠レポート：lld.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：152 / 164、根拠なし：12
- 優先レビュー（高）
  1. **UT-LLD-072〜073**: Symbol::getVA/getSizeのアドレス計算ロジック - 実装詳細の確認が必要
  2. **UT-LLD-108〜110**: InputSection::writeTo/relocateのリロケーション適用 - 複雑な処理
  3. **UT-LLD-157〜158**: wasm::DefinedData::getVAのTLSアドレス計算 - Wasm固有仕様

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lld/include/lld/Common/ErrorHandler.h` - ErrorHandlerクラスの定義
- E-02: `lld/Common/ErrorHandler.cpp` - ErrorHandlerの実装
- E-03: `lld/include/lld/Common/CommonLinkerContext.h` - CommonLinkerContextの定義
- E-04: `lld/Common/CommonLinkerContext.cpp` - CommonLinkerContextの実装
- E-05: `lld/include/lld/Common/Memory.h` - メモリ管理（make, makeThreadLocal）の定義
- E-06: `lld/include/lld/Common/Strings.h` - 文字列ユーティリティの定義
- E-07: `lld/Common/Strings.cpp` - 文字列ユーティリティの実装
- E-08: `lld/include/lld/Common/Args.h` - 引数処理ユーティリティの定義
- E-09: `lld/Common/Args.cpp` - 引数処理ユーティリティの実装
- E-10: `lld/include/lld/Common/Timer.h` - タイマークラスの定義
- E-11: `lld/Common/Timer.cpp` - タイマークラスの実装
- E-12: `lld/ELF/Symbols.h` - ELFシンボルクラス階層の定義
- E-13: `lld/ELF/InputSection.h` - ELF入力セクションクラスの定義
- E-14: `lld/ELF/SymbolTable.h` - ELFシンボルテーブルの定義
- E-15: `lld/ELF/Relocations.h` - ELFリロケーション処理の定義
- E-16: `lld/ELF/ICF.cpp` - Identical Code Foldingの実装
- E-17: `lld/ELF/MarkLive.cpp` - GCマーク処理の実装
- E-18: `lld/COFF/Symbols.h` - COFFシンボルクラス階層の定義
- E-19: `lld/MachO/Symbols.h` - MachOシンボルクラス階層の定義
- E-20: `lld/wasm/Symbols.h` - Wasmシンボルクラス階層の定義

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-11 | ErrorHandler関連テストケース（error, fatal, warn, log, initialize, getLocation） | E-01, E-02 | ○ |
| C-12〜C-15 | check<T>テンプレート関数 | E-01 | ○ |
| C-16〜C-22 | CommonLinkerContextのライフサイクル管理 | E-03, E-04 | ○ |
| C-23〜C-24 | make/makeThreadLocalメモリ管理 | E-05 | ○ |
| C-25〜C-32 | SingleStringMatcher/StringMatcherパターンマッチング | E-06, E-07 | ○ |
| C-33〜C-39 | parseHex, isValidCIdentifier文字列ユーティリティ | E-06, E-07 | ○ |
| C-40〜C-50 | args名前空間の引数処理関数 | E-08, E-09 | ○ |
| C-51〜C-57 | Timer/ScopedTimer計測機能 | E-10, E-11 | ○ |
| C-58〜C-89 | lld::elf::Symbolクラス階層 | E-12 | ○ |
| C-90〜C-96 | lld::elf::SymbolTableシンボル管理 | E-14 | ○ |
| C-97〜C-114 | lld::elf::SectionBase/InputSectionBaseセクション管理 | E-13 | ○ |
| C-115〜C-119 | ELFリロケーション構造体・ユーティリティ | E-15 | ○ |
| C-120〜C-131 | lld::coff::Symbolクラス階層 | E-18 | ○ |
| C-132〜C-147 | lld::macho::Symbolクラス階層 | E-19 | ○ |
| C-148〜C-164 | lld::wasm::Symbolクラス階層 | E-20 | ○ |
| C-72 | Symbol::getVAのアドレス計算詳細 | **実装ファイル未確認** | △ |
| C-73 | Symbol::getSizeの実装詳細 | **実装ファイル未確認** | △ |
| C-108 | InputSection::writeToの詳細実装 | **実装ファイル未確認** | △ |
| C-109 | InputSection::relocateの詳細実装 | **実装ファイル未確認** | △ |
| C-110 | InputSection::replaceのICF実装 | E-16 | ○ |
| C-157 | wasm::DefinedData::getVAの詳細実装 | **実装ファイル未確認** | △ |
| C-158 | wasm::DefinedData::getVAのTLS処理 | **実装ファイル未確認** | △ |

## 4) 不足情報（Unknown / Missing）
- **実装ファイルの詳細確認が不足**
  - `lld/ELF/Symbols.cpp` - Symbol::getVA, getSizeの実装詳細
  - `lld/ELF/InputSection.cpp` - writeTo, relocateの実装詳細
  - `lld/wasm/Symbols.cpp` - DefinedData::getVAの実装詳細
  - 候補：実装ファイルの追加読み込み / 既存テストケースの参照 / LLVMドキュメント参照

- **アーキテクチャ固有の実装**
  - 各ターゲット（ELF/COFF/MachO/Wasm）のArch固有クラス（ARM64, X86_64等）のテストケースは含まれていない
  - 候補：`lld/ELF/Arch/*.cpp`, `lld/MachO/Arch/*.cpp`の追加解析

- **LTOおよび最適化パス**
  - LTO.cpp関連のテストケースが不足
  - 候補：`lld/ELF/LTO.cpp`, `lld/COFF/LTO.cpp`の解析

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: アドレス計算ロジック（getVA, getRVA）のテストケースは、ヘッダファイルのインターフェースから推測しており、実装詳細の検証が必要
- **1（中リスク）**: リロケーション適用（relocate, writeTo）は複雑な処理のため、境界条件の追加テストが必要な可能性
- **0（低リスク）**: ErrorHandler, CommonLinkerContext, 文字列ユーティリティは実装コードから直接確認済み
- **1（中リスク）**: Wasm固有の機能（TLS, タグ、テーブル）は仕様への準拠確認が推奨

## 6) レビュアーチェックリスト（最小）
- [ ] ErrorHandler関連テストケース（UT-LLD-001〜011）の入力値と期待結果が実装と一致しているか
- [ ] Symbol::getVA（UT-LLD-072）のアドレス計算ロジックが実装と一致しているか
- [ ] InputSection::writeTo/relocate（UT-LLD-108〜109）のリロケーション適用テストが網羅的か
- [ ] 各ターゲット（ELF/COFF/MachO/Wasm）固有のシンボル種別が正しく分類されているか
- [ ] 境界値テスト（エラー上限、空文字列、null入力）のカバレッジが十分か
- [ ] TLS関連のテストケース（UT-LLD-140, 158）がWasm仕様に準拠しているか
