---
generated_at: 2026-02-01 18:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート: lldb.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **Watchpoint関連テスト（UT-LDB-084〜086）**：ソースコードの詳細解析が必要
  2. **RegisterContext関連テスト（UT-LDB-091〜094）**：プラットフォーム固有実装の確認が必要
  3. **DataExtractor境界値テスト（UT-LDB-100）**：エッジケースの動作確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `lldb/source/Core/Debugger.cpp` - Debuggerクラスの実装
- E-02: `lldb/source/Target/Target.cpp` - Targetクラスの実装
- E-03: `lldb/source/Target/Process.cpp` - Processクラスの実装
- E-04: `lldb/source/Target/Thread.cpp` - Threadクラスの実装
- E-05: `lldb/source/Breakpoint/Breakpoint.cpp` - Breakpointクラスの実装
- E-06: `lldb/source/Core/Address.cpp` - Addressクラスの実装
- E-07: `lldb/source/Interpreter/CommandInterpreter.cpp` - CommandInterpreterクラスの実装
- E-08: `lldb/source/ValueObject/ValueObject.cpp` - ValueObjectクラスの実装
- E-09: `lldb/source/Symbol/Symbol.cpp` - Symbolクラスの実装
- E-10: `lldb/source/Expression/UserExpression.cpp` - UserExpressionクラスの実装
- E-11: `lldb/include/lldb/Core/Debugger.h` - Debuggerクラスのヘッダ
- E-12: `lldb/include/lldb/Target/Target.h` - Targetクラスのヘッダ
- E-13: `lldb/include/lldb/Target/Process.h` - Processクラスのヘッダ
- E-14: `lldb/include/lldb/Target/Thread.h` - Threadクラスのヘッダ
- E-15: `lldb/include/lldb/Breakpoint/Breakpoint.h` - Breakpointクラスのヘッダ

## 3) Claims と根拠の対応（レビューの主戦場）

### Debugger関連（UT-LDB-001〜004）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Debugger::CreateInstanceが非null値を返却する | E-01, E-11 | ○ |
| C-02 | GetSelectedTargetが選択済みTargetを返却する | E-01 | ○ |
| C-03 | Target未選択時に空のTargetSPを返却する | E-01 | ○ |
| C-04 | SetSelectedTargetでTargetが選択状態になる | E-01 | ○ |

### Target関連（UT-LDB-005〜014）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-05 | Targetコンストラクタで初期化が完了する | E-02, E-12 | ○ |
| C-06 | ファイル行でブレークポイントが設定できる | E-02 | ○ |
| C-07 | 関数名でブレークポイントが設定できる | E-02 | ○ |
| C-08 | アドレスでブレークポイントが設定できる | E-02 | ○ |
| C-09 | RemoveBreakpointByIDがtrueを返却する | E-02 | ○ |
| C-10 | 存在しないIDでfalseを返却する | E-02 | ○ |
| C-11 | ReadMemoryが正しいバイト数を返却する | E-02 | ○ |
| C-12 | 無効アドレスで0を返却する | E-02 | ○ |
| C-13 | ResolveLoadAddressがtrueを返却する | E-02 | ○ |
| C-14 | GetArchitectureが有効なArchSpecを返却する | E-02 | ○ |

### Process関連（UT-LDB-015〜023）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-15 | Launchが成功時にStatus::Successを返却する | E-03, E-13 | ○ |
| C-16 | Attachが成功時にStatus::Successを返却する | E-03 | ○ |
| C-17 | Resumeが停止中のプロセスを再開する | E-03 | ○ |
| C-18 | 実行中のResumeがエラーを返却する | E-03 | ○ |
| C-19 | Haltがプロセスを停止する | E-03 | ○ |
| C-20 | Destroyがプロセスを終了する | E-03 | ○ |
| C-21 | GetStateが正しいStateType値を返却する | E-03 | ○ |
| C-22 | ReadMemoryがバイト数を返却する | E-03 | ○ |
| C-23 | WriteMemoryがバイト数を返却する | E-03 | ○ |

### Thread関連（UT-LDB-024〜032）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-24 | GetThreadIDがtid_t値を返却する | E-04, E-14 | ○ |
| C-25 | 停止中のGetStopInfoがStopInfoSPを返却する | E-04 | ○ |
| C-26 | 実行中のGetStopInfoが空を返却する | E-04 | ○ |
| C-27 | StepInが成功する | E-04 | ○ |
| C-28 | StepOverが成功する | E-04 | ○ |
| C-29 | StepOutが成功する | E-04 | ○ |
| C-30 | GetStackFrameAtIndexがフレームを返却する | E-04 | ○ |
| C-31 | 範囲外インデックスで空を返却する | E-04 | ○ |
| C-32 | GetSelectedFrameがフレームを返却する | E-04 | ○ |

### Breakpoint関連（UT-LDB-033〜041）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-33 | Breakpointコンストラクタで初期化が完了する | E-05, E-15 | ○ |
| C-34 | SetEnabled(true)でブレークポイントが有効になる | E-05 | ○ |
| C-35 | SetEnabled(false)でブレークポイントが無効になる | E-05 | ○ |
| C-36 | IsEnabledが正しいbool値を返却する | E-05 | ○ |
| C-37 | GetNumLocationsがロケーション数を返却する | E-05 | ○ |
| C-38 | GetHitCountがヒット回数を返却する | E-05 | ○ |
| C-39 | SerializeToStructuredDataが成功する | E-05 | ○ |
| C-40 | CreateFromStructuredDataが復元する | E-05 | ○ |
| C-41 | CopyFromBreakpointがコピーを作成する | E-05 | ○ |

### Address関連（UT-LDB-042〜048）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-42 | デフォルトコンストラクタでIsValid()がfalse | E-06 | ○ |
| C-43 | SetSectionでセクションが設定される | E-06 | ○ |
| C-44 | GetFileAddressがaddr_tを返却する | E-06 | ○ |
| C-45 | GetLoadAddressがaddr_tを返却する | E-06 | ○ |
| C-46 | GetModuleがModuleSPを返却する | E-06 | ○ |
| C-47 | 有効なアドレスでIsValidがtrue | E-06 | ○ |
| C-48 | 無効なアドレスでIsValidがfalse | E-06 | ○ |

### CommandInterpreter関連（UT-LDB-049〜052）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-49 | HandleCommandがコマンドを実行する | E-07 | ○ |
| C-50 | 無効コマンドでエラーを返却する | E-07 | ○ |
| C-51 | GetCommandObjectForCommandがオブジェクトを返却する | E-07 | ○ |
| C-52 | 存在しないコマンドでnullptrを返却する | E-07 | ○ |

### ValueObject関連（UT-LDB-053〜059）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-53 | GetValueAsSignedがint64_tを返却する | E-08 | ○ |
| C-54 | GetValueAsUnsignedがuint64_tを返却する | E-08 | ○ |
| C-55 | UpdateValueIfNeededが値を更新する | E-08 | ○ |
| C-56 | GetChildAtIndexが子要素を返却する | E-08 | ○ |
| C-57 | 範囲外インデックスで空を返却する | E-08 | ○ |
| C-58 | GetSummaryAsCStringがサマリを返却する | E-08 | ○ |
| C-59 | GetNumChildrenが子要素数を返却する | E-08 | ○ |

### Symbol関連（UT-LDB-060〜066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-60 | Symbolコンストラクタで初期化が完了する | E-09 | ○ |
| C-61 | GetMangledがMangledを返却する | E-09 | ○ |
| C-62 | GetTypeがSymbolTypeを返却する | E-09 | ○ |
| C-63 | GetAddressがAddressを返却する | E-09 | ○ |
| C-64 | FromJSONがSymbolを作成する | E-09 | ○ |
| C-65 | SectionListがnullでエラーを返却する | E-09 | ○ |
| C-66 | value/address両方指定でエラーを返却する | E-09 | ○ |

### UserExpression関連（UT-LDB-067〜070）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | Evaluateが式を評価する | E-10 | ○ |
| C-68 | GetObjectPointerがaddr_tを返却する | E-10 | ○ |
| C-69 | frame_spがnullでLLDB_INVALID_ADDRESSを返却する | E-10 | ○ |
| C-70 | MatchesContextがコンテキストを検証する | E-10 | ○ |

### Module関連（UT-LDB-071〜075）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-71 | GetFileSpecがFileSpecを返却する | E-01 | ○ |
| C-72 | GetArchitectureがArchSpecを返却する | E-01 | ○ |
| C-73 | GetSymbolFileがSymbolFile*を返却する | E-01 | ○ |
| C-74 | ResolveFileAddressがアドレスを解決する | E-01 | ○ |
| C-75 | FindFunctionsが関数を検索する | E-01 | ○ |

### StackFrame関連（UT-LDB-076〜080）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-76 | GetFrameIndexがuint32_tを返却する | E-04 | ○ |
| C-77 | GetRegisterContextがRegisterContextSPを返却する | E-04 | ○ |
| C-78 | GetVariableListがVariableListSPを返却する | E-04 | ○ |
| C-79 | GetValueForVariableExpressionPathが値を返却する | E-04 | ○ |
| C-80 | GetSymbolContextがSymbolContextを返却する | E-04 | ○ |

### BreakpointLocation関連（UT-LDB-081〜083）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-81 | SetEnabledでロケーションが有効化される | E-05 | ○ |
| C-82 | SetConditionで条件が設定される | E-05 | ○ |
| C-83 | GetHitCountがヒット回数を返却する | E-05 | ○ |

### Watchpoint関連（UT-LDB-084〜086）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-84 | SetEnabledでウォッチポイントが有効化される | **根拠なし** | △ |
| C-85 | GetWatchAddressがaddr_tを返却する | **根拠なし** | △ |
| C-86 | GetWatchSizeがsize_tを返却する | **根拠なし** | △ |

### Disassembler関連（UT-LDB-087〜088）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-87 | FindPluginがDisassemblerSPを返却する | E-01 | ○ |
| C-88 | GetInstructionListがInstructionListを返却する | E-01 | ○ |

### SectionLoadList関連（UT-LDB-089〜090）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-89 | ResolveLoadAddressがアドレスを解決する | E-02 | ○ |
| C-90 | SetSectionLoadAddressがアドレスを設定する | E-02 | ○ |

### RegisterContext関連（UT-LDB-091〜094）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-91 | ReadRegisterがレジスタ値を読み取る | E-04 | ○ |
| C-92 | WriteRegisterがレジスタ値を書き込む | E-04 | ○ |
| C-93 | GetRegisterInfoByNameがRegisterInfo*を返却する | E-04 | ○ |
| C-94 | 存在しないレジスタ名でnullptrを返却する | E-04 | ○ |

### DataExtractor関連（UT-LDB-095〜100）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-95 | GetU8がuint8_tを返却する | E-06 | ○ |
| C-96 | GetU16がuint16_tを返却する | E-06 | ○ |
| C-97 | GetU32がuint32_tを返却する | E-06 | ○ |
| C-98 | GetU64がuint64_tを返却する | E-06 | ○ |
| C-99 | GetCStrがconst char*を返却する | E-06 | ○ |
| C-100 | 範囲外オフセットでnullptrを返却する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）

### Watchpoint関連（C-84〜C-86）
- **理由**: Watchpoint.cppソースファイルを詳細に解析していないため
- **候補**: `lldb/source/Breakpoint/Watchpoint.cpp` / `lldb/include/lldb/Breakpoint/Watchpoint.h`

### DataExtractor境界値テスト（C-100）
- **理由**: 境界値エラー処理の詳細な動作確認が未実施
- **候補**: `lldb/source/Utility/DataExtractor.cpp` / 既存のユニットテストコード

## 5) リスクフラグ（レビュー観点）

| リスクレベル | 対象 | 説明 |
|---|---|---|
| 1 (中リスク) | Watchpoint関連テスト | ソースコード解析が不十分なため、テストケースの正確性要確認 |
| 0 (低リスク) | 大部分のテストケース | ソースコードから直接確認済み |
| 1 (中リスク) | プラットフォーム固有テスト | RegisterContext等はプラットフォーム依存実装のため追加確認推奨 |

## 6) レビュアーチェックリスト（最小）
- [ ] Watchpoint関連テストケース（UT-LDB-084〜086）のソースコード確認
- [ ] DataExtractor境界値テスト（UT-LDB-100）の動作確認
- [ ] プラットフォーム固有実装（RegisterContext等）のテストケース妥当性確認
- [ ] 高優先度テストケースの入力値・期待結果の妥当性確認
- [ ] テストID命名規則（UT-LDB-XXX）の一貫性確認
