---
generated_at: 2026-02-01 22:30:00
metrics:
  claims_total: 100
  claims_with_evidence: 95
  claims_without_evidence: 5
confidence_derived: 0.95
---

# 根拠レポート：llvm.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧（llvm.csv）の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：95 / 100、根拠なし：5
- 優先レビュー（高）
  1. **UT-LLVM-085**：PassBuilder::parsePassPipelineの詳細な入出力仕様が未確認
  2. **UT-LLVM-086**：AsmParser::parseStatementの完全なパース仕様が未確認
  3. **UT-LLVM-087**：MacroInstantiationの内部状態管理の詳細が未確認
  4. **UT-LLVM-077**：DAGUpdateListenerのコールバック仕様の詳細が未確認
  5. **UT-LLVM-067**：edit_distance関数の具体的な期待値が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/lib/IR/Value.cpp` - Valueクラスの実装
- E-02: `llvm/lib/IR/Module.cpp` - Moduleクラスの実装
- E-03: `llvm/lib/IR/Function.cpp` - FunctionおよびArgumentクラスの実装
- E-04: `llvm/lib/IR/Instructions.cpp` - 命令クラス（AllocaInst, SelectInst, PHINode等）の実装
- E-05: `llvm/lib/Support/APInt.cpp` - APIntクラスの実装
- E-06: `llvm/lib/Support/StringRef.cpp` - StringRefクラスの実装
- E-07: `llvm/lib/Analysis/ValueTracking.cpp` - computeKnownBits等の解析関数
- E-08: `llvm/lib/Transforms/Utils/BasicBlockUtils.cpp` - BasicBlock操作ユーティリティ
- E-09: `llvm/lib/CodeGen/SelectionDAG/SelectionDAG.cpp` - SelectionDAG関連クラス
- E-10: `llvm/lib/Passes/PassBuilder.cpp` - PassBuilder実装
- E-11: `llvm/lib/MC/MCParser/AsmParser.cpp` - アセンブリパーサー実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Value::Valueコンストラクタの初期化処理 | E-01 (53-74行目) | ○ |
| C-02 | Value::~Valueデストラクタの処理 | E-01 (76-109行目) | ○ |
| C-03 | Value::hasNUsesの使用回数カウント | E-01 (150-156行目) | ○ |
| C-04 | Value::hasNUsesの境界値処理 | E-01 (151-152行目) | ○ |
| C-05 | Value::hasNUsesOrMoreの実装 | E-01 (158-164行目) | ○ |
| C-06 | Value::hasOneUserの単一ユーザー判定 | E-01 (166-172行目) | ○ |
| C-07 | Value::hasOneUserの空リスト処理 | E-01 (167-168行目) | ○ |
| C-08 | Value::getSingleUndroppableUseの実装 | E-01 (176-186行目) | ○ |
| C-09 | Value::getSingleUndroppableUseの複数Use時 | E-01 (180-181行目) | ○ |
| C-10 | Value::getUniqueUndroppableUserの実装 | E-01 (188-198行目) | ○ |
| C-11 | Value::deleteValueの動作 | E-01 (111-139行目) | ○ |
| C-12 | Value::destroyValueNameの動作 | E-01 (141-148行目) | ○ |
| C-13 | Module::Moduleコンストラクタ | E-02 (73-77行目) | ○ |
| C-14 | Module::~Moduleデストラクタ | E-02 (118-125行目) | ○ |
| C-15 | Module::operator=ムーブ代入 | E-02 (79-116行目) | ○ |
| C-16 | Module::getNamedValueの検索 | E-02 (177-179行目) | ○ |
| C-17 | Module::getNamedValueの失敗時 | E-02 (177-179行目) | ○ |
| C-18 | Module::getNumNamedValues | E-02 (181-183行目) | ○ |
| C-19 | Module::getMDKindID | E-02 (187-189行目) | ○ |
| C-20 | Module::createRNG | E-02 (154-172行目) | ○ |
| C-21 | Module::removeDebugIntrinsicDeclarations | E-02 (127-152行目) | ○ |
| C-22 | Function::renumberBlocks | E-03 (69-76行目) | ○ |
| C-23 | Function::validateBlockNumbers | E-03 (78-88行目) | ○ |
| C-24 | Function::convertToNewDbgValues | E-03 (90-94行目) | ○ |
| C-25 | Function::convertFromNewDbgValues | E-03 (96-100行目) | ○ |
| C-26 | Argument::Argumentコンストラクタ | E-03 (106-109行目) | ○ |
| C-27 | Argument::hasNonNullAttr正常系 | E-03 (115-126行目) | ○ |
| C-28 | Argument::hasNonNullAttr異常系 | E-03 (116行目) | ○ |
| C-29 | Argument::hasByValAttr | E-03 (128-131行目) | ○ |
| C-30 | Argument::hasByRefAttr | E-03 (138-142行目) | ○ |
| C-31 | Argument::hasSwiftSelfAttr | E-03 (144-146行目) | ○ |
| C-32 | Argument::hasSwiftErrorAttr | E-03 (148-150行目) | ○ |
| C-33 | Argument::hasPassPointeeByValueCopyAttr | E-03 (163-169行目) | ○ |
| C-34 | APInt::APInt基本コンストラクタ | E-05 (107-109行目) | ○ |
| C-35 | APInt::APInt 1ビット | E-05 (107-109行目) | ○ |
| C-36 | APInt::APInt配列初期化 | E-05 (107-109, 91-105行目) | ○ |
| C-37 | APInt::APInt文字列パース | E-05 (116-119行目) | ○ |
| C-38 | APInt::operator++正常系 | E-05 (178-184行目) | ○ |
| C-39 | APInt::operator++オーバーフロー | E-05 (183行目 clearUnusedBits) | ○ |
| C-40 | APInt::operator--正常系 | E-05 (187-193行目) | ○ |
| C-41 | APInt::operator--アンダーフロー | E-05 (192行目 clearUnusedBits) | ○ |
| C-42 | APInt::operator+=正常系 | E-05 (198-200行目) | ○ |
| C-43 | APInt::isAligned正常系 | E-05 (169-175行目) | ○ |
| C-44 | APInt::isAlignedゼロ値 | E-05 (170-171行目) | ○ |
| C-45 | APInt::Profile | E-05 (156-167行目) | ○ |
| C-46 | APInt::reallocate | E-05 (121-138行目) | ○ |
| C-47 | APInt::assignSlowCase | E-05 (140-153行目) | ○ |
| C-48 | AllocaInst::getAllocationSize正常系 | E-04 (64-82行目) | ○ |
| C-49 | AllocaInst::getAllocationSize配列 | E-04 (70-80行目) | ○ |
| C-50 | AllocaInst::getAllocationSize動的 | E-04 (71-74行目) | ○ |
| C-51 | AllocaInst::getAllocationSizeInBits | E-04 (84-94行目) | ○ |
| C-52 | SelectInst::areInvalidOperands正常系 | E-04 (102-123行目) | ○ |
| C-53 | SelectInst::areInvalidOperands型不一致 | E-04 (103-104行目) | ○ |
| C-54 | SelectInst::areInvalidOperandsトークン | E-04 (106-107行目) | ○ |
| C-55 | SelectInst::areInvalidOperandsベクトル | E-04 (109-118行目) | ○ |
| C-56 | PHINode::PHINodeコピー | E-04 (129-137行目) | ○ |
| C-57 | PHINode::removeIncomingValue正常系 | E-04 (141-161行目) | ○ |
| C-58 | PHINode::removeIncomingValue境界値 | E-04 (155-159行目) | ○ |
| C-59 | PHINode::removeIncomingValueIf | E-04 (163-188行目) | ○ |
| C-60 | PHINode::growOperands | E-04 (194-200行目) | ○ |
| C-61 | StringRef::compare_insensitive正常系 | E-06 (32-39行目) | ○ |
| C-62 | StringRef::compare_insensitive長さ | E-06 (36-38行目) | ○ |
| C-63 | StringRef::starts_with_insensitive | E-06 (41-44行目) | ○ |
| C-64 | StringRef::ends_with_insensitive | E-06 (46-49行目) | ○ |
| C-65 | StringRef::find_insensitive | E-06 (51-54行目) | ○ |
| C-66 | StringRef::compare_numeric | E-06 (57-85行目) | ○ |
| C-67 | StringRef::edit_distance | E-06 (88-94行目) | △ |
| C-68 | StringRef::lower | E-06 (107-110行目) | ○ |
| C-69 | StringRef::upper | E-06 (112-115行目) | ○ |
| C-70 | StringRef::find正常系 | E-06 (126-150行目) | ○ |
| C-71 | StringRef::find空文字列 | E-06 (135-136行目) | ○ |
| C-72 | StringRef::find失敗 | E-06 (137-138行目) | ○ |
| C-73 | ConstantFPSDNode::isExactlyValue | E-09 (130-132行目) | ○ |
| C-74 | ConstantFPSDNode::isValueValidForType正常系 | E-09 (134-144行目) | ○ |
| C-75 | ConstantFPSDNode::isValueValidForType精度 | E-09 (140-143行目) | ○ |
| C-76 | ISD::isConstantSplatVector | E-09 (150行目) | ○ |
| C-77 | DAGUpdateListener::NodeDeleted | E-09 (94-96行目) | △ |
| C-78 | computeKnownBits正常系 | E-07 (141-150行目) | ○ |
| C-79 | computeKnownBitsスカラブルベクトル | E-07 (143-148行目) | ○ |
| C-80 | haveNoCommonBitsSetSpecialCases | E-07 (179-200行目) | ○ |
| C-81 | detachDeadBlocks | E-08 (104-143行目) | ○ |
| C-82 | emptyAndDetachBlock | E-08 (64-93行目) | ○ |
| C-83 | DeleteDeadBlock | E-08 (145-148行目) | ○ |
| C-84 | HasLoopOrEntryConvergenceToken | E-08 (95-102行目) | ○ |
| C-85 | PassBuilder::parsePassPipeline | E-10 | △ |
| C-86 | AsmParser::parseStatement | E-11 | △ |
| C-87 | MacroInstantiation | E-11 (86-98行目) | △ |
| C-88 | getDigit正常系 | E-05 (47-71行目) | ○ |
| C-89 | getDigit 16進数 | E-05 (50-61行目) | ○ |
| C-90 | getDigit異常系 | E-05 (70行目) | ○ |
| C-91 | checkType正常系 | E-01 (46-51行目) | ○ |
| C-92 | checkType null | E-01 (47行目) | ○ |
| C-93 | initSlowCase | E-05 (74-84行目) | ○ |
| C-94 | initFromArray正常系 | E-05 (91-105行目) | ○ |
| C-95 | initFromArrayシングルワード | E-05 (93-94行目) | ○ |
| C-96 | getOperandBundleTags | E-02 (198-200行目) | ○ |
| C-97 | getMDKindNames | E-02 (194-196行目) | ○ |
| C-98 | Argument::getDeadOnReturnInfo | E-03 (133-136行目) | ○ |
| C-99 | Argument::hasInAllocaAttr | E-03 (152-155行目) | ○ |
| C-100 | Argument::hasPreallocatedAttr | E-03 (157-161行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- PassBuilder::parsePassPipelineの詳細なパイプライン文法仕様
  - 候補：llvm/docs/NewPassManager.rst / llvm/include/llvm/Passes/PassBuilder.h
- AsmParser::parseStatementの完全なパース仕様とエラーハンドリング詳細
  - 候補：llvm/lib/MC/MCParser/AsmParser.cpp 全文 / llvm/docs/
- MacroInstantiationのネスト時の挙動詳細
  - 候補：llvm/lib/MC/MCParser/AsmParser.cpp 内のマクロ展開ロジック
- DAGUpdateListenerの登録・解除タイミングの詳細仕様
  - 候補：llvm/include/llvm/CodeGen/SelectionDAG.h
- edit_distance関数の具体的なアルゴリズム実装詳細と期待値計算方法
  - 候補：llvm/ADT/edit_distance.h

## 5) リスクフラグ（レビュー観点）
- **リスク1（中）**: PassBuilder関連テストケースは、パスパイプライン文法の変更により影響を受ける可能性あり
- **リスク1（低）**: AsmParser関連テストケースは、ターゲット固有の拡張により期待結果が異なる可能性あり
- **リスク0（低）**: 大部分のテストケースはLLVMコアIR/ADTクラスに基づいており、安定したAPI

## 6) レビュアーチェックリスト（最小）
- [ ] 各テストケースの前提条件が実際のコード状態と一致しているか確認
- [ ] 境界値テストケース（UT-LLVM-004, 039, 041, 044, 058, 071）の期待結果が仕様と合致しているか確認
- [ ] 高優先度テストケースのカバレッジが十分か確認（特にValue, Module, APInt関連）
- [ ] 異常系テストケースのエラーハンドリングが適切か確認
- [ ] PassBuilder、AsmParser関連の△項目について追加調査が必要か判断
- [ ] テストケースの優先度付けが適切か確認（高：データ整合性・メモリ管理、中：機能、低：補助機能）
