---
generated_at: 2026-02-01 22:30:00
metrics:
  claims_total: 180
  claims_with_evidence: 168
  claims_without_evidence: 12
confidence_derived: 0.93
---

# 根拠レポート：offload.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：168 / 180、根拠なし：12
- 優先レビュー（高）
  1. **UT-OFF-119〜UT-OFF-123（RecordReplayTy関連）**：内部実装の詳細確認が必要
  2. **UT-OFF-143〜UT-OFF-146（GPUProfGlobals関連）**：プロファイリング機能の実装詳細確認が必要
  3. **UT-OFF-172〜UT-OFF-175（エラー比較/ハッシュ関連）**：内部ヘルパークラスの詳細確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `offload/liboffload/src/OffloadImpl.cpp` - 主要なliboffload API実装
- E-02: `offload/liboffload/include/OffloadImpl.hpp` - liboffload実装ヘッダー
- E-03: `offload/liboffload/src/Helpers.hpp` - InfoWriterヘルパークラス
- E-04: `offload/libomptarget/PluginManager.cpp` - プラグイン管理実装
- E-05: `offload/plugins-nextgen/common/src/PluginInterface.cpp` - プラグインインターフェース実装
- E-06: `offload/plugins-nextgen/common/include/PluginInterface.h` - プラグインインターフェースヘッダー
- E-07: `offload/plugins-nextgen/common/src/GlobalHandler.cpp` - グローバル変数ハンドラ実装
- E-08: `offload/libomptarget/OpenMP/API.cpp` - OpenMP API実装
- E-09: `offload/libomptarget/OpenMP/Mapping.cpp` - マッピング処理実装
- E-10: `offload/include/PluginManager.h` - プラグインマネージャヘッダー（推定）

## 3) Claims と根拠の対応（レビューの主戦場）

### liboffload コア機能（UT-OFF-001〜UT-030）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | olInit_impl初期化動作 | E-01 (lines 310-326) | ○ |
| C-02 | olInit_impl二重初期化でRefCountインクリメント | E-01 (lines 313-315) | ○ |
| C-03 | olShutDown_implシャットダウン動作 | E-01 (lines 328-348) | ○ |
| C-04 | olShutDown_implのRefCount管理 | E-01 (lines 331-332) | ○ |
| C-05 | ol_platform_impl_t::init | E-01 (lines 139-159) | ○ |
| C-06 | ol_platform_impl_t::init異常系 | E-01 (lines 143-144) | ○ |
| C-07 | ol_platform_impl_t::destroy | E-01 (lines 127-137) | ○ |
| C-08 | ol_device_impl_t::getOutstandingQueue正常系 | E-01 (lines 91-111) | ○ |
| C-09 | ol_device_impl_t::getOutstandingQueue境界値 | E-01 (lines 95) | ○ |
| C-10 | ol_device_impl_t::destroy | E-01 (lines 117-124) | ○ |

### プラットフォーム/デバイス情報取得（UT-OFF-011〜UT-019）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-11 | olGetPlatformInfo_impl NAME取得 | E-01 (lines 358-360) | ○ |
| C-12 | olGetPlatformInfo_impl BACKEND取得 | E-01 (lines 369-371) | ○ |
| C-13 | olGetPlatformInfo_impl不正enum | E-01 (lines 372-374) | ○ |
| C-14 | olGetDeviceInfo_impl NAME取得 | E-01 (lines 476-485) | ○ |
| C-15 | olGetDeviceInfo_impl TYPE取得 | E-01 (lines 417-418) | ○ |
| C-16 | olGetDeviceInfo_impl メモリサイズ取得 | E-01 (lines 453-458) | ○ |
| C-17 | olGetDeviceInfoImplDetailHost | E-01 (lines 546-616) | ○ |
| C-18 | olIterateDevices_impl列挙 | E-01 (lines 635-645) | ○ |
| C-19 | olIterateDevices_impl中断 | E-01 (lines 638-639) | ○ |

### メモリ管理（UT-OFF-020〜UT-028）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-20 | olMemAlloc_impl DEVICE | E-01 (lines 660-714) | ○ |
| C-21 | olMemAlloc_impl HOST | E-01 (lines 647-657) | ○ |
| C-22 | olMemAlloc_impl MANAGED | E-01 (lines 654-656) | ○ |
| C-23 | olMemAlloc_impl重複リトライ | E-01 (lines 667-713) | ○ |
| C-24 | olMemFree_impl正常系 | E-01 (lines 716-739) | ○ |
| C-25 | olMemFree_impl未確保エラー | E-01 (lines 721-723) | ○ |
| C-26 | olGetMemInfo_impl | E-01 (lines 741-782) | ○ |
| C-27 | olGetMemInfo_implオフセット | E-01 (lines 754-764) | ○ |
| C-28 | olGetMemInfo_impl未確保エラー | E-01 (lines 761-763) | ○ |

### キュー管理（UT-OFF-029〜UT-034）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-29 | olCreateQueue_impl | E-01 (lines 795-813) | ○ |
| C-30 | olCreateQueue_impl再利用 | E-01 (lines 798-805) | ○ |
| C-31 | olDestroyQueue_impl完了済み | E-01 (lines 815-836) | ○ |
| C-32 | olDestroyQueue_impl未完了 | E-01 (lines 829-833) | ○ |
| C-33 | olSyncQueue_impl | E-01 (lines 838-850) | ○ |
| C-34 | olSyncQueue_impl境界値 | E-01 (lines 841) | ○ |

### イベント管理（UT-OFF-035〜UT-042）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-35 | olWaitEvents_impl | E-01 (lines 852-872) | ○ |
| C-36 | olWaitEvents_impl同一キュースキップ | E-01 (lines 864) | ○ |
| C-37 | olWaitEvents_impl NULLイベント | E-01 (lines 859-861) | ○ |
| C-38 | olCreateEvent_impl | E-01 (lines 966-985) | ○ |
| C-39 | olCreateEvent_impl空キュー | E-01 (lines 972-975) | ○ |
| C-40 | olSyncEvent_impl | E-01 (lines 907-916) | ○ |
| C-41 | olSyncEvent_impl境界値 | E-01 (lines 909-910) | ○ |
| C-42 | olDestroyEvent_impl | E-01 (lines 918-924) | ○ |

### データ転送（UT-OFF-043〜UT-049）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-43 | olMemcpy_impl Host-Host | E-01 (lines 991-994) | ○ |
| C-44 | olMemcpy_impl Host-Device | E-01 (lines 1010-1013) | ○ |
| C-45 | olMemcpy_impl Device-Host | E-01 (lines 1006-1009) | ○ |
| C-46 | olMemcpy_impl同一プラグイン間 | E-01 (lines 1014-1020) | ○ |
| C-47 | olMemcpy_impl異プラグイン間 | E-01 (lines 1021-1036) | ○ |
| C-48 | olMemcpy_impl Queue+Host-Hostエラー | E-01 (lines 995-1000) | ○ |
| C-49 | olMemFill_impl | E-01 (lines 1041-1045) | ○ |

### プログラム/シンボル管理（UT-OFF-050〜UT-066）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-50 | olCreateProgram_impl | E-01 (lines 1047-1058) | ○ |
| C-51 | olCreateProgram_impl異常系 | E-01 (lines 1052-1053) | ○ |
| C-52 | olIsValidBinary_impl互換 | E-01 (lines 1060-1067) | ○ |
| C-53 | olIsValidBinary_impl非互換 | E-01 (lines 1063-1065) | ○ |
| C-54 | olDestroyProgram_impl | E-01 (lines 1069-1079) | ○ |
| C-55 | olGetSymbol_implカーネル | E-01 (lines 1150-1166) | ○ |
| C-56 | olGetSymbol_implグローバル変数 | E-01 (lines 1167-1182) | ○ |
| C-57 | olGetSymbol_implキャッシュ | E-01 (lines 1151-1152) | ○ |
| C-58 | olGetSymbol_impl不正Kind | E-01 (lines 1183-1186) | ○ |
| C-59 | olLaunchKernel_impl | E-01 (lines 1099-1141) | ○ |
| C-60 | olLaunchKernel_implデバイス不一致 | E-01 (lines 1104-1108) | ○ |
| C-61 | olLaunchKernel_impl非カーネル | E-01 (lines 1110-1112) | ○ |
| C-62 | olCalculateOptimalOccupancy_impl | E-01 (lines 1081-1097) | ○ |
| C-63 | olCalculateOptimalOccupancy_impl非カーネル | E-01 (lines 1085-1087) | ○ |
| C-64 | olGetSymbolInfo_impl KIND | E-01 (lines 1206-1207) | ○ |
| C-65 | olGetSymbolInfo_impl ADDRESS | E-01 (lines 1208-1211) | ○ |
| C-66 | olGetSymbolInfo_implシンボル種別不一致 | E-01 (lines 1209) | ○ |

### その他API（UT-OFF-067〜UT-085）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-67 | olLaunchHostFunction_impl | E-01 (lines 1236-1241) | ○ |
| C-68 | olMemRegister_impl | E-01 (lines 1243-1252) | ○ |
| C-69 | olMemUnregister_impl | E-01 (lines 1254-1256) | ○ |
| C-70 | olQueryQueue_impl | E-01 (lines 1258-1268) | ○ |
| C-71 | olQueryQueue_impl境界値 | E-01 (lines 1263-1266) | ○ |
| C-72 | pluginNameToBackend amdgpu | E-01 (lines 262-263) | ○ |
| C-73 | pluginNameToBackend cuda | E-01 (lines 264-265) | ○ |
| C-74 | pluginNameToBackend level_zero | E-01 (lines 266-267) | ○ |
| C-75 | pluginNameToBackend unknown | E-01 (lines 268-270) | ○ |
| C-76 | convertOlToPluginAllocTy DEVICE | E-01 (lines 649-650) | ○ |
| C-77 | convertOlToPluginAllocTy HOST | E-01 (lines 651-652) | ○ |
| C-78 | convertOlToPluginAllocTy MANAGED | E-01 (lines 653-656) | ○ |
| C-79 | isTracingEnabled有効 | E-01 (lines 250-252) | ○ |
| C-80 | isTracingEnabled未初期化 | E-01 (lines 251) | ○ |
| C-81 | isValidationEnabled | E-01 (lines 253) | ○ |
| C-82 | InfoWriter::write | E-03 (lines 78-80) | ○ |
| C-83 | InfoWriter::writeString | E-03 (lines 86-88) | ○ |
| C-84 | InfoWriter::write異常系 | E-03 (lines 31-34) | ○ |
| C-85 | InfoWriter::write両方null | E-03 (lines 25-28) | ○ |

### PluginManager（UT-OFF-086〜UT-098）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-86 | PluginManager::init | E-04 (lines 33-51) | ○ |
| C-87 | PluginManager::deinit | E-04 (lines 53-69) | ○ |
| C-88 | PluginManager::initializePlugin | E-04 (lines 71-85) | ○ |
| C-89 | PluginManager::initializePluginスキップ | E-04 (lines 72-73) | ○ |
| C-90 | PluginManager::initializeDevice | E-04 (lines 87-121) | ○ |
| C-91 | PluginManager::initializeDevice既存 | E-04 (lines 89-95) | ○ |
| C-92 | PluginManager::initializeAllDevices | E-04 (lines 123-140) | ○ |
| C-93 | PluginManager::registerLib | E-04 (lines 196-317) | ○ |
| C-94 | PluginManager::unregisterLib | E-04 (lines 323-387) | ○ |
| C-95 | PluginManager::upgradeLegacyEntries変換 | E-04 (lines 144-194) | ○ |
| C-96 | PluginManager::upgradeLegacyEntries新形式 | E-04 (lines 156-158) | ○ |
| C-97 | PluginManager::getDevice | E-04 (lines 553-573) | ○ |
| C-98 | PluginManager::getDevice範囲外 | E-04 (lines 557-561) | ○ |

### GenericKernelTy（UT-OFF-099〜UT-105）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-99 | GenericKernelTy::init | E-05 (lines 400-434) | ○ |
| C-100 | GenericKernelTy::initデフォルト | E-05 (lines 414-418) | ○ |
| C-101 | GenericKernelTy::launch | E-06 (lines 361-368) | ○ |
| C-102 | GenericKernelTy::getKernelLaunchEnvironment | E-05 (lines 436-489) | ○ |
| C-103 | GenericKernelTy::getKernelLaunchEnvironment Replay | E-05 (lines 443-445) | ○ |
| C-104 | GenericKernelTy::isValidExecutionMode有効 | E-06 (lines 393-402) | ○ |
| C-105 | GenericKernelTy::isValidExecutionMode無効 | E-06 (lines 402) | ○ |

### AsyncInfoWrapperTy（UT-OFF-106〜UT-108）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-106 | AsyncInfoWrapperTy::finalize同期 | E-05 (lines 386-398) | ○ |
| C-107 | AsyncInfoWrapperTy::finalize外部 | E-05 (lines 393) | ○ |
| C-108 | AsyncInfoWrapperTy::freeAllocationAfterSynchronization | E-06 (lines 157-160) | ○ |

### GenericGlobalHandlerTy（UT-OFF-109〜UT-118）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-109 | GenericGlobalHandlerTy::getELFObjectFile正常 | E-07 (lines 32-44) | ○ |
| C-110 | GenericGlobalHandlerTy::getELFObjectFile異常 | E-07 (lines 39-42) | ○ |
| C-111 | GenericGlobalHandlerTy::isSymbolInImage存在 | E-07 (lines 90-110) | ○ |
| C-112 | GenericGlobalHandlerTy::isSymbolInImage不存在 | E-07 (lines 104-107) | ○ |
| C-113 | GenericGlobalHandlerTy::getGlobalMetadataFromImage | E-07 (lines 112-145) | ○ |
| C-114 | GenericGlobalHandlerTy::getGlobalMetadataFromImage不存在 | E-07 (lines 128-131) | ○ |
| C-115 | GenericGlobalHandlerTy::readGlobalFromImage | E-07 (lines 147-177) | ○ |
| C-116 | GenericGlobalHandlerTy::readGlobalFromImageサイズ不一致 | E-07 (lines 155-160) | ○ |
| C-117 | GenericGlobalHandlerTy::moveGlobalBetweenDeviceAndHost D2H | E-07 (lines 63-88) | ○ |
| C-118 | GenericGlobalHandlerTy::moveGlobalBetweenDeviceAndHost H2D | E-07 (lines 73-77) | ○ |

### RecordReplayTy（UT-OFF-119〜UT-123）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-119 | RecordReplayTy::isRecording | E-05 (lines 213) | ○ |
| C-120 | RecordReplayTy::isReplaying | E-05 (lines 214) | ○ |
| C-121 | RecordReplayTy::alloc | E-05 (lines 332-344) | ○ |
| C-122 | RecordReplayTy::init | E-05 (lines 346-366) | △ |
| C-123 | RecordReplayTy::deinit | E-05 (lines 368-377) | △ |

### MappingInfoTy（UT-OFF-124〜UT-135）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-124 | MappingInfoTy::associatePtr正常 | E-09 (lines 51-100) | ○ |
| C-125 | MappingInfoTy::associatePtr同一 | E-09 (lines 60-68) | ○ |
| C-126 | MappingInfoTy::associatePtr異なる | E-09 (lines 69-71) | ○ |
| C-127 | MappingInfoTy::disassociatePtr正常 | E-09 (lines 102-136) | ○ |
| C-128 | MappingInfoTy::disassociatePtr未関連付け | E-09 (lines 105-109) | ○ |
| C-129 | MappingInfoTy::disassociatePtr HoldRefCount | E-09 (lines 114-121) | ○ |
| C-130 | MappingInfoTy::lookupMapping存在 | E-09 (lines 138-205) | ○ |
| C-131 | MappingInfoTy::lookupMapping不存在 | E-09 (lines 148-149) | ○ |
| C-132 | MappingInfoTy::lookupMapping Size=0 | E-09 (lines 155-171) | ○ |
| C-133 | MappingInfoTy::getTargetPointer既存 | E-09 (lines 207-251) | ○ |
| C-134 | MappingInfoTy::getTargetPointer新規 | E-09 (lines 292-300) | ○ |
| C-135 | MappingInfoTy::getTargetPointer USM | E-09 (lines 264-284) | ○ |

### InfoTreeNode（UT-OFF-136〜UT-139）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-136 | InfoTreeNode::add | E-06 (lines 205-229) | ○ |
| C-137 | InfoTreeNode::get(StringRef)存在 | E-06 (lines 231-240) | ○ |
| C-138 | InfoTreeNode::get(StringRef)不存在 | E-06 (lines 237-238) | ○ |
| C-139 | InfoTreeNode::get(DeviceInfo) | E-06 (lines 242-247) | ○ |

### DeviceImageTy（UT-OFF-140〜UT-142）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-140 | DeviceImageTy::getStart | E-06 (lines 332) | ○ |
| C-141 | DeviceImageTy::getSize | E-06 (lines 335) | ○ |
| C-142 | DeviceImageTy::getMemoryBuffer | E-06 (lines 338-341) | ○ |

### GPUProfGlobals（UT-OFF-143〜UT-146）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-143 | GPUProfGlobals::empty空 | E-07 (lines 324-326) | ○ |
| C-144 | GPUProfGlobals::empty非空 | E-07 (lines 325) | ○ |
| C-145 | GPUProfGlobals::write | E-07 (lines 282-322) | △ |
| C-146 | GPUProfGlobals::writeエラー | E-07 (lines 283-287) | △ |

### OpenMP API（UT-OFF-147〜UT-171）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-147 | omp_get_num_devices | E-08 (lines 54-62) | ○ |
| C-148 | omp_get_device_num | E-08 (lines 64-72) | ○ |
| C-149 | omp_get_initial_device | E-08 (lines 133-139) | ○ |
| C-150 | omp_target_alloc | E-08 (lines 141-146) | ○ |
| C-151 | omp_target_free | E-08 (lines 163-167) | ○ |
| C-152 | omp_target_is_present存在 | E-08 (lines 205-237) | ○ |
| C-153 | omp_target_is_present不存在 | E-08 (lines 230-235) | ○ |
| C-154 | omp_target_is_present NULL | E-08 (lines 211-215) | ○ |
| C-155 | omp_target_is_accessible | E-08 (lines 241-265) | ○ |
| C-156 | omp_target_is_accessible NULL | E-08 (lines 248-252) | ○ |
| C-157 | omp_target_memcpy | E-08 (lines 267-300) | ○ |
| C-158 | omp_target_memcpy Length=0 | E-08 (lines 280-284) | ○ |
| C-159 | omp_target_memcpy NULL | E-08 (lines 279-288) | ○ |
| C-160 | omp_get_device_from_uid | E-08 (lines 78-107) | ○ |
| C-161 | omp_get_device_from_uid NULL | E-08 (lines 82-86) | ○ |
| C-162 | omp_get_device_from_uid ホスト | E-08 (lines 87-92) | ○ |
| C-163 | omp_get_uid_from_device | E-08 (lines 109-131) | ○ |
| C-164 | omp_get_uid_from_device無効 | E-08 (lines 113-116) | ○ |
| C-165 | llvm_omp_target_alloc_device | E-08 (lines 148-151) | ○ |
| C-166 | llvm_omp_target_alloc_host | E-08 (lines 153-156) | ○ |
| C-167 | llvm_omp_target_alloc_shared | E-08 (lines 158-161) | ○ |
| C-168 | llvm_omp_target_lock_mem | E-08 (lines 194-198) | ○ |
| C-169 | llvm_omp_target_unlock_mem | E-08 (lines 200-203) | ○ |
| C-170 | dumpTargetPointerMappings | E-09 (lines 21-49) | ○ |
| C-171 | dumpTargetPointerMappings空 | E-09 (lines 25-29) | ○ |

### エラー処理/ヘルパー（UT-OFF-172〜UT-180）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-172 | ErrPtrEqual同一 | E-02 (lines 43-58) | ○ |
| C-173 | ErrPtrEqual異なる | E-02 (lines 57) | ○ |
| C-174 | ErrPtrHash | E-02 (lines 60-68) | ○ |
| C-175 | ErrPtrHash null | E-02 (lines 63-65) | ○ |
| C-176 | llvmErrorToOffloadError変換 | E-02 (lines 83-100) | ○ |
| C-177 | llvmErrorToOffloadError成功 | E-02 (lines 84-87) | ○ |
| C-178 | getInfo | E-03 (lines 46-54) | ○ |
| C-179 | getInfoArray | E-03 (lines 56-62) | ○ |
| C-180 | getInfoString | E-03 (lines 64-68) | ○ |

## 4) 不足情報（Unknown / Missing）
- **RecordReplayTy詳細実装（C-122, C-123）**：初期化・終了処理の詳細動作はソース解析のみで確認、単体テスト既存例なし
  - 候補：既存テストケースの調査 / 開発者ドキュメント / コードコメント
- **GPUProfGlobals書き込み（C-145, C-146）**：__llvm_write_custom_profileシンボルの実在確認が困難
  - 候補：compiler-rtソース / ランタイム環境での動作確認
- **プラグイン固有実装（AMDGPU/CUDA/Level Zero）**：各プラグインのrtl.cppは解析対象としたが、ハードウェア依存の動作確認は困難
  - 候補：各ベンダーのSDKドキュメント / ハードウェアでの実行テスト

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: UT-OFF-072〜UT-085, UT-OFF-136〜UT-142, UT-OFF-172〜UT-180 - ユーティリティ関数、明確な実装
- **1 (中リスク)**: UT-OFF-011〜UT-019, UT-OFF-026〜UT-028, UT-OFF-062〜UT-071, UT-OFF-082〜UT-085, UT-OFF-119〜UT-123 - 情報取得系、補助機能
- **2 (高リスク)**: UT-OFF-001〜UT-010, UT-OFF-020〜UT-025, UT-OFF-029〜UT-061, UT-OFF-086〜UT-098, UT-OFF-099〜UT-118, UT-OFF-124〜UT-135, UT-OFF-147〜UT-169 - コア機能、メモリ管理、データ転送

## 6) レビュアーチェックリスト（最小）
- [ ] コア初期化/終了処理（UT-OFF-001〜010）のテストケースがシナリオを網羅しているか
- [ ] メモリ管理（UT-OFF-020〜028）で境界値・異常系が十分にカバーされているか
- [ ] キュー/イベント管理（UT-OFF-029〜042）の同期処理が正しく検証されているか
- [ ] データ転送（UT-OFF-043〜049）のHost/Device/異プラグイン間の組み合わせが網羅されているか
- [ ] プログラム/シンボル管理（UT-OFF-050〜066）でエラーハンドリングが適切か
- [ ] OpenMP API（UT-OFF-147〜169）が標準仕様に準拠しているか
- [ ] MappingInfoTy（UT-OFF-124〜135）のマッピング管理が正しく検証されているか
- [ ] RecordReplayTy（UT-OFF-119〜123）の詳細実装を追加確認
- [ ] GPUProfGlobals（UT-OFF-143〜146）のプロファイリング機能を実環境で検証
