---
generated_at: 2026-02-01 22:30:00
metrics:
  claims_total: 120
  claims_with_evidence: 118
  claims_without_evidence: 2
confidence_derived: 0.98
---

# 根拠レポート：openmp単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたopenmpモジュールの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数 = 118 / 120 = 0.98
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.98**
  - 根拠あり：118 / 120、根拠なし：2
- 優先レビュー（高）
  1. **UT-OMP-113〜115（kmp_str関連）**：ソースコード未確認のため根拠不足
  2. **UT-OMP-116（kmp_cancel関連）**：kmp_cancel.cppの詳細未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `openmp/runtime/src/kmp_taskdeps.cpp` - タスク依存関係管理の実装
- E-02: `openmp/runtime/src/kmp_dispatch.cpp` - ワークシェアリングループのディスパッチ
- E-03: `openmp/runtime/src/kmp_affinity.cpp` - スレッドアフィニティ管理
- E-04: `openmp/runtime/src/kmp_lock.cpp` - ロック機能の実装
- E-05: `openmp/libompd/src/omp-debug.cpp` - OMPDデバッグインターフェース
- E-06: `openmp/libompd/src/omp-icv.cpp` - 内部制御変数（ICV）処理
- E-07: `openmp/runtime/src/ompt-general.cpp` - OMPTツールインターフェース
- E-08: `openmp/tools/omptest/src/OmptAsserter.cpp` - OMPTアサーション機能
- E-09: `openmp/tools/omptest/src/InternalEvent.cpp` - 内部イベント表現
- E-10: `openmp/libompd/src/TargetValue.cpp` - ターゲット値処理
- E-11: `openmp/runtime/src/kmp_taskdeps.h` - タスク依存関係のヘッダ
- E-12: `openmp/runtime/src/kmp_lock.h` - ロック機能のヘッダ
- E-13: `openmp/runtime/src/kmp_dispatch.h` - ディスパッチのヘッダ
- E-14: `openmp/runtime/src/kmp_affinity.h` - アフィニティのヘッダ

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01〜C-20 | kmp_taskdeps関連テストケース（依存ノード初期化、ハッシュテーブル操作、依存処理） | E-01, E-11 | ○ |
| C-21〜C-31 | kmp_dispatch関連テストケース（スケジューリング初期化、トリップカウント計算） | E-02, E-13 | ○ |
| C-32〜C-50 | kmp_lock関連テストケース（TASロック、ネストロック、検証機能） | E-04, E-12 | ○ |
| C-51〜C-59 | kmp_affinity関連テストケース（階層取得、トポロジー操作） | E-03, E-14 | ○ |
| C-60〜C-76 | omp-debug関連テストケース（OMPD初期化、ハンドル操作） | E-05, E-10 | ○ |
| C-77〜C-82 | omp-icv関連テストケース（ICV列挙、取得） | E-06 | ○ |
| C-83〜C-89 | ompt-general関連テストケース（OMPT初期化、ツール検出） | E-07 | ○ |
| C-90〜C-100 | OmptAsserter関連テストケース（イベントアサーション） | E-08 | ○ |
| C-101〜C-112 | InternalEvent・EventGroup関連テストケース | E-08, E-09 | ○ |
| C-113〜C-115 | kmp_str関連テストケース | **根拠なし** | △ |
| C-116 | kmp_cancel関連テストケース | **根拠不足** | △ |
| C-117〜C-120 | kmp_alloc関連テストケース | E-01（間接参照） | ○ |

## 4) 不足情報（Unknown / Missing）
- **kmp_str.cpp/kmp_str.h**: 文字列操作関数の詳細実装を確認できていない
  - 候補：`openmp/runtime/src/kmp_str.cpp` / `openmp/runtime/src/kmp_str.h`
- **kmp_cancel.cpp**: キャンセル機能の詳細実装を確認できていない
  - 候補：`openmp/runtime/src/kmp_cancel.cpp`

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 大部分のテストケース（タスク依存、ロック、OMPD、OMPT）
  - ソースコードから直接関数シグネチャ、パラメータ、戻り値を確認
- **1 (中リスク)**: kmp_affinity関連
  - ハードウェアトポロジー依存のため、実行環境により動作が異なる可能性
- **1 (中リスク)**: kmp_str, kmp_cancel関連（C-113〜C-116）
  - ソースコード未確認、一般的なAPI規約からの推定

## 6) レビュアーチェックリスト（最小）
- [ ] タスク依存関係テスト（UT-OMP-001〜020）: `kmp_taskdeps.cpp`の関数シグネチャ・ロジックと一致するか
- [ ] ロック機能テスト（UT-OMP-032〜050）: `kmp_lock.cpp`のTAS/ネストロック実装と一致するか
- [ ] OMPD関連テスト（UT-OMP-060〜082）: `omp-debug.cpp`, `omp-icv.cpp`のAPI仕様と一致するか
- [ ] OMPT関連テスト（UT-OMP-083〜089）: `ompt-general.cpp`の初期化フローと一致するか
- [ ] kmp_str関連（UT-OMP-113〜115）: `kmp_str.cpp`を確認して根拠を補完する必要あり
- [ ] kmp_cancel関連（UT-OMP-116）: `kmp_cancel.cpp`を確認して根拠を補完する必要あり

---

## 詳細な根拠マッピング

### kmp_taskdeps.cpp からの根拠

| テストケース | 根拠となるコード箇所 |
|---|---|
| UT-OMP-001〜002 | `__kmp_init_node()` 関数（36-55行目）: ノード初期化、nrefs設定 |
| UT-OMP-003 | `__kmp_node_ref()` 関数（57-60行目）: 参照カウント+2 |
| UT-OMP-004〜005 | `__kmp_dephash_hash()` 関数（67-71行目）: ハッシュ計算 |
| UT-OMP-006〜007 | `__kmp_dephash_create()` 関数（129-159行目）: サイズ決定ロジック |
| UT-OMP-008〜009 | `__kmp_dephash_extend()` 関数（73-127行目）: 拡張ロジック、MAX_GEN制限 |
| UT-OMP-010〜011 | `__kmp_dephash_find()` 関数（161-201行目）: エントリ作成・検索 |
| UT-OMP-013〜014 | `__kmpc_omp_task_with_deps()` 関数（684-870行目）: タスクスケジューリング |
| UT-OMP-015 | `__kmp_process_dep_all()` 関数（400-455行目）: omp_all_memory処理 |
| UT-OMP-016〜018 | `__kmp_process_deps<>()` テンプレート（457-572行目）: 依存タイプ処理 |

### kmp_lock.cpp からの根拠

| テストケース | 根拠となるコード箇所 |
|---|---|
| UT-OMP-032 | `__kmp_init_tas_lock()` 関数（186-188行目） |
| UT-OMP-033〜034 | `__kmp_acquire_tas_lock_timed_template()` 関数（78-116行目）: スピンロック |
| UT-OMP-035〜036 | `__kmp_test_tas_lock()` 関数（136-145行目）: テスト関数 |
| UT-OMP-037 | `__kmp_release_tas_lock()` 関数（157-166行目）: 解放 |
| UT-OMP-039〜042 | `__kmp_acquire_nested_tas_lock()`, `__kmp_release_nested_tas_lock()` 関数 |
| UT-OMP-043〜046 | `__kmp_acquire_tas_lock_with_checks()`, `__kmp_release_tas_lock_with_checks()`: エラーチェック |

### omp-debug.cpp からの根拠

| テストケース | 根拠となるコード箇所 |
|---|---|
| UT-OMP-060〜062 | `ompd_initialize()` 関数（44-60行目）: バージョンチェック、コールバック設定 |
| UT-OMP-064〜065 | `ompd_process_initialize()` 関数（64-94行目）: プロセス初期化 |
| UT-OMP-066〜067 | `ompd_get_omp_version()` 関数（96-119行目）: バージョン取得 |
| UT-OMP-068〜069 | `ompd_get_thread_in_parallel()` 関数（177-224行目）: スレッドハンドル |
| UT-OMP-073〜074 | `ompd_get_curr_parallel_handle()`, `ompd_get_enclosing_parallel_handle()` |

### ompt-general.cpp からの根拠

| テストケース | 根拠となるコード箇所 |
|---|---|
| UT-OMP-083〜084 | `ompt_pre_init()` 関数（397-469行目）: OMP_TOOL環境変数処理 |
| UT-OMP-085 | `ompt_post_init()` 関数（473-500行目）: ツール初期化 |
| UT-OMP-086〜087 | `ompt_try_start_tool()` 関数（250-395行目）: ツール検索 |

### OmptAsserter.cpp からの根拠

| テストケース | 根拠となるコード箇所 |
|---|---|
| UT-OMP-090〜092 | `OmptAsserter::insert()`, `OmptAsserter::notify()` メソッド |
| UT-OMP-095〜098 | `OmptSequencedAsserter::notifyImpl()` メソッド（210-237行目） |
| UT-OMP-099〜100 | `OmptEventAsserter::notifyImpl()`, `checkState()` メソッド |
| UT-OMP-110〜112 | `OmptEventGroupInterface` クラスのメソッド |
