---
generated_at: 2026-02-01 10:30:00
metrics:
  claims_total: 160
  claims_with_evidence: 160
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：orc-rt 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成されたorc-rtモジュールの単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各テストケースに対して、ソースコード内のクラス・メソッド定義が存在するか
2. **根拠との整合性**：テストケースの内容がソースコードの実装と矛盾していないか
3. **網羅性**：モジュール内の主要なpublicメソッドをカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：160 / 160、根拠なし：0
- 優先レビュー（高）
  1. **Error/Expected関連（UT-ORC-001〜024）**：エラーハンドリングの中核機能
  2. **SPSシリアライゼーション関連（UT-ORC-047〜064）**：データ通信の基盤
  3. **Session/TaskDispatcher関連（UT-ORC-084〜101）**：ランタイム実行の中核

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `orc-rt/include/orc-rt/Error.h` - Error, Expected, StringError, ErrorInfoBase等の定義
- E-02: `orc-rt/include/orc-rt/ExecutorAddress.h` - ExecutorAddr, ExecutorAddrRange等の定義
- E-03: `orc-rt/include/orc-rt/SimplePackedSerialization.h` - SPSOutputBuffer, SPSInputBuffer, SPSArgList, SPSSerializationTraits等の定義
- E-04: `orc-rt/include/orc-rt/MemoryFlags.h` - MemProt, MemLifetime, AllocGroup, AllocGroupSmallMap等の定義
- E-05: `orc-rt/include/orc-rt/Session.h` - Session, ControllerAccess, CallViaSession等の定義
- E-06: `orc-rt/include/orc-rt/TaskDispatcher.h` - Task, GenericTask, TaskDispatcher等の定義
- E-07: `orc-rt/include/orc-rt/IntervalMap.h` - IntervalMapBase, IntervalMap等の定義
- E-08: `orc-rt/include/orc-rt/IntervalSet.h` - IntervalSet等の定義
- E-09: `orc-rt/include/orc-rt/AllocAction.h` - AllocAction, AllocActionPair, runFinalizeActions, runDeallocActions等の定義
- E-10: `orc-rt/include/orc-rt/WrapperFunction.h` - WrapperFunctionBuffer, WrapperFunction等の定義
- E-11: `orc-rt/include/orc-rt/RTTI.h` - RTTIRoot, RTTIExtends, isa等の定義
- E-12: `orc-rt/include/orc-rt/SimpleNativeMemoryMap.h` - SimpleNativeMemoryMap等の定義
- E-13: `orc-rt/include/orc-rt/Math.h` - isPowerOf2, nextPowerOf2等の定義
- E-14: `orc-rt/include/orc-rt/ScopeExit.h` - ScopeExitRunner, make_scope_exit等の定義
- E-15: `orc-rt/include/orc-rt/BitmaskEnum.h` - bitmask_enum_mask, bitmask演算子等の定義
- E-16: `orc-rt/include/orc-rt/Endian.h` - endian_read, endian_write等の定義
- E-17: `orc-rt/include/orc-rt/span.h` - span等の定義
- E-18: `orc-rt/include/orc-rt/QueueingTaskDispatcher.h` - QueueingTaskDispatcher等の定義
- E-19: `orc-rt/include/orc-rt/ThreadPoolTaskDispatcher.h` - ThreadPoolTaskDispatcher等の定義
- E-20: `orc-rt/include/orc-rt/ResourceManager.h` - ResourceManager等の定義
- E-21: `orc-rt/include/orc-rt/move_only_function.h` - move_only_function等の定義
- E-22: `orc-rt/include/orc-rt/bit.h` - byteswap, countl_zero, bit_width, has_single_bit, rotl, rotr等の定義
- E-23: `orc-rt/include/orc-rt/bind.h` - bind_front, BoundFn等の定義

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001 | Error::success()が成功状態を生成する | E-01 (Error.h:131行目) | ○ |
| C-002 | Error::operator bool()が失敗時trueを返す | E-01 (Error.h:134-137行目) | ○ |
| C-003 | Error::operator bool()が成功時falseを返す | E-01 (Error.h:134-137行目) | ○ |
| C-004 | Error::isA<T>()が正しい型判定をする | E-01 (Error.h:140-142行目) | ○ |
| C-005 | Error::isA<T>()が異なる型でfalseを返す | E-01 (Error.h:140-142行目) | ○ |
| C-006 | Errorがムーブコンストラクト可能 | E-01 (Error.h:106-109行目) | ○ |
| C-007 | Errorがムーブ代入可能 | E-01 (Error.h:115-128行目) | ○ |
| C-008 | make_error<T>()で指定型Error生成 | E-01 (Error.h:212-216行目) | ○ |
| C-009 | handleErrorsが適切なハンドラを呼ぶ | E-01 (Error.h:311-316行目) | ○ |
| C-010 | handleErrorsが未処理エラーを再返却 | E-01 (Error.h:291-303行目) | ○ |
| C-011 | handleAllErrorsが全エラー処理 | E-01 (Error.h:321-324行目) | ○ |
| C-012 | consumeErrorがエラーを消費 | E-01 (Error.h:552-554行目) | ○ |
| C-013 | cantFail(Error)が成功時正常終了 | E-01 (Error.h:558-566行目) | ○ |
| C-014 | cantFail(Expected<T>)が値取得 | E-01 (Error.h:570-574行目) | ○ |
| C-015 | toStringがエラー文字列化 | E-01 (Error.h:586-592行目) | ○ |
| C-016 | StringError::toString()が正しく動作 | E-01 (Error.h:595-602行目) | ○ |
| C-017 | Expected<T>が値から生成される | E-01 (Error.h:382-387行目) | ○ |
| C-018 | Expected<T>がErrorから生成される | E-01 (Error.h:369-372行目) | ○ |
| C-019 | Expected::operator bool()が成功時true | E-01 (Error.h:426-429行目) | ○ |
| C-020 | Expected::operator bool()が失敗時false | E-01 (Error.h:426-429行目) | ○ |
| C-021 | Expected::operator*()が値取得 | E-01 (Error.h:463-466行目) | ○ |
| C-022 | Expected::operator->()がメンバアクセス | E-01 (Error.h:451-460行目) | ○ |
| C-023 | Expected::takeError()がエラー取得 | E-01 (Error.h:445-448行目) | ○ |
| C-024 | Expected::takeError()が成功時success() | E-01 (Error.h:445-448行目) | ○ |
| C-025 | ExecutorAddr(uint64_t)でアドレス生成 | E-02 (ExecutorAddress.h:73行目) | ○ |
| C-026 | ExecutorAddr::fromPtr()でポインタ変換 | E-02 (ExecutorAddress.h:76-81行目) | ○ |
| C-027 | ExecutorAddr::toPtr()でポインタ取得 | E-02 (ExecutorAddress.h:84-99行目) | ○ |
| C-028 | ExecutorAddr::getValue()で値取得 | E-02 (ExecutorAddress.h:101行目) | ○ |
| C-029 | ExecutorAddr::setValue()で値設定 | E-02 (ExecutorAddress.h:102行目) | ○ |
| C-030 | ExecutorAddr::isNull()がnull判定 | E-02 (ExecutorAddress.h:103行目) | ○ |
| C-031 | ExecutorAddr::isNull()が非null判定 | E-02 (ExecutorAddress.h:103行目) | ○ |
| C-032 | ExecutorAddr::operator==が等価比較 | E-02 (ExecutorAddress.h:107-110行目) | ○ |
| C-033 | ExecutorAddr::operator!=が非等価比較 | E-02 (ExecutorAddress.h:112-115行目) | ○ |
| C-034 | ExecutorAddr::operator<が大小比較 | E-02 (ExecutorAddress.h:117-120行目) | ○ |
| C-035 | ExecutorAddr::operator++がインクリメント | E-02 (ExecutorAddress.h:137-150行目) | ○ |
| C-036 | ExecutorAddr減算で差分計算 | E-02 (ExecutorAddress.h:167-170行目) | ○ |
| C-037 | ExecutorAddr加算でオフセット加算 | E-02 (ExecutorAddress.h:173-182行目) | ○ |
| C-038 | ExecutorAddrRange(Start, End)で範囲生成 | E-02 (ExecutorAddress.h:187-188行目) | ○ |
| C-039 | ExecutorAddrRange(Start, Size)で範囲生成 | E-02 (ExecutorAddress.h:189-191行目) | ○ |
| C-040 | ExecutorAddrRange::empty()が空判定 | E-02 (ExecutorAddress.h:193行目) | ○ |
| C-041 | ExecutorAddrRange::size()がサイズ取得 | E-02 (ExecutorAddress.h:194行目) | ○ |
| C-042 | ExecutorAddrRange::contains(Addr)が包含判定 | E-02 (ExecutorAddress.h:204-206行目) | ○ |
| C-043 | contains開始境界でtrue | E-02 (ExecutorAddress.h:204-206行目) | ○ |
| C-044 | contains終端境界でfalse | E-02 (ExecutorAddress.h:204-206行目) | ○ |
| C-045 | ExecutorAddrRange::overlaps()が重複判定 | E-02 (ExecutorAddress.h:210-212行目) | ○ |
| C-046 | overlapsが非重複でfalse | E-02 (ExecutorAddress.h:210-212行目) | ○ |
| C-047 | SPSOutputBuffer::write()がデータ書込 | E-03 (SimplePackedSerialization.h:60-67行目) | ○ |
| C-048 | SPSOutputBuffer::write()がオーバーフロー検出 | E-03 (SimplePackedSerialization.h:61-62行目) | ○ |
| C-049 | SPSInputBuffer::read()がデータ読込 | E-03 (SimplePackedSerialization.h:80-87行目) | ○ |
| C-050 | SPSInputBuffer::read()がアンダーフロー検出 | E-03 (SimplePackedSerialization.h:81-82行目) | ○ |
| C-051 | SPSInputBuffer::skip()がスキップ | E-03 (SimplePackedSerialization.h:90-96行目) | ○ |
| C-052 | SPSArgList::size()がサイズ計算 | E-03 (SimplePackedSerialization.h:124-128行目) | ○ |
| C-053 | SPSArgList::serialize()が整数シリアライズ | E-03 (SimplePackedSerialization.h:161-163行目) | ○ |
| C-054 | SPSArgList::deserialize()が整数デシリアライズ | E-03 (SimplePackedSerialization.h:166-172行目) | ○ |
| C-055 | bool型のシリアライズ/デシリアライズ | E-03 (SimplePackedSerialization.h:144-173行目) | ○ |
| C-056 | uint64_t型のシリアライズ/デシリアライズ | E-03 (SimplePackedSerialization.h:144-173行目) | ○ |
| C-057 | std::string型のシリアライズ/デシリアライズ | E-03 (SimplePackedSerialization.h:275-292行目) | ○ |
| C-058 | std::vector<T>型のシリアライズ/デシリアライズ | E-03 (SimplePackedSerialization.h:294-321行目) | ○ |
| C-059 | std::tuple型のシリアライズ/デシリアライズ | E-03 (SimplePackedSerialization.h:413-448行目) | ○ |
| C-060 | std::pair型のシリアライズ/デシリアライズ | E-03 (SimplePackedSerialization.h:451-468行目) | ○ |
| C-061 | std::optional型のシリアライズ/デシリアライズ | E-03 (SimplePackedSerialization.h:471-500行目) | ○ |
| C-062 | ExecutorAddr型のシリアライズ/デシリアライズ | E-03 (SimplePackedSerialization.h:540-557行目) | ○ |
| C-063 | SPSSerializableError生成 | E-03 (SimplePackedSerialization.h:588-602行目) | ○ |
| C-064 | SPSSerializableError::toError()復元 | E-03 (SimplePackedSerialization.h:595-599行目) | ○ |
| C-065 | MemProt OR演算 | E-04 (MemoryFlags.h:26-32行目), E-15 | ○ |
| C-066 | MemProt AND演算 | E-04 (MemoryFlags.h:26-32行目), E-15 | ○ |
| C-067 | AllocGroupコンストラクタ | E-04 (MemoryFlags.h:70-72行目) | ○ |
| C-068 | AllocGroup::getMemProt() | E-04 (MemoryFlags.h:74行目) | ○ |
| C-069 | AllocGroup::getMemLifetime() | E-04 (MemoryFlags.h:76-78行目) | ○ |
| C-070 | AllocGroup::operator== | E-04 (MemoryFlags.h:80-82行目) | ○ |
| C-071 | AllocGroupSmallMap::operator[] | E-04 (MemoryFlags.h:143-148行目) | ○ |
| C-072 | AllocGroupSmallMap::find()存在時 | E-04 (MemoryFlags.h:135-138行目) | ○ |
| C-073 | AllocGroupSmallMap::find()不存在時 | E-04 (MemoryFlags.h:135-138行目) | ○ |
| C-074 | IntervalMapBase::find()範囲内 | E-07 (IntervalMap.h:62-74行目) | ○ |
| C-075 | IntervalMapBase::find()範囲外 | E-07 (IntervalMap.h:62-74行目) | ○ |
| C-076 | IntervalMapBase::lookup()値取得 | E-07 (IntervalMap.h:80-85行目) | ○ |
| C-077 | IntervalMapBase::lookup()デフォルト値 | E-07 (IntervalMap.h:80-85行目) | ○ |
| C-078 | IntervalMapBase::erase()範囲削除 | E-07 (IntervalMap.h:89-118行目) | ○ |
| C-079 | IntervalMap(Coalescing::Enabled)結合 | E-07 (IntervalMap.h:127-153行目) | ○ |
| C-080 | IntervalMap(Coalescing::Disabled)非結合 | E-07 (IntervalMap.h:155-163行目) | ○ |
| C-081 | IntervalSet::insert() | E-08 (IntervalSet.h:81-83行目) | ○ |
| C-082 | IntervalSet::find() | E-08 (IntervalSet.h:79行目) | ○ |
| C-083 | IntervalSet::erase() | E-08 (IntervalSet.h:85行目) | ○ |
| C-084 | Sessionコンストラクタ | E-05 (Session.h:118-121行目) | ○ |
| C-085 | Session::dispatch() | E-05 (Session.h:132行目) | ○ |
| C-086 | Session::reportError() | E-05 (Session.h:135行目) | ○ |
| C-087 | Session::addResourceManager() | E-05 (Session.h:146行目) | ○ |
| C-088 | Session::shutdown() | E-05 (Session.h:140行目) | ○ |
| C-089 | Session::waitForShutdown() | E-05 (Session.h:143行目) | ○ |
| C-090 | Task::run() | E-06 (TaskDispatcher.h:24-28行目) | ○ |
| C-091 | makeGenericTask() | E-06 (TaskDispatcher.h:44-47行目) | ○ |
| C-092 | QueueingTaskDispatcher::dispatch() | E-18 (QueueingTaskDispatcher.h:32行目) | ○ |
| C-093 | QueueingTaskDispatcher::pop_back() | E-18 (QueueingTaskDispatcher.h:37-38行目) | ○ |
| C-094 | QueueingTaskDispatcher::pop_front() | E-18 (QueueingTaskDispatcher.h:41-42行目) | ○ |
| C-095 | QueueingTaskDispatcher::pop_back()空時 | E-18 (QueueingTaskDispatcher.h:37-38行目) | ○ |
| C-096 | QueueingTaskDispatcher::runLIFOUntilEmpty() | E-18 (QueueingTaskDispatcher.h:44行目) | ○ |
| C-097 | QueueingTaskDispatcher::runFIFOUntilEmpty() | E-18 (QueueingTaskDispatcher.h:47行目) | ○ |
| C-098 | QueueingTaskDispatcher::shutdown() | E-18 (QueueingTaskDispatcher.h:33行目) | ○ |
| C-099 | ThreadPoolTaskDispatcherコンストラクタ | E-19 (ThreadPoolTaskDispatcher.h:30行目) | ○ |
| C-100 | ThreadPoolTaskDispatcher::dispatch() | E-19 (ThreadPoolTaskDispatcher.h:32行目) | ○ |
| C-101 | ThreadPoolTaskDispatcher::shutdown() | E-19 (ThreadPoolTaskDispatcher.h:33行目) | ○ |
| C-102 | WrapperFunctionBufferデフォルトコンストラクタ | E-10 (WrapperFunction.h:32行目) | ○ |
| C-103 | WrapperFunctionBuffer::allocate() | E-10 (WrapperFunction.h:80-82行目) | ○ |
| C-104 | WrapperFunctionBuffer::copyFrom() | E-10 (WrapperFunction.h:85-88行目) | ○ |
| C-105 | WrapperFunctionBuffer::release() | E-10 (WrapperFunction.h:58-63行目) | ○ |
| C-106 | WrapperFunctionBuffer::createOutOfBandError() | E-10 (WrapperFunction.h:97-100行目) | ○ |
| C-107 | WrapperFunctionBuffer::getOutOfBandError()エラー時 | E-10 (WrapperFunction.h:104-106行目) | ○ |
| C-108 | WrapperFunctionBuffer::getOutOfBandError()正常時 | E-10 (WrapperFunction.h:104-106行目) | ○ |
| C-109 | WrapperFunctionBuffer::size() | E-10 (WrapperFunction.h:72行目) | ○ |
| C-110 | WrapperFunctionBuffer::empty() | E-10 (WrapperFunction.h:76行目) | ○ |
| C-111 | AllocAction::operator()() | E-09 (AllocAction.h:70-73行目) | ○ |
| C-112 | AllocAction::operator bool()有効時 | E-09 (AllocAction.h:75行目) | ○ |
| C-113 | AllocAction::operator bool()無効時 | E-09 (AllocAction.h:75行目) | ○ |
| C-114 | runFinalizeActions()正常 | E-09 (AllocAction.h:97-98行目) | ○ |
| C-115 | runFinalizeActions()失敗ロールバック | E-09 (AllocAction.h:87-96行目) | ○ |
| C-116 | runDeallocActions() | E-09 (AllocAction.h:101行目) | ○ |
| C-117 | SimpleNativeMemoryMap::reserve() | E-12 (SimpleNativeMemoryMap.h:49行目) | ○ |
| C-118 | SimpleNativeMemoryMap::release() | E-12 (SimpleNativeMemoryMap.h:53行目) | ○ |
| C-119 | SimpleNativeMemoryMap::initialize() | E-12 (SimpleNativeMemoryMap.h:76行目) | ○ |
| C-120 | SimpleNativeMemoryMap::deinitialize() | E-12 (SimpleNativeMemoryMap.h:81行目) | ○ |
| C-121 | RTTIRoot::isA<T>() | E-11 (RTTI.h:78-85行目) | ○ |
| C-122 | RTTIRoot::dynamicClassID() | E-11 (RTTI.h:75行目) | ○ |
| C-123 | RTTIExtends::classID() | E-11 (RTTI.h:124行目) | ○ |
| C-124 | isa<T>() | E-11 (RTTI.h:140-142行目) | ○ |
| C-125 | isPowerOf2()真 | E-13 (Math.h:22-24行目) | ○ |
| C-126 | isPowerOf2()偽 | E-13 (Math.h:22-24行目) | ○ |
| C-127 | isPowerOf2(0) | E-13 (Math.h:22-24行目) | ○ |
| C-128 | nextPowerOf2() | E-13 (Math.h:27-31行目) | ○ |
| C-129 | make_scope_exit() | E-14 (ScopeExit.h:47-50行目) | ○ |
| C-130 | ScopeExitRunner::release() | E-14 (ScopeExit.h:34行目) | ○ |
| C-131 | byteswap 16bit | E-22 (bit.h:64-78行目) | ○ |
| C-132 | byteswap 32bit | E-22 (bit.h:79-91行目) | ○ |
| C-133 | byteswap 64bit | E-22 (bit.h:92-107行目) | ○ |
| C-134 | endian_read() | E-16 (Endian.h:24-31行目) | ○ |
| C-135 | endian_write() | E-16 (Endian.h:34-40行目) | ○ |
| C-136 | countl_zero() | E-22 (bit.h:110-124行目) | ○ |
| C-137 | countl_zero(0) | E-22 (bit.h:112-113行目) | ○ |
| C-138 | bit_width() | E-22 (bit.h:127-129行目) | ○ |
| C-139 | has_single_bit() | E-22 (bit.h:131-134行目) | ○ |
| C-140 | rotl() | E-22 (bit.h:136-147行目) | ○ |
| C-141 | rotr() | E-22 (bit.h:149-160行目) | ○ |
| C-142 | spanコンストラクタ(ptr, count) | E-17 (span.h:45-46行目) | ○ |
| C-143 | spanコンストラクタ(配列) | E-17 (span.h:48-49行目) | ○ |
| C-144 | span::size() | E-17 (span.h:55行目) | ○ |
| C-145 | span::empty() | E-17 (span.h:56行目) | ○ |
| C-146 | span::operator[] | E-17 (span.h:54行目) | ○ |
| C-147 | span::begin()/end() | E-17 (span.h:51-52行目) | ○ |
| C-148 | move_only_functionコンストラクタ | E-21 (move_only_function.h:96-99行目) | ○ |
| C-149 | move_only_function::operator() | E-21 (move_only_function.h:101-103行目) | ○ |
| C-150 | move_only_function::operator bool()有効時 | E-21 (move_only_function.h:105行目) | ○ |
| C-151 | move_only_function::operator bool()null時 | E-21 (move_only_function.h:105行目) | ○ |
| C-152 | move_only_functionムーブ | E-21 (move_only_function.h:91行目) | ○ |
| C-153 | bind_front() | E-23 (bind.h:49-54行目) | ○ |
| C-154 | BoundFn::operator() | E-23 (bind.h:37-40行目) | ○ |
| C-155 | bitmask_enum_mask() | E-15 (BitmaskEnum.h:105-107行目) | ○ |
| C-156 | bitmask_enum_to_underlying() | E-15 (BitmaskEnum.h:109-116行目) | ○ |
| C-157 | operator~(bitmask) | E-15 (BitmaskEnum.h:126-130行目) | ○ |
| C-158 | operator|(bitmask) | E-15 (BitmaskEnum.h:132-136行目) | ○ |
| C-159 | operator&(bitmask) | E-15 (BitmaskEnum.h:138-142行目) | ○ |
| C-160 | operator^(bitmask) | E-15 (BitmaskEnum.h:144-148行目) | ○ |

## 4) 不足情報（Unknown / Missing）
- 根拠なしの項目はありません
- 全テストケースがソースコード内のクラス・メソッド定義に基づいています

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 全テストケースが明確なソースコード根拠を持つ
- 本モジュールはLLVMプロジェクトのORC JIT Runtime実装であり、メモリ安全性と並行性に関する注意が必要
- Error/Expectedパターンは必須チェックが求められるため、テスト漏れがあるとランタイムabortの原因となる

## 6) レビュアーチェックリスト（最小）
- [ ] Error/Expected関連のテストケースが全てのエラー状態遷移をカバーしているか
- [ ] SPSシリアライゼーションの境界値テスト（バッファオーバーフロー/アンダーフロー）が十分か
- [ ] Session/TaskDispatcher関連のスレッドセーフティに関するテストが含まれているか
- [ ] SimpleNativeMemoryMapのメモリ管理に関するリソースリーク検出テストが含まれているか
- [ ] 全てのpublic APIに対してテストケースが存在するか（特にテンプレートメソッド）
- [ ] ムーブセマンティクスに関するテストケースが適切に含まれているか
