---
generated_at: 2026-02-01 12:00:00
metrics:
  claims_total: 100
  claims_with_evidence: 92
  claims_without_evidence: 8
confidence_derived: 0.92
---

# 根拠レポート：polly.csv

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：92 / 100、根拠なし：8
- 優先レビュー（高）
  1. **UT-PLY-088**: runIslScheduleOptimizer - ScheduleOptimizer.hに宣言のみで実装詳細が不明
  2. **UT-PLY-093**: LoopStats構造体 - 内部構造体のため詳細確認困難
  3. **UT-PLY-098**: dumpPw - デバッグ用関数の期待動作が不明確

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `polly/include/polly/ScopDetection.h` - ScopDetectionクラスの定義
- E-02: `polly/include/polly/ScopInfo.h` - ScopArrayInfo, MemoryAccess, Scopクラスの定義
- E-03: `polly/include/polly/ScopBuilder.h` - ScopBuilderクラスの定義
- E-04: `polly/include/polly/DependenceInfo.h` - Dependencesクラスの定義
- E-05: `polly/include/polly/CodeGen/IslAst.h` - IslAst, IslAstInfoクラスの定義
- E-06: `polly/include/polly/CodeGen/BlockGenerators.h` - BlockGenerator, RegionGeneratorクラスの定義
- E-07: `polly/include/polly/ZoneAlgo.h` - ZoneAlgorithmクラスの定義
- E-08: `polly/include/polly/DeLICM.h` - DeLICM関数の宣言
- E-09: `polly/include/polly/FlattenAlgo.h` - flattenSchedule関数の宣言
- E-10: `polly/include/polly/Simplify.h` - Simplify関数の宣言
- E-11: `polly/include/polly/Support/ISLTools.h` - ISLユーティリティ関数群
- E-12: `polly/include/polly/ScheduleTreeTransform.h` - スケジュールツリー変換関数群
- E-13: `polly/include/polly/ScheduleOptimizer.h` - スケジュール最適化関数の宣言

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ScopDetection::isMaxRegionInScop - 有効なScop領域判定 | E-01 L534 | ○ |
| C-02 | ScopDetection::isMaxRegionInScop - 無効領域の判定 | E-01 L534 | ○ |
| C-03 | ScopDetection::isValidRegion - SESE領域検証 | E-01 L353 | ○ |
| C-04 | ScopDetection::isValidRegion - 非構造化CFG検出 | E-01 L353 | ○ |
| C-05 | ScopDetection::isAffine - アフィン式判定 | E-01 L443 | ○ |
| C-06 | ScopDetection::isAffine - 非アフィン式検出 | E-01 L443 | ○ |
| C-07 | ScopDetection::isValidLoop - ループ検証 | E-01 L464 | ○ |
| C-08 | ScopDetection::isValidLoop - 非正規ループ検出 | E-01 L464 | ○ |
| C-09 | ScopDetection::isValidCallInst - 純粋関数許可 | E-01 L365 | ○ |
| C-10 | ScopDetection::isValidCallInst - 副作用拒否 | E-01 L365 | ○ |
| C-11 | ScopDetection::isValidMemoryAccess - アフィンアクセス検証 | E-01 L402 | ○ |
| C-12 | ScopDetection::isValidMemoryAccess - 非アフィンアクセス検出 | E-01 L402 | ○ |
| C-13 | ScopDetection::countBeneficialLoops - ループ統計計算 | E-01 L593 | ○ |
| C-14 | ScopDetection::countBeneficialLoops - 空ループケース | E-01 L593 | ○ |
| C-15 | ScopDetection::isReducibleRegion - 還元可能性判定 | E-01 L501 | ○ |
| C-16 | ScopDetection::isReducibleRegion - 不還元CFG検出 | E-01 L501 | ○ |
| C-17 | ScopDetection::isErrorBlock - エラーブロック検出 | E-01 L612 | ○ |
| C-18 | ScopDetection::isErrorBlock - 通常ブロック判定 | E-01 L612 | ○ |
| C-19 | ScopArrayInfo::getNumberOfDimensions - 次元数取得 | E-02 L275 | ○ |
| C-20 | ScopArrayInfo::getNumberOfDimensions - スカラー次元数 | E-02 L276-278 | ○ |
| C-21 | ScopArrayInfo::getDimensionSize - 次元サイズ取得 | E-02 L287 | ○ |
| C-22 | ScopArrayInfo::getDimensionSize - 境界チェック | E-02 L288 | ○ |
| C-23 | ScopArrayInfo::updateSizes - サイズ更新 | E-02 L255 | ○ |
| C-24 | ScopArrayInfo::updateSizes - 非互換サイズ検出 | E-02 L255 | ○ |
| C-25 | ScopArrayInfo::isCompatibleWith - 互換性チェック | E-02 L376 | ○ |
| C-26 | ScopArrayInfo::isCompatibleWith - 非互換検出 | E-02 L376 | ○ |
| C-27 | MemoryAccess::getAccessRelation - アクセス関係取得 | E-02 | ○ |
| C-28 | MemoryAccess::isRead - 読み取り判定 | E-02 L453 | ○ |
| C-29 | MemoryAccess::isWrite - 書き込み判定 | E-02 L454 | ○ |
| C-30 | MemoryAccess::isMayWrite - 条件付き書き込み判定 | E-02 L455 | ○ |
| C-31 | ScopBuilder::buildScop - Scop構築 | E-03 L78 | ○ |
| C-32 | ScopBuilder::buildDomains - ドメイン計算 | E-03 L94 | ○ |
| C-33 | ScopBuilder::buildConditionSets - 条件セット構築 | E-03 L113 | ○ |
| C-34 | ScopBuilder::buildAccessRelations - アクセス関係構築 | E-03 L667 | ○ |
| C-35 | ScopBuilder::buildAliasGroups - エイリアス解析 | E-03 L385 | ○ |
| C-36 | ScopBuilder::buildSchedule - スケジュール構築 | E-03 L698 | ○ |
| C-37 | ScopBuilder::checkForReductions - リダクション検出 | E-03 L605 | ○ |
| C-38 | ScopBuilder::hoistInvariantLoads - 不変ロードホイスト | E-03 L639 | ○ |
| C-39 | Dependences::getDependences - 依存関係取得 | E-04 L99 | ○ |
| C-40 | Dependences::isParallel - 並列性判定(true) | E-04 L124 | ○ |
| C-41 | Dependences::isParallel - 並列性判定(false) | E-04 L124 | ○ |
| C-42 | Dependences::isValidSchedule - スケジュール検証(true) | E-04 L135 | ○ |
| C-43 | Dependences::isValidSchedule - スケジュール検証(false) | E-04 L135 | ○ |
| C-44 | IslAst::create - AST生成 | E-05 L41 | ○ |
| C-45 | IslAst::getRunCondition - 実行条件取得 | E-05 L48 | ○ |
| C-46 | IslAstInfo::isParallel - 並列ノード判定 | E-05 L137 | ○ |
| C-47 | IslAstInfo::isInnermost - 最内ループ判定 | E-05 L134 | ○ |
| C-48 | IslAstInfo::isReductionParallel - リダクション並列判定 | E-05 L146 | ○ |
| C-49 | BlockGenerator::copyStmt - 文コピー | E-06 L108 | ○ |
| C-50 | BlockGenerator::getOrCreateAlloca - alloca取得 | E-06 L130 | ○ |
| C-51 | BlockGenerator::generateScalarLoads - スカラーロード生成 | E-06 L349 | ○ |
| C-52 | BlockGenerator::generateScalarStores - スカラーストア生成 | E-06 L412 | ○ |
| C-53 | RegionGenerator::copyStmt - 領域コピー | E-06 L652 | ○ |
| C-54 | ZoneAlgorithm::getScatterFor - スケジュール取得 | E-07 L228 | ○ |
| C-55 | ZoneAlgorithm::getDomainFor - ドメイン取得 | E-07 L240 | ○ |
| C-56 | ZoneAlgorithm::getAccessRelationFor - アクセス関係取得 | E-07 L248 | ○ |
| C-57 | ZoneAlgorithm::computeKnown - 既知値計算 | E-07 L398 | ○ |
| C-58 | isConflicting - ライフタイム競合検出(true) | E-08 L32 | ○ |
| C-59 | isConflicting - ライフタイム競合検出(false) | E-08 L32 | ○ |
| C-60 | runDeLICM - DeLICMパス実行 | E-08 L40 | ○ |
| C-61 | flattenSchedule - スケジュール平坦化 | E-09 L34 | ○ |
| C-62 | flattenSchedule - 単一次元ケース | E-09 L34 | ○ |
| C-63 | getAccessesInOrder - アクセス順序取得 | E-10 L37 | ○ |
| C-64 | runSimplify - Simplifyパス実行 | E-10 L39 | ○ |
| C-65 | beforeScatter - 前方スキャッター計算 | E-11 L107 | ○ |
| C-66 | afterScatter - 後方スキャッター計算 | E-11 L121 | ○ |
| C-67 | betweenScatter - 区間スキャッター計算 | E-11 L152 | ○ |
| C-68 | singleton - シングルトン抽出 | E-11 L167 | ○ |
| C-69 | singleton - 空ケース処理 | E-11 L167 | ○ |
| C-70 | getNumScatterDims - スキャッター次元数取得 | E-11 L188 | ○ |
| C-71 | makeIdentityMap - 恒等マップ生成 | E-11 L207 | ○ |
| C-72 | shiftDim - 次元シフト | E-11 L259 | ○ |
| C-73 | simplify - セット簡略化 | E-11 L274 | ○ |
| C-74 | computeReachingWrite - 到達定義計算 | E-11 L338 | ○ |
| C-75 | computeArrayUnused - 未使用区間計算 | E-11 L402 | ○ |
| C-76 | convertZoneToTimepoints - ゾーン変換 | E-11 L452 | ○ |
| C-77 | ScheduleTreeVisitor::visit - ドメイン訪問 | E-12 L34 | ○ |
| C-78 | ScheduleTreeVisitor::visit - バンド訪問 | E-12 L41 | ○ |
| C-79 | hoistExtensionNodes - 拡張ノードホイスト | E-12 L202 | ○ |
| C-80 | applyFullUnroll - 完全アンロール | E-12 L209 | ○ |
| C-81 | applyPartialUnroll - 部分アンロール | E-12 L212 | ○ |
| C-82 | applyMaxFission - ループ分配 | E-12 L215 | ○ |
| C-83 | tileNode - タイリング | E-12 L263 | ○ |
| C-84 | applyRegisterTiling - レジスタタイリング | E-12 L272 | ○ |
| C-85 | applyGreedyFusion - ループ融合 | E-12 L281 | ○ |
| C-86 | getPartialTilePrefixes - 部分タイルプレフィックス | E-12 L235 | ○ |
| C-87 | getIsolateOptions - 分離オプション生成 | E-12 L244 | ○ |
| C-88 | runIslScheduleOptimizer - スケジュール最適化 | E-13 L20 | △ |
| C-89 | runIslAstGen - AST生成実行 | E-05 L166 | ○ |
| C-90 | ArrayShape constructor - 構造体初期化 | E-01 L95 | ○ |
| C-91 | MemAcc constructor - 構造体初期化 | E-01 L107 | ○ |
| C-92 | DetectionContext constructor - コンテキスト初期化 | E-01 L188 | ○ |
| C-93 | LoopStats - ループ統計構造体 | E-01 L193 | △ |
| C-94 | IslAstUserPayload default constructor - ペイロード初期化 | E-05 L76 | ○ |
| C-95 | unsignedFromIslSize - サイズ変換 | E-11 L40 | ○ |
| C-96 | unsignedFromIslSize - エラーサイズ処理 | E-11 L40 | △ |
| C-97 | isl_iterator - ISLイテレータ | E-11 L52 | ○ |
| C-98 | dumpPw - デバッグダンプ | E-11 L589 | △ |
| C-99 | filterKnownValInst - 既知値フィルタ | E-07 L41 | ○ |
| C-100 | makeUnknownForDomain - 不明値マッピング生成 | E-07 L416 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-88 (runIslScheduleOptimizer)**: ScheduleOptimizer.hには関数宣言のみがあり、実装の詳細（Transform/ScheduleOptimizer.cpp）は確認していない
  - 候補：polly/lib/Transform/ScheduleOptimizer.cpp / 実装の確認
- **C-93 (LoopStats)**: 内部構造体のため、使用パターンの詳細確認が困難
  - 候補：countBeneficialLoops関数の実装確認
- **C-96 (unsignedFromIslSize error case)**: エラー時のassert動作は実行時のみ確認可能
  - 候補：ユニットテスト実行による検証
- **C-98 (dumpPw)**: デバッグ用関数であり、出力フォーマットの厳密な仕様が不明
  - 候補：実行による出力確認 / ISLTools.cppの実装確認
- **内部実装の詳細**: .cppファイルの実装は直接確認していないため、一部のテストケースの期待動作は推測に基づく
  - 候補：lib/配下の実装ファイル確認

## 5) リスクフラグ（レビュー観点）
- **0 (低リスク)**: 基本的なAPI（getters/setters、コンストラクタ）- 95件
- **1 (中リスク)**: ISL操作関連（isl::map、isl::setの操作）- 複雑な数学的操作のため、境界ケースに注意 - 3件
- **2 (高リスク)**: スケジュール最適化関連 - 実装詳細が未確認のため - 2件

## 6) レビュアーチェックリスト（最小）
- [ ] ScheduleOptimizer.cppの実装を確認し、UT-PLY-088のテストケースを詳細化する
- [ ] ISL操作関数（beforeScatter, afterScatter等）の境界ケースを追加検討する
- [ ] エラーハンドリング（null入力、空集合等）のテストケースが十分か確認する
- [ ] Dependencesクラスのメモリ管理（releaseMemory）に関するテストケース追加を検討する
- [ ] RegionGeneratorの複雑なPHIノード処理に関するテストケース追加を検討する
- [ ] 実際のpolly/unittests/配下の既存テストと重複がないか確認する
