---
generated_at: 2026-02-01 21:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **CrashReport**：複数テストファイルからの推測であり、実装詳細の確認が必要
  2. **TimeReport**：テストファイルからの推測であり、実装の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `llvm/tools/llvm-cov/CoverageReport.h` - CoverageReportクラス定義
- E-02: `llvm/tools/llvm-cov/CoverageReport.cpp` - CoverageReport実装
- E-03: `llvm/tools/llvm-opt-report/OptReport.cpp` - 最適化レポートツール実装
- E-04: `clang/include/clang/StaticAnalyzer/Core/BugReporter/BugReporter.h` - BugReporterインターフェース
- E-05: `clang/tools/scan-build-py/lib/libscanbuild/report.py` - scan-build HTMLレポート生成
- E-06: `clang-tools-extra/include-cleaner/lib/HTMLReport.cpp` - インクルード解析HTMLレポート
- E-07: `.ci/generate_test_report_lib.py` - テスト結果レポート生成ライブラリ
- E-08: `compiler-rt/lib/asan/asan_report.h` - ASanエラーレポート関数宣言
- E-09: `compiler-rt/lib/msan/msan_report.cpp` - MSanレポート実装
- E-10: `compiler-rt/lib/tsan/rtl/tsan_report.cpp` - TSanレポート実装
- E-11: `compiler-rt/lib/hwasan/hwasan_report.cpp` - HWASanレポート実装
- E-12: `compiler-rt/lib/scudo/standalone/report.cpp` - Scudoレポート実装
- E-13: `flang/examples/FlangOmpReport/FlangOmpReport.cpp` - OpenMPレポートプラグイン
- E-14: `bolt/include/bolt/Passes/ProfileQualityStats.h` - プロファイル品質統計
- E-15: `clang-tools-extra/clangd/support/ThreadCrashReporter.cpp` - スレッドクラッシュレポーター
- E-16: `clang-tools-extra/clang-include-fixer/find-all-symbols/SymbolReporter.h` - シンボルレポーターインターフェース
- E-17: `lld/test/ELF/linkerscript/orphan-report.s` - 孤立セクションレポートテスト
- E-18: `clang/test/Driver/crash-report.cpp` - クラッシュレポートテスト

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CoverageReport - コードカバレッジレポート生成 | E-01, E-02 | ○ |
| C-02 | DirectoryCoverageReport - ディレクトリ別カバレッジ | E-01 | ○ |
| C-03 | OptReport - 最適化レポート（インライン化・アンロール・ベクトル化） | E-03 | ○ |
| C-04 | BugReporter - 静的解析バグレポート | E-04 | ○ |
| C-05 | scan-build HTML Report - HTML形式解析結果 | E-05 | ○ |
| C-06 | SARIF Report - SARIF形式出力 | E-05 | ○ |
| C-07 | HTMLReport (include-cleaner) - インクルード解析 | E-06 | ○ |
| C-08 | Test Report - JUnit XML解析とMarkdown出力 | E-07 | ○ |
| C-09 | ASan Report - AddressSanitizerエラーレポート | E-08 | ○ |
| C-10 | MSan Report - MemorySanitizerレポート | E-09 | ○ |
| C-11 | TSan Report - ThreadSanitizerレポート | E-10 | ○ |
| C-12 | HWASan Report - HardwareAddressSanitizerレポート | E-11 | ○ |
| C-13 | Scudo Report - Scudoアロケータレポート | E-12 | ○ |
| C-14 | FlangOmpReport - OpenMP構文YAML出力 | E-13 | ○ |
| C-15 | CrashReport - コンパイラクラッシュ診断 | E-18 | △ |
| C-16 | ProfileQualityStats - プロファイル品質統計 | E-14 | ○ |
| C-17 | ThreadCrashReporter - clangdスレッドクラッシュ報告 | E-15 | ○ |
| C-18 | TimeReport - コンパイル時間レポート | **根拠なし** | △ |
| C-19 | SymbolReporter - シンボル発見結果報告 | E-16 | ○ |
| C-20 | OrphanReport - 孤立セクションレポート | E-17 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-15 CrashReport**: テストファイル（crash-report.cpp等）は存在するが、実際のクラッシュレポート生成の実装コードは未確認。Clang Driverの実装を詳細に調査する必要がある。
  - 候補：`clang/lib/Driver/Driver.cpp` / `clang/lib/Driver/ToolChains/` / LLVM CrashRecoveryContext

- **C-18 TimeReport**: `-ftime-report`オプションに対応する実装は、LLVM PassManagerおよびTimerクラスに分散している。テストファイルは存在するが、レポート生成の中核実装の確認が必要。
  - 候補：`llvm/lib/IR/PassTimingInfo.cpp` / `llvm/lib/Support/Timer.cpp` / `clang/lib/Frontend/CompilerInstance.cpp`

## 5) リスクフラグ（レビュー観点）
- **1（中リスク）**: CrashReport - 実装詳細の確認が不十分。テストケースからの推測に依存。
- **1（中リスク）**: TimeReport - 分散した実装により、帳票の全容把握が難しい。
- **0（低リスク）**: その他の帳票 - ソースコードを直接確認し、機能が明確。

## 6) レビュアーチェックリスト（最小）
- [ ] CoverageReportの出力形式（テキスト/HTML/JSON）が正確に記述されているか確認
- [ ] SanitizerレポートのOS依存部分（Windows/Linux/Mac）を考慮した記述になっているか確認
- [ ] CrashReportの実装場所を特定し、説明を補完する
- [ ] TimeReportの実装場所を特定し、説明を補完する
- [ ] 帳票の出力形式（テキスト/HTML/YAML/JSON/SARIF等）をより詳細に分類すべきか検討
- [ ] LLVMプロジェクト全体で他に帳票生成機能がないか追加調査
