# 帳票設計書 1-CoverageReport

## 概要

本ドキュメントは、LLVMプロジェクトのコードカバレッジレポート機能（CoverageReport）の設計仕様を記載する。llvm-covツールによるコードカバレッジ測定結果をファイル別・関数別に整形して出力するレポート生成機能である。

### 本帳票の処理概要

CoverageReportは、LLVMのコードカバレッジ測定データを解析し、開発者が理解しやすい形式でレポートを生成するクラスである。

**業務上の目的・背景**：ソフトウェア開発において、テストがコードのどの部分をカバーしているかを把握することは品質保証の観点から極めて重要である。本帳票は、コンパイラやアプリケーションのテストカバレッジを可視化し、テストの網羅性を評価するために必要となる。未カバーのコード領域を特定することで、追加テストの必要性を判断できる。

**帳票の利用シーン**：CI/CDパイプラインでのテストカバレッジ確認、コードレビュー時のテスト網羅性評価、リリース前の品質チェック、開発者のローカル環境でのテスト確認時に利用される。

**主要な出力内容**：
1. ファイル別カバレッジサマリー（リージョン数、関数数、行数、ブランチ数、MC/DC条件数）
2. 関数別カバレッジ詳細（リージョンカバレッジ、行カバレッジ、ブランチカバレッジ）
3. 各メトリクスのカバー率（パーセンテージ表示）
4. 総合計レポート（TOTAL行）
5. 関数を含まないファイルの一覧

**帳票の出力タイミング**：llvm-cov reportコマンドの実行時に出力される。プロファイルデータファイル（.profdata）とカバレッジマッピング情報を持つバイナリを入力として指定する。

**帳票の利用者**：ソフトウェア開発者、QAエンジニア、テストエンジニア、CI/CDシステム管理者

## 帳票種別

集計表 / 一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | `llvm-cov report` | コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力またはファイル） |
| 用紙サイズ | - |
| 向き | - |
| ファイル名 | 指定なし（標準出力）または -o オプションで指定 |
| 出力方法 | 標準出力 / ファイル出力 |
| 文字コード | UTF-8 |

### テキスト出力固有設定

| 項目 | 内容 |
|-----|------|
| カラー出力 | 対応（ターミナル対応時） |
| カラム幅 | 自動調整（最長ファイル名・関数名に合わせる） |
| 区切り線 | ダッシュ（-）で構成 |

## 帳票レイアウト

### レイアウト概要

テキストベースのテーブル形式で、ヘッダー行、データ行、区切り線、合計行で構成される。

```
┌─────────────────────────────────────────────────────────────────┐
│                        ヘッダー行                                │
│  (Filename, Regions, Missed, Cover, Functions, Lines, etc.)     │
├─────────────────────────────────────────────────────────────────┤
│                       区切り線 (---)                             │
├─────────────────────────────────────────────────────────────────┤
│                        データ行                                  │
│  (各ファイルまたは関数のカバレッジ情報)                          │
├─────────────────────────────────────────────────────────────────┤
│                       区切り線 (---)                             │
├─────────────────────────────────────────────────────────────────┤
│                        合計行 (TOTAL)                            │
└─────────────────────────────────────────────────────────────────┘
```

### ヘッダー部（ファイルレポート）

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Filename | ファイル名 | CoverageMapping | 文字列（左寄せ） |
| 2 | Regions | リージョン総数 | RegionCoverageInfo.NumRegions | 整数（右寄せ） |
| 3 | Missed Regions | 未カバーリージョン数 | NumRegions - Covered | 整数（右寄せ） |
| 4 | Cover | リージョンカバー率 | getPercentCovered() | パーセント（右寄せ） |
| 5 | Functions | 関数総数 | FunctionCoverageInfo.NumFunctions | 整数（右寄せ） |
| 6 | Missed Functions | 未実行関数数 | NumFunctions - Executed | 整数（右寄せ） |
| 7 | Executed | 関数実行率 | getPercentCovered() | パーセント（右寄せ） |
| 8 | Lines | 行総数 | LineCoverageInfo.NumLines | 整数（右寄せ） |
| 9 | Missed Lines | 未カバー行数 | NumLines - Covered | 整数（右寄せ） |
| 10 | Cover | 行カバー率 | getPercentCovered() | パーセント（右寄せ） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | ファイル/関数名 | 対象名 | FileCoverageSummary.Name | 文字列 | 可変（最小25） |
| 2-4 | リージョン情報 | リージョンカバレッジ | RegionCoverageInfo | 整数/% | 12/18/10 |
| 5-7 | 関数情報 | 関数カバレッジ | FunctionCoverageInfo | 整数/% | 12/18/10 |
| 8-10 | 行情報 | 行カバレッジ | LineCoverageInfo | 整数/% | 16/16/10 |

### フッター部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | TOTAL | 全ファイル合計 | FileCoverageSummary（累積） | 各カラム合計値 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| プロファイルデータ | .profdataファイル | Yes |
| バイナリ | カバレッジマッピング付きバイナリ | Yes |
| ソースファイルフィルタ | 特定ファイルのみ表示 | No |
| 関数フィルタ | 特定関数のみ表示 | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | ファイルパス | 昇順（アルファベット順） |

### 改ページ条件

テキスト出力のため改ページなし

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを使用せず、バイナリファイル内のカバレッジマッピング情報とプロファイルデータを参照する。

| データソース | 用途 | 取得方法 |
|-------------|------|---------|
| CoverageMapping | カバレッジマッピング情報 | coverage::CoverageMapping::load() |
| プロファイルデータ | 実行カウント情報 | IndexedInstrProfReader |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| リージョンカバー率 | Covered / NumRegions * 100.0 | 小数点2桁 | 0除算時は0.0 |
| 関数実行率 | Executed / NumFunctions * 100.0 | 小数点2桁 | 0除算時は0.0 |
| 行カバー率 | Covered / NumLines * 100.0 | 小数点2桁 | 0除算時は0.0 |
| ブランチカバー率 | Covered / NumBranches * 100.0 | 小数点2桁 | 0除算時は0.0 |
| MC/DCカバー率 | CoveredPairs / NumPairs * 100.0 | 小数点2桁 | 0除算時は0.0 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[llvm-cov report実行] --> B[カバレッジデータ読込]
    B --> C[ソースファイル一覧取得]
    C --> D[フィルタ適用]
    D --> E[ファイル別レポート準備]
    E --> F{マルチスレッド処理}
    F --> G[各ファイルのサマリー計算]
    G --> H[合計値計算]
    H --> I[カラム幅調整]
    I --> J[ヘッダー出力]
    J --> K[区切り線出力]
    K --> L[各ファイル行出力]
    L --> M[区切り線出力]
    M --> N[合計行出力]
    N --> O[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ファイル読込エラー | プロファイルデータ不正 | error: Failed to load coverage | ファイル確認 |
| データなし | カバレッジ情報なし | (空の出力) | バイナリ再確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数千ファイル |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | マルチスレッド対応（NumThreadsオプション） |

## セキュリティ考慮事項

- ローカルファイルアクセスのみ
- 機密性の高いソースコードパスが出力に含まれる可能性あり

## 備考

- カラー出力はターミナル対応時のみ有効
- カバー率80%以上で黄色、100%で緑色、80%未満で赤色表示

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、カバレッジサマリー情報を保持するデータ構造を理解することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | CoverageSummaryInfo.h | `llvm/tools/llvm-cov/CoverageSummaryInfo.h` | RegionCoverageInfo, LineCoverageInfo, BranchCoverageInfo, FunctionCoverageInfo, FileCoverageSummaryの構造を理解 |

**読解のコツ**: 各Info系クラスはCovered/Totalのペアを保持し、getPercentCovered()でカバー率を計算する。FileCoverageSummaryが最終的な集計単位となる。

#### Step 2: エントリーポイントを理解する

処理の起点となるファイル・関数を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | CoverageReport.h | `llvm/tools/llvm-cov/CoverageReport.h` | CoverageReportクラスのpublicインターフェースを確認 |

**主要処理フロー**:
1. **行35-37**: コンストラクタでOptions, Coverageを受け取る
2. **行39-40**: renderFunctionReports()で関数レベルレポート出力
3. **行58-73**: renderFileReports()でファイルレベルレポート出力

#### Step 3: レポート生成処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | CoverageReport.cpp | `llvm/tools/llvm-cov/CoverageReport.cpp` | render(), prepareFileReports(), renderFileReports()の実装詳細 |

**主要処理フロー**:
- **行89-91**: FileReportColumns配列でカラム幅定義
- **行218-330**: render(FileCoverageSummary)でファイル行出力
- **行332-390**: render(FunctionCoverageSummary)で関数行出力
- **行474-503**: prepareFileReports()でマルチスレッドサマリー計算
- **行530-590**: renderFileReports()でテーブル形式出力

### プログラム呼び出し階層図

```
llvm-cov report (コマンド)
    │
    ├─ CoverageReport::renderFileReports()
    │      ├─ CoverageReport::prepareFileReports()
    │      │      ├─ ThreadPool::async()
    │      │      └─ CoverageReport::prepareSingleFileReport()
    │      │             └─ FunctionCoverageSummary::get()
    │      │
    │      ├─ adjustColumnWidths()
    │      ├─ renderDivider()
    │      └─ render(FileCoverageSummary)
    │             └─ determineCoveragePercentageColor()
    │
    └─ CoverageReport::renderFunctionReports()
           └─ render(FunctionCoverageSummary)
```

### データフロー図

```
[入力]                      [処理]                           [出力]

.profdata ────────┐
                  │
Binary with       ├──▶ CoverageMapping::load() ──▶ CoverageMapping
coverage mapping ─┘           │
                              │
                              ▼
                    prepareFileReports()
                              │
                    ┌─────────┴─────────┐
                    ▼                   ▼
          prepareSingleFileReport() (Thread 1...N)
                    │
                    ▼
            FileCoverageSummary[]
                    │
                    ▼
            renderFileReports()
                    │
                    ▼
              [標準出力/ファイル]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| CoverageReport.h | `llvm/tools/llvm-cov/CoverageReport.h` | ヘッダ | CoverageReport, DirectoryCoverageReportクラス定義 |
| CoverageReport.cpp | `llvm/tools/llvm-cov/CoverageReport.cpp` | ソース | レポート生成の主要実装 |
| CoverageSummaryInfo.h | `llvm/tools/llvm-cov/CoverageSummaryInfo.h` | ヘッダ | カバレッジサマリー情報構造体定義 |
| CoverageViewOptions.h | `llvm/tools/llvm-cov/CoverageViewOptions.h` | ヘッダ | 表示オプション定義 |
| CoverageFilters.h | `llvm/tools/llvm-cov/CoverageFilters.h` | ヘッダ | ファイル/関数フィルタ定義 |
| RenderingSupport.h | `llvm/tools/llvm-cov/RenderingSupport.h` | ヘッダ | 出力ヘルパー関数 |
