# 帳票設計書 10-MSan Report

## 概要

本ドキュメントは、MemorySanitizer（MSan）のエラーレポート機能の設計仕様を記載する。未初期化メモリ使用の検出レポートを生成する。

### 本帳票の処理概要

MSan Reportは、MemorySanitizerランタイムが未初期化メモリの使用を検出した際に、エラーの発生位置、未初期化値の起源（Origin）、スタックトレース、シャドウメモリの状態などの詳細情報を出力する機能である。

**業務上の目的・背景**：C/C++プログラムでの未初期化メモリの使用は、予測不能な動作やセキュリティ脆弱性の原因となる。MemorySanitizerは実行時に未初期化メモリの使用を検出し、その起源を追跡する。本機能は、検出したエラーを開発者が理解・修正できるよう、未初期化値がどこで作成され、どのように伝播したかを報告する。Origin追跡により、問題の根本原因を特定できる。

**帳票の利用シーン**：開発中のテスト実行時、CI/CDパイプラインでのサニタイザーテスト、セキュリティ監査、未初期化メモリバグの調査時に利用される。

**主要な出力内容**：
1. 警告メッセージ（use-of-uninitialized-value）
2. エラー発生位置のスタックトレース
3. 未初期化値の起源（Origin）情報
4. 起源のチェーン（値の伝播経路）
5. シャドウメモリの状態表示
6. 統計情報（オプション）

**帳票の出力タイミング**：MSan有効でコンパイルされたプログラム実行中に、未初期化メモリの使用が検出された瞬間に標準エラー出力に出力される。

**帳票の利用者**：ソフトウェア開発者、セキュリティエンジニア、QAエンジニア、DevSecOpsエンジニア

## 帳票種別

ランタイム警告レポート（標準エラー出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル | stderr | エラー検出時自動出力 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（stderr） |
| 用紙サイズ | - |
| 向き | - |
| ファイル名 | - |
| 出力方法 | 標準エラー出力 |
| 文字コード | UTF-8 |

### 出力固有設定

| 項目 | 内容 |
|-----|------|
| カラー出力 | サポート（Decorator） |
| Origin色 | マゼンタ |
| Name色 | グリーン |

## 帳票レイアウト

### レイアウト概要

エラーレポートは以下の構造で出力される。

```
WARNING: MemorySanitizer: use-of-uninitialized-value
    {Stack Trace}
  Uninitialized value was created by {origin_type}
    {Origin Stack Trace}
  Uninitialized value was stored to memory at
    {Store Stack Trace}
  ...

SUMMARY: MemorySanitizer: use-of-uninitialized-value {location}
```

### 警告種別一覧

| 警告種別 | 関数名 | 説明 |
|---------|--------|------|
| use-of-uninitialized-value | ReportUMR | 未初期化値使用 |
| expected UMR not found | ReportExpectedUMRNotFound | 期待したUMRなし |

### 警告情報

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Warning Type | 警告種別 | - | "use-of-uninitialized-value" |
| 2 | Stack Trace | 検出位置 | stack引数 | スタックトレース |
| 3 | Origin ID | 起源ID（デバッグ用） | origin引数 | 16進数 |

### Origin情報

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Origin Type | 起源種別 | Origin::kind | スタック/ヒープ |
| 2 | Variable Name | 変数名（スタック） | GetStackOriginDescr | 文字列 |
| 3 | Allocation Type | 割当種別（ヒープ） | stack.tag | alloc/dealloc/poison等 |
| 4 | Origin Stack | 起源位置 | StackTrace | スタックトレース |
| 5 | Chained Origins | 伝播チェーン | getNextChainedOrigin | スタックトレース列 |

### シャドウメモリ表示

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Shadow Map | シャドウメモリ範囲 | start-end | "[addr, addr)" |
| 2 | Memory Range | 対象メモリ範囲 | x-size | "[addr, size)" |
| 3 | Shadow Bytes | シャドウバイト値 | MEM_TO_SHADOW | 16進数ダンプ |
| 4 | Origin IDs | 起源ID対応 | OriginSet | A-Z文字 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 未初期化値使用検出 | MSanがUMRを検出 | Yes |
| report_umrs | UMR報告有効フラグ | Yes（デフォルトtrue） |

### 出力制御

| オプション | 説明 | デフォルト |
|-----------|------|-----------|
| report_umrs | UMR報告を有効化 | true |
| track_origins | Origin追跡を有効化 | 0（無効）/1/2 |
| verbosity | 詳細度 | 0 |

## データベース参照仕様

### 参照データソース一覧

| データソース | 用途 | 取得方法 |
|-------------|------|---------|
| シャドウメモリ | 初期化状態 | MEM_TO_SHADOW() |
| Originメモリ | 起源情報 | SHADOW_TO_ORIGIN() |
| ChainedOriginDepot | チェーン起源 | ChainedOriginDepotGetStats() |
| StackDepot | スタック履歴 | StackDepotGetStats() |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Shadow Address | MEM_TO_SHADOW(x) | - | シャドウアドレス |
| Origin Address | SHADOW_TO_ORIGIN(s) | - | 起源アドレス |
| Origin Scan Range | (s & ~3UL) to (s + size + 15) & ~15UL | - | スキャン範囲 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[未初期化値使用検出] --> B{report_umrs?}
    B -->|No| Z[終了]
    B -->|Yes| C[ScopedErrorReportLock取得]
    C --> D[WARNING出力]
    D --> E[スタックトレース出力]
    E --> F{origin != 0?}
    F -->|Yes| G[DescribeOrigin]
    F -->|No| H[ReportErrorSummary]
    G --> I{isChainedOrigin?}
    I -->|Yes| J[チェーン起源出力]
    J --> K[getNextChainedOrigin]
    K --> I
    I -->|No| L{isStackOrigin?}
    L -->|Yes| M[DescribeStackOrigin]
    L -->|No| N[ヒープ起源出力]
    M --> H
    N --> H
    H --> Z
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 期待UMRなし | expect_umr=true時にUMRなし | "Expected use of uninitialized value not found" | テスト失敗 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 複数警告 |
| 目標出力時間 | 即時 |
| 同時出力数上限 | 1（ロック） |

## セキュリティ考慮事項

- メモリアドレスがレポートに含まれる
- スタックトレースにソースパスが含まれる
- 変数名がレポートに含まれる可能性

## 備考

- Origin追跡レベル（track_origins）で情報量が変化
  - 0: Origin追跡なし
  - 1: 割り当て時のみ追跡
  - 2: 値の伝播も追跡（チェーン起源）
- DescribeMemoryRange()でシャドウメモリの詳細ダンプ
- OriginSetでA-Z文字による起源識別

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | msan_report.h | `compiler-rt/lib/msan/msan_report.h` | レポート関数宣言（行23-29）を確認 |

**読解のコツ**: ReportUMR()がメイン関数、DescribeMemoryRange()が詳細ダンプ。

#### Step 2: メインレポート関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | msan_report.cpp | `compiler-rt/lib/msan/msan_report.cpp` | ReportUMR()関数（行106-120） |

**主要処理フロー**:
- **行107**: report_umrsフラグチェック
- **行109**: ScopedErrorReportLock取得
- **行113**: WARNING出力
- **行115**: スタックトレース出力
- **行116-118**: Origin出力（存在時）
- **行119**: ReportErrorSummary

#### Step 3: Origin説明を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | msan_report.cpp | 同上 | DescribeOrigin()関数（行56-104） |

**主要処理フロー**:
- **行59**: Origin::FromRawId()でOriginオブジェクト取得
- **行60-66**: チェーン起源のループ処理
- **行67-70**: スタック起源の処理
- **行71-103**: ヒープ起源の処理（tag判定）

#### Step 4: シャドウメモリ表示を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | msan_report.cpp | 同上 | DescribeMemoryRange()関数（行191-272） |

**主要処理フロー**:
- **行193-199**: スキャン範囲計算
- **行210-263**: 16バイト単位でのダンプループ
- **行267-271**: Origin説明出力

### プログラム呼び出し階層図

```
ReportUMR()
    │
    ├─ flags()->report_umrs チェック
    │
    ├─ ScopedErrorReportLock
    │
    ├─ Printf("WARNING: MemorySanitizer...")
    │
    ├─ stack->Print()
    │
    ├─ DescribeOrigin() [origin != 0時]
    │      │
    │      ├─ Origin::FromRawId()
    │      │
    │      ├─ [チェーン起源ループ]
    │      │      ├─ getNextChainedOrigin()
    │      │      └─ stack.Print()
    │      │
    │      ├─ DescribeStackOrigin() [スタック起源]
    │      │      └─ GetStackOriginDescr()
    │      │
    │      └─ [ヒープ起源]
    │             └─ getStackTraceForHeapOrigin()
    │
    └─ ReportErrorSummary()
```

### データフロー図

```
[入力]                      [処理]                           [出力]

StackTrace* ─────────▶ ReportUMR()
                            │
u32 origin ─────────────▶  │
                            │
                            ▼
                   ScopedErrorReportLock
                            │
                    ┌───────┴───────┐
                    ▼               ▼
              stack->Print()   DescribeOrigin()
                    │               │
                    │         ┌─────┴─────┐
                    │         ▼           ▼
                    │    Chained      Stack/Heap
                    │    Origins      Origin
                    │         │           │
                    └────┬────┴───────────┘
                         │
                         ▼
                  [stderr出力]
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| msan_report.h | `compiler-rt/lib/msan/msan_report.h` | ヘッダ | レポート関数宣言 |
| msan_report.cpp | `compiler-rt/lib/msan/msan_report.cpp` | ソース | レポート関数実装 |
| msan_origin.h | `compiler-rt/lib/msan/msan_origin.h` | ヘッダ | Origin構造体 |
| msan_chained_origin_depot.h | `compiler-rt/lib/msan/msan_chained_origin_depot.h` | ヘッダ | チェーン起源管理 |
| msan.h | `compiler-rt/lib/msan/msan.h` | ヘッダ | MSanメイン定義 |
| sanitizer_report_decorator.h | `compiler-rt/lib/sanitizer_common/sanitizer_report_decorator.h` | ヘッダ | 装飾出力 |
