# 帳票設計書 13-Scudo Report

## 概要

本ドキュメントは、Scudoアロケータによるメモリアロケーション関連エラーレポートの設計仕様を定義する。Scudoはセキュリティ強化されたメモリアロケータであり、ヒープの整合性チェックやエラー検出機能を備えている。

### 本帳票の処理概要

Scudo Reportは、メモリアロケーション操作中に検出された各種エラー（ヘッダー破損、不正なポインタ、メモリ不足等）を報告し、プログラムを安全に終了させる致命的エラーレポートである。

**業務上の目的・背景**：ヒープメモリの破損やダブルフリー等のメモリ管理エラーは、セキュリティ脆弱性やプログラムクラッシュの原因となる。Scudoはこれらの問題を実行時に検出し、攻撃者による悪用を防止するとともに、開発者にエラーの詳細を報告することで問題の早期発見・修正を支援する。

**帳票の利用シーン**：Scudoをメモリアロケータとして使用するプログラム（Android、Fuchsia等）において、メモリ管理エラーが検出された際に自動的にレポートが生成される。セキュリティテストや品質検査での活用が想定される。

**主要な出力内容**：
1. エラー種別（ヘッダー破損、不正チャンク状態、型不一致等）
2. エラー発生時のポインタアドレス
3. 操作種別（deallocating, reallocating, recycling, sizing）
4. 追加のコンテキスト情報（サイズ、アラインメント等）
5. 致命的エラーとしてのプログラム終了

**帳票の出力タイミング**：Scudoがエラーを検出した時点で即座に出力され、その後プログラムは`Die()`関数により終了する（全てのエラーが致命的）。

**帳票の利用者**：システムプログラマー、セキュリティエンジニア、OSカーネル開発者

## 帳票種別

致命的エラーレポート / セキュリティ診断レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コンソール/ターミナル | N/A | メモリエラー検出時に自動出力 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準エラー出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準エラー出力） |
| 出力方法 | outputRaw関数 / setAbortMessage |
| 文字コード | システムロケール依存 |

### コンソール出力設定

| 項目 | 内容 |
|-----|------|
| プレフィックス | `Scudo ERROR: ` |
| カラー出力 | 無 |
| 終端処理 | 改行自動付加（一部関数） |

## 帳票レイアウト

### レイアウト概要

Scudo Reportは致命的エラー発生時に1行のエラーメッセージを出力する。

```
Scudo ERROR: {エラーメッセージ}
```

### エラーメッセージ形式

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | プレフィックス | 固定文字列 | ScopedErrorReport | `Scudo ERROR: ` |
| 2 | エラー内容 | エラー種別に応じたメッセージ | 各report関数 | エラー固有 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Scudo使用 | Scudoアロケータがリンクされている | Yes |
| エラー検出 | メモリ操作中にエラーが検出された | Yes |

### ソート順

N/A（単一エラーメッセージ）

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを使用しない。

| データソース | 用途 | 取得方法 |
|-------------|------|---------|
| チャンクヘッダー | 整合性検証 | ポインタ演算 |
| アロケータ設定 | サイズ制限等 | 静的設定 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| - | - | - | 計算項目なし |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[メモリ操作] --> B{整合性チェック}
    B -->|OK| C[正常継続]
    B -->|NG| D[ScopedErrorReport生成]
    D --> E[エラーメッセージ構築]
    E --> F[outputRaw出力]
    F --> G[setAbortMessage]
    G --> H[Die]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| CHECK失敗 | 内部整合性チェック失敗 | `CHECK failed @ {file}:{line} {condition}` | 内部エラー、開発者へ報告 |
| 一般エラー | 汎用エラー | `{message}\n` | メッセージ内容に従う |
| 無効なフラグ | フラグ値が不正 | `invalid value for {FlagType} option: '{Value}'` | 正しい値を指定 |
| ヘッダー破損 | チャンクヘッダーのチェックサム不正 | `corrupted chunk header at address {Ptr}` | メモリ破損の調査 |
| ゼロヘッダー | ヘッダーが全てゼロ | `...chunk header is zero and might indicate memory corruption or a double free` | ダブルフリーの確認 |
| サニティチェック | フィールドサイズ超過 | `maximum possible {Field} doesn't fit in header` | コンパイル設定の確認 |
| アラインメント過大 | アラインメントが最大値超過 | `invalid allocation alignment: {Alignment} exceeds maximum supported alignment of {MaxAlignment}` | アラインメント値の修正 |
| サイズ過大 | 割り当てサイズが最大値超過 | `requested allocation size {UserSize} ({TotalSize} after adjustments) exceeds maximum supported size of {MaxSize}` | サイズの削減 |
| BatchClass枯渇 | フリーリスト管理領域の枯渇 | `BatchClass region is used up, can't hold any free block` | メモリ使用量の削減 |
| メモリ不足 | メモリ割り当て失敗 | `out of memory trying to allocate {RequestedSize} bytes` | メモリの解放 |
| 無効なチャンク状態 | チャンクが不正な状態 | `invalid chunk state when {Action} address {Ptr}` | ダブルフリー等の確認 |
| 不整列ポインタ | ポインタが正しく整列していない | `misaligned pointer when {Action} address {Ptr}` | ポインタの確認 |
| 型不一致 | 割り当てと解放の型が不一致 | `allocation type mismatch when {Action} address {Ptr} ({TypeA} vs {TypeB})` | new/delete対応の確認 |
| サイズ不一致 | deleteのサイズが割り当てと不一致 | `invalid sized delete when deallocating address {Ptr} ({Size} vs {ExpectedSize})` | sized deleteの確認 |
| 2のべき乗でない | アラインメントが2のべき乗でない | `invalid allocation alignment: {Alignment}, alignment must be a power of two` | アラインメント値の修正 |
| callocオーバーフロー | count * sizeがオーバーフロー | `calloc parameters overflow: count * size ({Count} * {Size}) cannot be represented with type size_t` | サイズの削減 |
| posix_memalign不正 | posix_memalignのアラインメント不正 | `invalid alignment requested in posix_memalign: {Alignment}...` | アラインメント値の修正 |
| pvallocオーバーフロー | ページサイズへの丸めでオーバーフロー | `pvalloc parameters overflow: size {Size} rounded up to system page size {PageSize}...` | サイズの削減 |
| aligned_alloc不正 | サイズがアラインメントの倍数でない | `invalid alignment requested in aligned_alloc: {Alignment}...` | サイズ/アラインメントの修正 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | エラー検出ごとに1レポート |
| 目標出力時間 | 即座（マイクロ秒単位） |
| 同時出力数上限 | 1（致命的エラーにより終了） |

## セキュリティ考慮事項

- エラーレポートにはメモリアドレスが含まれる（ASLR情報漏洩の可能性）
- 全てのエラーが致命的エラーとして処理される（攻撃の継続を防止）
- setAbortMessageにより終了時の診断情報を提供

## 備考

- Scudoは全てのエラーを致命的として扱い、`NORETURN`属性が付与されている
- ScopedErrorReportクラスのデストラクタでDie()が呼ばれる
- 再帰呼び出し防止のためatomic_u32によるカウンタを使用
- AllocatorAction列挙型で操作種別を区別（Recycling, Deallocating, Reallocating, Sizing）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

まず、レポート出力に使用されるデータ構造を把握することが重要である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | report.h | `compiler-rt/lib/scudo/standalone/report.h` | 全ての報告関数の宣言を確認。全て`NORETURN`属性付き |
| 1-2 | report.h | `compiler-rt/lib/scudo/standalone/report.h` | AllocatorAction列挙型（38-43行目）の4種類の操作種別 |

**読解のコツ**:
- 全関数が`NORETURN`であることに注意（致命的エラーのみ）
- AllocatorActionは操作種別を示す列挙型

#### Step 2: エントリーポイントを理解する

処理の起点となる関数群を特定する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | report.cpp | `compiler-rt/lib/scudo/standalone/report.cpp` | ScopedErrorReportクラス（19-32行目）がレポートの基盤 |
| 2-2 | report.cpp | `compiler-rt/lib/scudo/standalone/report.cpp` | reportRawError（56-60行目）が最終出力関数 |

**主要処理フロー**:
1. **19-21行目**: ScopedErrorReportコンストラクタでプレフィックス追加
2. **22-27行目**: append()でメッセージを構築
3. **28行目**: デストラクタでreportRawErrorを呼び出し

#### Step 3: 各エラー報告関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | report.cpp | `compiler-rt/lib/scudo/standalone/report.cpp` | reportCheckFailed（37-47行目）：内部CHECKマクロ用 |
| 3-2 | report.cpp | `compiler-rt/lib/scudo/standalone/report.cpp` | reportHeaderCorruption（69-80行目）：ヘッダー破損検出 |
| 3-3 | report.cpp | `compiler-rt/lib/scudo/standalone/report.cpp` | reportInvalidChunkState（133-137行目）：無効なチャンク状態 |
| 3-4 | report.cpp | `compiler-rt/lib/scudo/standalone/report.cpp` | reportDeallocTypeMismatch（147-152行目）：型不一致 |

**主要処理フロー**:
- **117-129行目**: stringifyAction()でAllocatorActionを文字列変換
- **69-80行目**: ヘッダーがゼロの場合の特別なメッセージ分岐

### プログラム呼び出し階層図

```
report*関数群
    │
    └─ ScopedErrorReport (report.cpp:19)
           │
           ├─ コンストラクタ
           │      └─ Message.append("Scudo ERROR: ")
           │
           ├─ append (report.cpp:22)
           │      └─ Message.vappend(Format, Args)
           │
           └─ デストラクタ (report.cpp:28)
                  └─ reportRawError (report.cpp:56)
                         ├─ outputRaw
                         ├─ setAbortMessage
                         └─ die
```

### データフロー図

```
[入力]                    [処理]                         [出力]

エラー検出 ──────────▶ ScopedErrorReport生成 ───────┐
                            │                        │
パラメータ ──────────▶ Message.append() ────────────┤
                            │                        ▼
                            └─────────────────▶ outputRaw ──▶ stderr
                                                     │
                                               setAbortMessage
                                                     │
                                                   die()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| report.h | `compiler-rt/lib/scudo/standalone/report.h` | ヘッダー | エラー報告関数宣言 |
| report.cpp | `compiler-rt/lib/scudo/standalone/report.cpp` | ソース | エラー報告関数実装 |
| chunk.h | `compiler-rt/lib/scudo/standalone/chunk.h` | ヘッダー | チャンクヘッダー定義 |
| string_utils.h | `compiler-rt/lib/scudo/standalone/string_utils.h` | ヘッダー | 文字列操作ユーティリティ |
| internal_defs.h | `compiler-rt/lib/scudo/standalone/internal_defs.h` | ヘッダー | 内部定義（NORETURN等） |
| atomic_helpers.h | `compiler-rt/lib/scudo/standalone/atomic_helpers.h` | ヘッダー | アトミック操作 |
