# 帳票設計書 15-CrashReport

## 概要

本ドキュメントは、Clangコンパイラがクラッシュした際に生成される診断情報レポートの設計仕様を定義する。CrashReportは、コンパイラのバグ報告を容易にするための情報を収集し、再現可能な形式で出力する。

### 本帳票の処理概要

CrashReportは、Clangコンパイラが内部エラーやシグナル（SIGSEGV等）によりクラッシュした際に、問題の再現と診断に必要な情報を収集・出力するレポートである。

**業務上の目的・背景**：コンパイラのクラッシュは開発者の生産性に深刻な影響を与える。CrashReportは、クラッシュの原因究明に必要な情報（前処理済みソース、コンパイルオプション、バージョン情報等）を自動的に収集し、開発者やコンパイラメンテナーがバグを効率的に報告・修正できるよう支援する。

**帳票の利用シーン**：
- Clangコンパイラがセグメンテーションフォルト等でクラッシュした際
- 内部エラー（ICE: Internal Compiler Error）が発生した際
- バグ報告チケット作成時の添付資料として

**主要な出力内容**：
1. 前処理済みソースファイル（.i/.ii/.mi/.mii）
2. 再現用スクリプト（.sh）
3. コンパイラバージョン情報
4. コンパイルオプション
5. ターゲット情報

**帳票の出力タイミング**：コンパイラがクラッシュした時点で自動的に生成。`-fcrash-diagnostics`オプションで制御可能。

**帳票の利用者**：C/C++/Objective-C開発者、コンパイラ開発者、バグ報告者

## 帳票種別

診断レポート / バグ報告支援レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | N/A | クラッシュ時に自動出力 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 前処理済みソース + シェルスクリプト |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | `{入力ファイル名}-{ハッシュ}.{i/ii/mi/mii}`, `{入力ファイル名}-{ハッシュ}.sh` |
| 出力方法 | 一時ディレクトリへのファイル出力 |
| 文字コード | ソースファイルに依存 |

### 出力ファイル種別

| 拡張子 | 説明 |
|-------|------|
| .i | C前処理済みソース |
| .ii | C++前処理済みソース |
| .mi | Objective-C前処理済みソース |
| .mii | Objective-C++前処理済みソース |
| .sh | 再現用シェルスクリプト |

## 帳票レイアウト

### 標準エラー出力

クラッシュ時に以下の形式でメッセージが出力される。

```
PLEASE submit a bug report to {バグ報告URL} and include the crash backtrace, preprocessed source, and associated run script.
Stack dump:
{スタックトレース}

********************

PLEASE ATTACH THE FOLLOWING FILES TO THE BUG REPORT:
Preprocessed source(s) and associated run script(s) are located at:
clang: note: diagnostic msg: {前処理済みソースパス}
clang: note: diagnostic msg: {スクリプトパス}

********************
```

### 再現スクリプト内容

```bash
# Crash reproducer for {コンパイラ}
# Driver args: {元のドライバ引数}
# Original command: {元のコマンド}

{コンパイラパス} "-cc1" {cc1オプション...} "{前処理済みソースパス}"
```

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| クラッシュ発生 | シグナルまたは内部エラー | Yes |
| 診断有効 | `-fcrash-diagnostics=always`または`-fcrash-diagnostics=compiler`（デフォルト） | Yes |

### ソート順

N/A

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを使用しない。

| データソース | 用途 | 取得方法 |
|-------------|------|---------|
| コンパイルコマンド | 再現情報 | Driver内部状態 |
| ソースファイル | 前処理対象 | InputFile |
| プリプロセッサ状態 | 前処理済みソース生成 | Preprocessor |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ファイルハッシュ | 一意性確保用 | N/A | 衝突回避 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[コンパイル開始] --> B{クラッシュ?}
    B -->|No| C[正常終了]
    B -->|Yes| D[シグナルハンドラ起動]
    D --> E[前処理済みソース生成]
    E --> F[再現スクリプト生成]
    F --> G[一時ディレクトリに出力]
    G --> H[標準エラーにパス出力]
    H --> I[終了]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| ファイル書き込み失敗 | 一時ディレクトリアクセス不可 | (診断ファイル生成スキップ) | 一時ディレクトリの権限確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | クラッシュごとに1セット |
| 目標出力時間 | 前処理時間に依存 |
| 同時出力数上限 | 1 |

## セキュリティ考慮事項

- 前処理済みソースには全てのインクルードファイルが展開される
- マクロ定義にはセキュリティ関連情報が含まれる可能性がある
- 再現スクリプトにはファイルパスが含まれる

## 備考

- `-fcrash-diagnostics=off`で無効化可能
- `-fcrash-diagnostics=all`でより詳細な情報を出力
- 前処理済みソースは自己完結型（外部依存なし）
- テストケースとしても使用可能

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: テストケースから動作を理解する

まず、テストケースを参照して期待される動作を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | crash-report.cpp | `clang/test/Driver/crash-report.cpp` | クラッシュレポートのテストケース |

**読解のコツ**:
- RUNディレクティブでオプションの使い方を確認
- CHECKディレクティブで期待される出力形式を確認

#### Step 2: ドライバ実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Driver.cpp | `clang/lib/Driver/Driver.cpp` | クラッシュレポート生成ロジック |

**主要処理フロー**:
- シグナルハンドラでクラッシュを検出
- 前処理済みソースを生成
- 再現スクリプトを作成

### プログラム呼び出し階層図

```
シグナルハンドラ
    │
    ├─ クラッシュ検出
    │
    ├─ 前処理済みソース生成
    │      └─ Preprocessor実行
    │
    ├─ 再現スクリプト生成
    │      └─ cc1オプション収集
    │
    └─ ファイル出力
           ├─ .i/.ii/.mi/.mii
           └─ .sh
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ソースファイル ──────▶ プリプロセッサ ─────────────▶ .i/.ii/.mi/.mii
                            │
コンパイルオプション ──▶ オプション収集 ────────────▶ .sh
                            │
バージョン情報 ──────▶ ヘッダー生成 ─────────────────┘
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| crash-report.cpp | `clang/test/Driver/crash-report.cpp` | テスト | テストケース |
| Driver.cpp | `clang/lib/Driver/Driver.cpp` | ソース | ドライバ実装 |
| Options.td | `clang/include/clang/Driver/Options.td` | 定義 | オプション定義 |
