# 帳票設計書 18-TimeReport (-ftime-report)

## 概要

本ドキュメントは、Clang/Flangコンパイラの`-ftime-report`オプションにより生成されるコンパイル時間レポートの設計仕様を定義する。このレポートは各コンパイルフェーズの所要時間を報告し、コンパイル性能の分析に活用される。

### 本帳票の処理概要

TimeReportは、コンパイラの各処理フェーズ（パース、意味解析、最適化、コード生成等）の実行時間を計測し、コンパイル完了時にサマリーレポートを出力する帳票である。

**業務上の目的・背景**：大規模プロジェクトのビルド時間短縮は開発生産性向上の重要な課題である。TimeReportは、コンパイル時間のボトルネックを特定するための詳細な内訳情報を提供し、ソースコードやビルドシステムの最適化に役立つ情報を提供する。

**帳票の利用シーン**：
- コンパイル時間のプロファイリング
- ビルド時間最適化の分析
- コンパイラ開発時のパフォーマンス計測
- 特定のコンパイラパスの性能問題調査

**主要な出力内容**：
1. 各コンパイラパスの実行時間（ユーザー時間、システム時間、壁時計時間）
2. パスごとのメモリ使用量（オプション）
3. パス呼び出し回数
4. 合計時間と割合

**帳票の出力タイミング**：コンパイル完了時に標準エラー出力へ出力される。

**帳票の利用者**：ビルドエンジニア、コンパイラ開発者、性能エンジニア

## 帳票種別

パフォーマンスレポート / 時間計測レポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | N/A | `clang -ftime-report` または `flang -ftime-report` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準エラー出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準エラー出力） |
| 出力方法 | stderr |
| 文字コード | システムロケール依存 |

### オプション

| オプション | 説明 |
|-----------|------|
| `-ftime-report` | 基本的な時間レポートを有効化 |
| `-ftime-report=per-pass` | パスごとに集計（デフォルト） |
| `-ftime-report=per-pass-run` | パス呼び出しごとに詳細表示 |

## 帳票レイアウト

### レイアウト概要

出力は以下の形式で表示される。

```
===-------------------------------------------------------------------------===
                      ... Pass execution timing report ...
===-------------------------------------------------------------------------===
  Total Execution Time: X.XXXX seconds (X.XXXX wall clock)

   ---User Time---   --System Time--   --User+System--   ---Wall Time---  --- Name ---
   X.XXXX ( XX.X%)   X.XXXX ( XX.X%)   X.XXXX ( XX.X%)   X.XXXX ( XX.X%)  PassName1
   X.XXXX ( XX.X%)   X.XXXX ( XX.X%)   X.XXXX ( XX.X%)   X.XXXX ( XX.X%)  PassName2
   ...
   X.XXXX (XXX.X%)   X.XXXX (XXX.X%)   X.XXXX (XXX.X%)   X.XXXX (XXX.X%)  Total

===-------------------------------------------------------------------------===
```

### 出力項目

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | User Time | ユーザーモード実行時間 | Timer | 秒（小数点4桁） |
| 2 | System Time | システムモード実行時間 | Timer | 秒（小数点4桁） |
| 3 | User+System | 合計CPU時間 | 計算値 | 秒（小数点4桁） |
| 4 | Wall Time | 壁時計時間 | Timer | 秒（小数点4桁） |
| 5 | パーセント | 全体に対する割合 | 計算値 | パーセント（小数点1桁） |
| 6 | Name | パス名 | PassInfo | 文字列 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| オプション指定 | `-ftime-report`を指定 | Yes |
| コンパイル実行 | コンパイル処理が行われた | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Wall Time | 降順（時間の長い順） |

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを使用せず、LLVM/Clangの内部タイマーから情報を取得する。

| データソース | 用途 | 取得方法 |
|-------------|------|---------|
| llvm::Timer | 時間計測 | タイマーAPI |
| llvm::TimeRegion | 時間領域管理 | RAII |
| llvm::TimerGroup | タイマーグループ | グループ管理 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| User+System | User Time + System Time | 浮動小数点 | - |
| パーセント | (個別時間 / 合計時間) * 100 | 小数点1桁 | - |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[コンパイル開始] --> B{-ftime-report?}
    B -->|No| C[通常コンパイル]
    B -->|Yes| D[タイマー有効化]
    D --> E[各パス実行時にタイマー計測]
    E --> F[コンパイル完了]
    F --> G[TimerGroup::printAll]
    G --> H[レポート出力]
    H --> I[終了]
    C --> I
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| - | - | - | エラーケースなし |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | パス数に依存（数十〜数百） |
| 目標出力時間 | 即座 |
| 同時出力数上限 | 1 |

## セキュリティ考慮事項

- パス名やソースファイル情報が出力に含まれる可能性がある
- ビルド環境の詳細が推測される可能性がある

## 備考

- LLVMの`llvm::Timer`インフラストラクチャを使用
- `TimePassesIsEnabled`グローバル変数で制御
- 各パスは`TimeRegion`で時間計測される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: テストケースから動作を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | time-report.c | `clang/test/Driver/time-report.c` | オプションの使用例 |
| 1-2 | time-report.f90 | `flang/test/Driver/time-report.f90` | Flangでの使用例 |

**読解のコツ**:
- RUNディレクティブでオプションの渡し方を確認
- CHECKディレクティブで出力形式を確認

#### Step 2: オプション定義を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | Options.td | `clang/include/clang/Options/Options.td` | `-ftime-report`オプション定義 |

#### Step 3: タイマー実装を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | Timer.h | `llvm/include/llvm/Support/Timer.h` | Timer, TimeRegion, TimerGroup定義 |
| 3-2 | Timer.cpp | `llvm/lib/Support/Timer.cpp` | 実装詳細 |

### プログラム呼び出し階層図

```
clang -ftime-report
    │
    ├─ CompilerInvocation::ParseCodeGenArgs
    │      └─ TimePassesIsEnabled = true
    │
    ├─ 各パス実行
    │      └─ TimeRegion Timer(...)
    │             ├─ startTimer()
    │             └─ stopTimer() (デストラクタ)
    │
    └─ TimerGroup::printAll
           └─ レポート出力
```

### データフロー図

```
[計測]                    [集計]                         [出力]

TimeRegion ──────────▶ Timer蓄積 ─────────────────┐
(パス開始/終了)            │                       │
                           │                       │
                    TimerGroup ────────────────────┤
                           │                       │
                           └─────────────────▶ printAll ──▶ stderr
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| time-report.c | `clang/test/Driver/time-report.c` | テスト | Clangテストケース |
| time-report.f90 | `flang/test/Driver/time-report.f90` | テスト | Flangテストケース |
| Options.td | `clang/include/clang/Options/Options.td` | 定義 | オプション定義 |
| CodeGenOptions.def | `clang/include/clang/Basic/CodeGenOptions.def` | 定義 | CodeGenオプション |
| Timer.h | `llvm/include/llvm/Support/Timer.h` | ヘッダー | タイマークラス |
| Timer.cpp | `llvm/lib/Support/Timer.cpp` | ソース | タイマー実装 |
