# 帳票設計書 19-SymbolReporter

## 概要

本ドキュメントは、include-fixerによるシンボル発見結果を報告するSymbolReporterインターフェースの設計仕様を定義する。SymbolReporterは、find-all-symbolsツールがソースコードから発見したシンボル情報を収集するための抽象インターフェースである。

### 本帳票の処理概要

SymbolReporterは、C/C++ソースコードを解析して発見したシンボル（クラス、関数、変数等）とそのヘッダーファイル情報を報告するためのインターフェースを定義する。このインターフェースを実装することで、シンボル情報をファイル、データベース、または他の形式で出力できる。

**業務上の目的・背景**：大規模なC++コードベースにおいて、必要なヘッダーファイルを特定することは困難な作業である。include-fixerツールは、シンボル名からその定義を含むヘッダーファイルを特定するために、事前にシンボルデータベースを構築する。SymbolReporterはこのデータベース構築のための共通インターフェースを提供する。

**帳票の利用シーン**：
- find-all-symbolsツールでのシンボルデータベース構築
- IDEのinclude補完機能のためのインデックス作成
- コードナビゲーション機能のためのシンボル収集

**主要な出力内容**：
1. ファイル名
2. シンボル情報のマップ（SymbolInfo::SignalMap）

**帳票の出力タイミング**：find-all-symbolsツールがソースファイルを解析した後、シンボル情報をreportSymbols関数経由で報告する。

**帳票の利用者**：IDE開発者、ビルドツール開発者、コード解析ツール開発者

## 帳票種別

シンボルレポート / インデックスレポート

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | コマンドライン | N/A | `find-all-symbols`ツール実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 実装依存（YAML等） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | 実装依存 |
| 出力方法 | reportSymbols仮想関数経由 |
| 文字コード | UTF-8 |

### インターフェース仕様

| 項目 | 内容 |
|-----|------|
| 基底クラス | SymbolReporter（抽象クラス） |
| 仮想関数 | reportSymbols |
| デストラクタ | virtual default |

## 帳票レイアウト

### インターフェース定義

```cpp
class SymbolReporter {
public:
  virtual ~SymbolReporter() = default;

  virtual void reportSymbols(llvm::StringRef FileName,
                             const SymbolInfo::SignalMap &Symbols) = 0;
};
```

### reportSymbols引数

| No | 引数名 | 型 | 説明 |
|----|-------|-----|------|
| 1 | FileName | llvm::StringRef | ソースファイル名 |
| 2 | Symbols | const SymbolInfo::SignalMap & | シンボル情報のマップ |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ソースファイル | 解析対象のC/C++ファイル | Yes |
| シンボル発見 | シンボルが1つ以上発見された | No |

### ソート順

実装依存

### 改ページ条件

N/A

## データベース参照仕様

### 参照テーブル一覧

本帳票はデータベースを使用せず、ASTからシンボル情報を取得する。

| データソース | 用途 | 取得方法 |
|-------------|------|---------|
| AST | シンボル情報抽出 | ClangASTパース |
| SymbolInfo | シンボルメタデータ | find-all-symbols解析 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| - | - | - | 計算項目なし |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[ソースファイル読み込み] --> B[Clang ASTパース]
    B --> C[シンボル収集]
    C --> D[SymbolInfo::SignalMap構築]
    D --> E[reportSymbols呼び出し]
    E --> F[実装クラスで出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| パースエラー | ソースファイルの構文エラー | Clangエラーメッセージ | ソースコード修正 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | ファイルあたり数百〜数千シンボル |
| 目標出力時間 | 実装依存 |
| 同時出力数上限 | 実装依存 |

## セキュリティ考慮事項

- シンボル名にはソースコード構造が反映される
- ファイルパス情報が含まれる

## 備考

- SymbolReporterは純粋仮想クラス（インターフェース）
- 具体的な出力形式は実装クラスが決定
- SymbolInfo::SignalMapはシンボル情報のコンテナ

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: インターフェースを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | SymbolReporter.h | `clang-tools-extra/clang-include-fixer/find-all-symbols/SymbolReporter.h` | SymbolReporterインターフェース定義（18-24行目） |

**読解のコツ**:
- 純粋仮想関数`reportSymbols`がインターフェースのコア
- デストラクタはvirtual defaultで定義

#### Step 2: 関連データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | SymbolInfo.h | `clang-tools-extra/clang-include-fixer/find-all-symbols/SymbolInfo.h` | SymbolInfo, SignalMap定義 |

### プログラム呼び出し階層図

```
find-all-symbols ツール
    │
    ├─ Clang AST パース
    │
    ├─ シンボル収集
    │      └─ SymbolInfo構築
    │
    └─ SymbolReporter::reportSymbols
           └─ (実装クラスの処理)
```

### データフロー図

```
[入力]                    [処理]                         [出力]

ソースファイル ──────▶ Clang AST ─────────────────┐
                          │                       │
                    シンボル抽出                   │
                          │                       │
                    SymbolInfo ────────────────────┤
                          │                       │
                    SignalMap ─────────────────────┤
                          │                       ▼
                    reportSymbols ────────▶ 実装依存
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| SymbolReporter.h | `clang-tools-extra/clang-include-fixer/find-all-symbols/SymbolReporter.h` | ヘッダー | インターフェース定義 |
| SymbolInfo.h | `clang-tools-extra/clang-include-fixer/find-all-symbols/SymbolInfo.h` | ヘッダー | シンボル情報定義 |
| FindAllSymbols.cpp | `clang-tools-extra/clang-include-fixer/find-all-symbols/FindAllSymbols.cpp` | ソース | シンボル収集実装 |
